/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.handlers.EventHandler;
import oreexcavation.handlers.MiningAgent;

public class MiningScheduler {
    public static final MiningScheduler INSTANCE = new MiningScheduler();
    private HashMap<UUID, MiningAgent> agents = new HashMap();
    private Stopwatch timer = Stopwatch.createStarted();

    private MiningScheduler() {
    }

    public MiningAgent getActiveAgent(UUID uuid) {
        return this.agents.get(uuid);
    }

    public void stopMining(EntityPlayerMP player) {
        MiningAgent a = this.agents.get(player.func_110124_au());
        if (a != null) {
            a.dropEverything();
        }
        this.agents.remove(player.func_110124_au());
    }

    public void startMining(EntityPlayerMP player, BlockPos pos, IBlockState state) {
        MiningAgent existing = this.agents.get(player.func_110124_au());
        if (existing != null) {
            existing.appendBlock(pos);
        } else {
            existing = new MiningAgent(player, pos, state);
            this.agents.put(player.func_110124_au(), existing);
        }
    }

    public void tickAgents() {
        ArrayList<Map.Entry<UUID, MiningAgent>> list = new ArrayList<Map.Entry<UUID, MiningAgent>>(this.agents.entrySet());
        this.timer.reset();
        this.timer.start();
        for (int i = list.size() - 1; i >= 0; --i) {
            MiningAgent a;
            if (ExcavationSettings.tpsGuard && this.timer.elapsed(TimeUnit.MILLISECONDS) > 40L) {
                EventHandler.skipNext = true;
                break;
            }
            Map.Entry entry = (Map.Entry)list.get(i);
            EventHandler.captureAgent = a = (MiningAgent)entry.getValue();
            boolean complete = a.tickMiner();
            EventHandler.captureAgent = null;
            if (!complete) continue;
            a.dropEverything();
            this.agents.remove(entry.getKey());
        }
        this.timer.stop();
    }

    public void resetAll() {
        this.agents.clear();
    }
}

