/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.common.base.Stopwatch;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.handlers.EventHandler;
import oreexcavation.overrides.ToolOverride;
import oreexcavation.overrides.ToolOverrideHandler;
import oreexcavation.utils.BigItemStack;
import oreexcavation.utils.ToolEffectiveCheck;
import oreexcavation.utils.XPHelper;
import org.apache.logging.log4j.Level;

public class MiningAgent {
    private ItemStack blockStack = null;
    private Item origTool = null;
    private List<BlockPos> mined = new ArrayList<BlockPos>();
    private List<BlockPos> scheduled = new ArrayList<BlockPos>();
    private final EntityPlayerMP player;
    private final BlockPos origin;
    private Block block;
    private int meta;
    private ToolOverride toolProps;
    private boolean subtypes = true;
    private List<BigItemStack> drops = new ArrayList<BigItemStack>();
    private int experience = 0;
    private Stopwatch timer = Stopwatch.createUnstarted();
    private static Method m_createStack = null;

    public MiningAgent(EntityPlayerMP player, BlockPos origin, IBlockState state) {
        this.player = player;
        this.origin = origin;
        this.block = state.func_177230_c();
        this.meta = this.block.func_176201_c(state);
        if (m_createStack != null) {
            try {
                this.blockStack = (ItemStack)m_createStack.invoke((Object)this.block, state);
                if (this.blockStack == null || this.blockStack.func_77973_b() == null) {
                    this.blockStack = null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.subtypes = this.blockStack == null ? true : !this.blockStack.func_77981_g();
        ItemStack held = player.func_184586_b(EnumHand.MAIN_HAND);
        Item item = this.origTool = held == null ? null : held.func_77973_b();
        if (held == null) {
            this.toolProps = new ToolOverride("", -1);
        } else {
            this.toolProps = ToolOverrideHandler.INSTANCE.getOverride(held);
            if (this.toolProps == null) {
                this.toolProps = new ToolOverride("", -1);
            }
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    this.appendBlock(origin.func_177982_a(i, j, k));
                }
            }
        }
    }

    public boolean tickMiner() {
        if (this.origin == null || this.player == null || !this.player.func_70089_S() || this.mined.size() >= this.toolProps.getLimit()) {
            return true;
        }
        this.timer.reset();
        this.timer.start();
        for (int n = 0; !(this.scheduled.size() <= 0 || n >= this.toolProps.getSpeed() || this.mined.size() >= this.toolProps.getLimit() || ExcavationSettings.tpsGuard && this.timer.elapsed(TimeUnit.MILLISECONDS) > 40L); ++n) {
            boolean flag;
            Item heldItem;
            ItemStack heldStack = this.player.func_184586_b(EnumHand.MAIN_HAND);
            Item item = heldItem = heldStack == null ? null : heldStack.func_77973_b();
            if (heldItem != this.origTool) {
                this.timer.stop();
                return true;
            }
            if (!this.hasEnergy(this.player)) {
                this.timer.stop();
                return true;
            }
            BlockPos pos = this.scheduled.remove(0);
            if (pos == null) continue;
            if (this.player.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)this.toolProps.getRange()) {
                this.mined.add(pos);
                continue;
            }
            IBlockState s = this.player.field_70170_p.func_180495_p(pos);
            Block b = s.func_177230_c();
            int m = b.func_176201_c(s);
            boolean bl = flag = b == this.block && (this.subtypes || m == this.meta);
            if (!flag && this.blockStack != null) {
                ItemStack stack = null;
                try {
                    stack = (ItemStack)m_createStack.invoke((Object)b, s);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (stack != null && stack.func_77973_b() == this.blockStack.func_77973_b() && stack.func_77952_i() == this.blockStack.func_77952_i()) {
                    flag = true;
                }
            }
            if (!flag) continue;
            if (!ExcavationSettings.ignoreTools && !ToolEffectiveCheck.canHarvestBlock(this.player.field_70170_p, s, pos, (EntityPlayer)this.player)) {
                this.mined.add(pos);
                continue;
            }
            if (this.player.field_71134_c.func_180237_b(pos)) {
                if (!this.player.func_184812_l_()) {
                    this.player.func_71024_bL().func_75113_a(this.toolProps.getExaustion());
                    if (this.toolProps.getExperience() > 0) {
                        XPHelper.addXP((EntityPlayer)this.player, -this.toolProps.getExperience(), false);
                    }
                }
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.appendBlock(pos.func_177982_a(i, j, k));
                        }
                    }
                }
            }
            this.mined.add(pos);
        }
        this.timer.stop();
        if (!this.player.func_184812_l_()) {
            XPHelper.syncXP(this.player);
        }
        return this.scheduled.size() <= 0 || this.mined.size() >= this.toolProps.getLimit();
    }

    public void appendBlock(BlockPos pos) {
        if (pos == null || this.mined.contains(pos) || this.scheduled.contains(pos)) {
            return;
        }
        if (this.player.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)this.toolProps.getRange()) {
            return;
        }
        this.scheduled.add(pos);
    }

    private boolean hasEnergy(EntityPlayerMP player) {
        return !(!(this.toolProps.getExaustion() <= 0.0f) && player.func_71024_bL().func_75116_a() <= 0 || this.toolProps.getExperience() > 0 && XPHelper.getPlayerXP((EntityPlayer)player) < (long)this.toolProps.getExperience());
    }

    public void dropEverything() {
        MiningAgent ca = EventHandler.captureAgent;
        EventHandler.captureAgent = null;
        boolean playSnd = false;
        for (BigItemStack bigStack : this.drops) {
            for (ItemStack stack : bigStack.getCombinedStacks()) {
                if (!this.player.field_71071_by.func_70441_a(stack)) {
                    this.player.func_146097_a(stack, true, false);
                    continue;
                }
                playSnd = true;
            }
        }
        if (playSnd) {
            this.player.field_70170_p.func_184148_a(null, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.player.func_70681_au().nextFloat() - this.player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (this.experience > 0) {
            this.player.func_71023_q(this.experience);
            this.player.field_70170_p.func_184148_a(null, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, SoundEvents.field_187607_bg, SoundCategory.PLAYERS, 0.1f, 0.5f * ((this.player.func_70681_au().nextFloat() - this.player.func_70681_au().nextFloat()) * 0.7f + 1.8f));
        }
        this.drops.clear();
        this.experience = 0;
        EventHandler.captureAgent = ca;
    }

    public void addItemDrop(ItemStack stack) {
        for (BigItemStack bigStack : this.drops) {
            if (!bigStack.getBaseStack().equals(stack)) continue;
            bigStack.stackSize += stack.field_77994_a;
            return;
        }
        this.drops.add(new BigItemStack(stack));
    }

    public void addExperience(int value) {
        this.experience += value;
    }

    static {
        try {
            m_createStack = Block.class.getDeclaredMethod("func_180643_i", IBlockState.class);
            m_createStack.setAccessible(true);
        }
        catch (Exception e1) {
            try {
                m_createStack = Block.class.getDeclaredMethod("createStackedBlock", IBlockState.class);
                m_createStack.setAccessible(true);
            }
            catch (Exception e2) {
                OreExcavation.logger.log(Level.INFO, "Unable to use block hooks for excavation", (Throwable)e2);
            }
        }
    }
}

