/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import oreexcavation.client.ExcavationKeys;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.handlers.ConfigHandler;
import oreexcavation.handlers.MiningAgent;
import oreexcavation.handlers.MiningScheduler;
import oreexcavation.network.PacketExcavation;
import oreexcavation.utils.ToolEffectiveCheck;

public class EventHandler {
    public static MiningAgent captureAgent;
    public static boolean skipNext;
    public static boolean isExcavating;
    private static int cTick;

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("oreexcavation")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K || event.getEntity().field_70128_L || event.isCanceled()) {
            return;
        }
        if (captureAgent != null) {
            if (event.getEntity() instanceof EntityItem) {
                EntityItem eItem = (EntityItem)event.getEntity();
                ItemStack stack = eItem.func_92059_d();
                captureAgent.addItemDrop(stack);
                event.setCanceled(true);
            } else if (event.getEntity() instanceof EntityXPOrb) {
                EntityXPOrb orb = (EntityXPOrb)event.getEntity();
                captureAgent.addExperience(orb.func_70526_d());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getWorld().field_72995_K || !(event.getPlayer() instanceof EntityPlayerMP) || event.getPlayer() instanceof FakePlayer) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getPlayer();
        if (player.func_184586_b(EnumHand.MAIN_HAND) == null && !ExcavationSettings.openHand) {
            return;
        }
        if (this.isToolBlacklisted(player.func_184586_b(EnumHand.MAIN_HAND)) != ExcavationSettings.invertTBlacklist) {
            return;
        }
        if (this.isBlockBlacklisted(event.getState().func_177230_c()) != ExcavationSettings.invertBBlacklist) {
            return;
        }
        if (event.getState().func_177230_c().isAir(event.getState(), (IBlockAccess)event.getWorld(), event.getPos())) {
            return;
        }
        BlockPos p = event.getPos();
        IBlockState s = event.getState();
        Block b = s.func_177230_c();
        int m = b.func_176201_c(s);
        if (ExcavationSettings.ignoreTools || ToolEffectiveCheck.canHarvestBlock(event.getWorld(), s, p, (EntityPlayer)player)) {
            MiningAgent agent = MiningScheduler.INSTANCE.getActiveAgent(player.func_110124_au());
            if (agent == null) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("x", p.func_177958_n());
                tag.func_74768_a("y", p.func_177956_o());
                tag.func_74768_a("z", p.func_177952_p());
                tag.func_74778_a("block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)b)).toString());
                tag.func_74768_a("meta", m);
                OreExcavation.instance.network.sendTo((IMessage)new PacketExcavation(tag), player);
            } else {
                agent.appendBlock(p);
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (skipNext) {
            skipNext = false;
            return;
        }
        MiningScheduler.INSTANCE.tickAgents();
        captureAgent = null;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if ((cTick = (cTick + 1) % 10) != 0 || Minecraft.func_71410_x().field_71439_g == null || !isExcavating || !ExcavationSettings.mustHold) {
            return;
        }
        boolean canContinue = true;
        if (ExcavationSettings.mineMode < 0) {
            canContinue = false;
        } else if (ExcavationSettings.mineMode == 0) {
            if (!ExcavationKeys.excavateKey.func_151470_d()) {
                canContinue = false;
            }
        } else if (ExcavationSettings.mineMode != 2 && !Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            canContinue = false;
        }
        if (!canContinue) {
            isExcavating = false;
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74757_a("cancel", true);
            OreExcavation.instance.network.sendToServer((IMessage)new PacketExcavation(tags));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K || event.getWorld().func_73046_m().func_71278_l()) {
            return;
        }
        MiningScheduler.INSTANCE.resetAll();
        captureAgent = null;
    }

    public boolean isBlockBlacklisted(Block block) {
        int[] oreIDs;
        if (block == null || block == Blocks.field_150350_a) {
            return false;
        }
        if (ExcavationSettings.blockBlacklist.contains(((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString())) {
            return true;
        }
        Item itemBlock = Item.func_150898_a((Block)block);
        if (itemBlock == null) {
            return false;
        }
        for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)new ItemStack(block))) {
            if (!ExcavationSettings.blockBlacklist.contains(OreDictionary.getOreName((int)id))) continue;
            return true;
        }
        return false;
    }

    public boolean isToolBlacklisted(ItemStack stack) {
        int[] oreIDs;
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (ExcavationSettings.toolBlacklist.contains(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString())) {
            return true;
        }
        for (int id : oreIDs = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (ExcavationSettings.toolBlacklist.contains(OreDictionary.getOreName((int)id)) == ExcavationSettings.invertTBlacklist) continue;
            return true;
        }
        return false;
    }

    static {
        skipNext = false;
        isExcavating = false;
        cTick = 0;
    }
}

