local debug = debug

local function tracebackex(msg)
	local ret = msg .. "\n"
	local level = 3
	local strlen = 0;
		
	ret = ret .. "stack traceback:\n"
	while true do
		-- ȡջϢ
		local info = debug.getinfo(level, "Sln")
		if not info then break end
		if info.what == "C" then                -- C function
			ret = ret .. tostring(level) .. "C function\n\tlocal:\n"
		else           -- Lua function
			ret = ret .. string.format("[%s]:%d in function `%s`\n\tlocal:\n", info.source, info.currentline, info.name or "")
		end
		--get local vars
		local i = 1
		while true do
			local name, value = debug.getlocal(level, i)

			if not name then break end
			strlen = 30 - string.len(name)
			if strlen > 0 then
				name = name .. string.rep(" ", strlen)
			end
			ret = ret .. string.format("\t%s= (%s)\t%s\n", name, type(value), tostring(value))
			i = i + 1
		end
		ret = ret .. "\n"
		level = level + 1
	end

	return ret
end

local function tracebackAndVarieble(msg)
	local common = LibStub("LibAddon"):GetAddon("common")
	if (common) then
		common.hiido:ReportError(msg)
	end
	__LOG__(tracebackex(tostring(msg) or ""), CEGUI.Errors)
	return msg
end

function geterrorhandler()
	return tracebackAndVarieble 
end

__G__TRACKBACK__PIP__ = tracebackAndVarieble
