local common = LibStub("LibAddon"):GetAddon("common")
common.hiido  ={}
local hiido = common.hiido

local HIIDO_REPORT_URL = "http://ylog.hiido.com/c.gif"
-- ӳ

local CHANNEL_TYPE_LINSHI = "0"		-- ʱƵ
local CHANNEL_TYPE_NORMAL = "1"		-- ͨƵ
local COUNT_TYPE_REMOVAL = "1"		-- ȥ
local COUNT_TYPE_NORMAL = "0"		-- 

common:add_const({
	["CHANNEL_TYPE_LINSHI"] = CHANNEL_TYPE_LINSHI,
	["CHANNEL_TYPE_NORMAL"] = CHANNEL_TYPE_NORMAL,
	["COUNT_TYPE_REMOVAL"] = COUNT_TYPE_REMOVAL,
	["COUNT_TYPE_NORMAL"] = COUNT_TYPE_NORMAL,
})

local error_pool = {}	-- 洢Ѿϱerror

local function doHeartBeat(ctype, channel_id, speak_time)
	local dataid = CUIControl:getSingleton():GetReportDataId()
	CUIControl:getSingleton():AddReportUrlAddr(dataid, HIIDO_REPORT_URL)
	CUIControl:getSingleton():MakeMd5Code(dataid,"inneryydo")
	CUIControl:getSingleton():AddKeyValueById(dataid,"ctype", ctype)
	CUIControl:getSingleton():AddKeyValueById(dataid,"sid", tostring(channel_id) or "0")
	CUIControl:getSingleton():AddKeyValueById(dataid,"st", tostring(speak_time) or "0")
	CUIControl:getSingleton():SendReportData(dataid)
end

local function addCount(ctype, key, count)
	if (not key) then return end
	local count = count or 1
	local dataid = CUIControl:getSingleton():GetReportDataId()
	CUIControl:getSingleton():AddReportUrlAddr(dataid, HIIDO_REPORT_URL)
	CUIControl:getSingleton():MakeMd5Code(dataid,"inneryycount")
	CUIControl:getSingleton():AddKeyValueById(dataid,"distinct", ctype)
	CUIControl:getSingleton():AddKeyValueById(dataid,"name", tostring(key))
	CUIControl:getSingleton():AddKeyValueById(dataid,"value", tostring(count) or "0")
	CUIControl:getSingleton():SendReportData(dataid)
end

function hiido:DoInstall()
	local dataid = CUIControl:getSingleton():GetReportDataId()
	CUIControl:getSingleton():AddReportUrlAddr(dataid, HIIDO_REPORT_URL)
	CUIControl:getSingleton():MakeMd5Code(dataid,"inneryyinstall")
	CUIControl:getSingleton():AddKeyValueById(dataid,"distinct", ctype)
	-- CUIControl:getSingleton():AddKeyValueById(dataid,"name", tostring(key))
	-- CUIControl:getSingleton():AddKeyValueById(dataid,"value", tostring(count) or "0")
	CUIControl:getSingleton():SendReportData(dataid)
end

function hiido:TeamVoiceTalking(team_name, player_name, stat)
	local dataid = CUIControl:getSingleton():GetReportDataId()
	CUIControl:getSingleton():AddReportUrlAddr(dataid, HIIDO_REPORT_URL)
	CUIControl:getSingleton():MakeMd5Code(dataid, "lolteam")
	CUIControl:getSingleton():AddKeyValueById(dataid,"teamhash", CUIControl:getSingleton():Md5(team_name))
	CUIControl:getSingleton():AddKeyValueById(dataid,"playerhash", CUIControl:getSingleton():Md5(player_name))
	CUIControl:getSingleton():AddKeyValueById(dataid,"stat", tostring(stat) or "0")
	CUIControl:getSingleton():SendReportData(dataid)
end

function hiido:DoYYHeartBeat(channel_id, speak_time)
	doHeartBeat(CHANNEL_TYPE_NORMAL, sid, st)
end

function hiido:DominiYYHeartBeat(channel_id, speak_time)
	doHeartBeat(CHANNEL_TYPE_LINSHI, sid, st)	
end

function hiido:Count(key, count)
	addCount(COUNT_TYPE_NORMAL, key, count)
end

function hiido:CountOnce(key, count)
	addCount(COUNT_TYPE_REMOVAL, key, count)
end

function hiido:Talking(team_name, player_name, stat)
	self:TeamVoiceTalking(team_name, player_name, stat)
end
-------------
-- ÷Ҫ
function hiido:ReportError(msg)
	if (type(msg) ~= "string") then return end

	local error_msg = msg:match("GUIFiles\\addons\\(.-):%s.*")
	common:print(msg, error_msg)
	if (error_msg and not error_pool[error_msg]) then
		error_pool[error_msg] = 1
		addCount(COUNT_TYPE_REMOVAL, "error", error_msg)
	end
end