--------------------------------------------------------------------------------
-- ļ: config.lua
-- : 2013-12-06
-- : Ӹ
-- : 豣ȫ÷װ
--------------------------------------------------------------------------------

--[[
---------
-- ʹ÷
---------
 default_config аʽӦ

---------
-- ӿ
---------
config:get(key)
: ȡkeyӦֵ 

config:set(key, value)
: keyӦֵ, COMMON_CONFIG_CHANGE¼

config:saveAll()
: е, COMMON_CONFIG_SAVED¼

--------
-- ¼
--------
COMMON_CONFIG_CHANGE
øıʱ
arg1(string)		- 
arg2(any)		- ֵ

COMMON_CONFIG_SAVED
ñ, ʱδκβ
]]


local common = LibStub("LibAddon"):GetAddon("common")
local config = common:NewModule("config", "LibEvent")


local function errorhandler(err)
	return geterrorhandler()(err)
end

local to_boolean = function(value)
	if tonumber(value) == 0 then
		return false
	else
		return true
	end
end

local app_name_speak = {"nSpeakMicType", "nSpeakMicKeyCode", "nSpeakMicScanCode", "bMuteVoice", "bMuteVoice", "bMuteMic",
	"bEnhanceMic", "nVoiceVolume", "nMicVolume", "bDenoiseFlag", "bAECflag",}
do
	for k, v in ipairs(app_name_speak) do
		app_name_speak[v] = k
	end
end

-----------------
-- ֻҪ޸
-- {, ȱʡֵ, ת}
local default_config = {
	-- SPEAK_INFO
	{"nSpeakMicType", common.const.g_speak_free, tonumber}, 
	{"nSpeakMicKeyCode", 113, tonumber}, 
	{"nSpeakMicScanCode", function () local code = config:get("nSpeakMicKeyCode"); return CUIControl:getSingleton():GetScanCodeFromVkCode(code) end}, 
	{"nSpeakMicMouseCode",0, tonumber}, 
	{"nSpeakMicEnvValue", 0, tonumber},
	{"bMuteVoice", 1, to_boolean}, 
	{"bMuteMic", 1, to_boolean}, 
	{"bEnhanceMic", 0, to_boolean}, 
	{"nVoiceVolume", 100, tonumber}, 
	{"nMicVolume", 100, tonumber}, 
	{"bDenoiseFlag", 0, to_boolean, tonumber}, 
	{"bAECflag", 0, to_boolean, tonumber}, 

	-- CONFIG_INFO
	{"nMainBarposX", common.const.g_defaultMainbarposX, tonumber}, 
	{"fMainBarscaleX", common.const.g_defaultMainbarscaleX, tonumber},
	{"nMainBarposY", common.const.g_defaultMainbarposY, tonumber}, 
	{"fMainBarscaleY", common.const.g_defaultMainbarscaleY, tonumber},
	{"bFirstLoad", 1, to_boolean},
	--{"nLoginWndposX", 0, tonumber}, 
	--{"nLoginWndposY", 0, tonumber}, 
	{"sLastUser", "", tostring}, 
}

function config:OnInitialize()
	self:print("OnInitialize")
	

	-- Դӡ
	for name, value in pairs(self.db) do
		self:debug(name, "=", tostring(value))
	end
end

local function get_app_name(key)
	local app_name = app_name_speak[key] and "SPEAK_INFO" or "CONFIG_INFO"
	
	return app_name
end

function config:init_config()
	self.db = {}

	for i, v in ipairs(default_config) do
		local app_name = get_app_name(v[1])		
		local name = v[1]
		local default_value = v[2]
		
		if (type(default_value) == "function") then
			local function call() self.db[name] = default_value() end
			xpcall(call, errorhandler)
		else
			self.db[name] = self:read(app_name ,name, default_value)
			if (v[3] and type(v[3]) == "function") then
				local function call() self.db[name] = v[3](self.db[name]) end
				xpcall(call, errorhandler)
			end
		end
	end
end

function config:get(key)
	if (self.db[key]) then
		return self.db[key]
	end	
	
	self:error("config:get() key", key, "is not a config key.")
	return nil
end

function config:set(key, value)
	self.db[key] = value
	self:write(get_app_name(key), key, value)
	self:SendMessage("COMMON_CONFIG_CHANGE", key, value)
end

function config:saveAll()
	for k, v in pairs(self.db) do
		local app_name = get_app_name(k)
		
		local value
		if (type(v) == "boolean") then
			value = v and 1 or 0
		else
			value = v
		end
		
		value = tostring(value)
		self:write(app_name, k, value)
	end

	self:SendMessage("COMMON_CONFIG_SAVED")
end

function config:read(appName, keyName, default)
	local result = CUIControl:getSingleton():GetSettingConf( appName, keyName )
	return (result:len() > 0 and result) or default;
end

function config:write(appName, keyName, keyText)
	if (type(keyText) == "boolean") then
		keyText = keyText and "1" or "0"
 	end
	keyText = tostring(keyText);
	CUIControl:getSingleton():SetSettingConf( appName, keyName, keyText)
end

config:init_config()