--------------------------------------------------------------------------------
-- ļ: inteface.lua
-- : 2013-12-07
-- : Ӹ
-- : ļȵĽӿ
--------------------------------------------------------------------------------

local common = LibStub("LibAddon"):GetAddon("common")
local config = common:GetModule("config")
local simplemsgbox = common:GetModule("simplemsgbox")
local ticket = common:GetModule("ticket")

local function get(self, key)
	return config:get(key)
end

local function set(self, key, value)
	config:set(key, value)
end

local function saveAll(self)
	config:saveAll()
end

local function read(self, appName, keyName, default)
	return config:read(appName, keyName, default)
end

local function write(self, appName, keyName, keyText)
	config:write(appName, keyName, keyText)
end

-- ʾ(ֻйرհť)Ϣ
-- title:, msg:Ϣ, pos_x:Ͻx, pos_y:Ͻy
function showSimpleMsgbox(self, title, msg, pos_x, pos_y)
	simplemsgbox:showSimpleMsgbox(title,msg,pos_x,pos_y)
end

local mixins = {
	get = get,
	set = set,
	saveAll = saveAll,
	read = read,
	write = write,
}

common:add_interface("config", mixins)

-- ϷIDϷID
common:add_global("g_game_id", -1)
common:add_global("g_game_server_id", -1)

local UI = {
	showSimpleMsgbox = showSimpleMsgbox,
}

common:add_interface("UI", UI)



local function requestTicket(self, obj, callback, service_id)
	ticket:requestTicket(obj, callback, service_id)
end

local ticket_func_table = {
	requestTicket = requestTicket,
}

common:add_interface("ticket", ticket_func_table)
