/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import com.sun.deploy.trace.Trace;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Random;

final class DeniedCertStore
implements CertStore {
    private KeyStore deniedKS = null;

    DeniedCertStore() {
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    public void load(boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (this.deniedKS == null) {
            try {
                this.deniedKS = KeyStore.getInstance("JKS");
                this.deniedKS.load(null, new char[0]);
            }
            catch (IOException iOException) {
                Trace.msgSecurityPrintln(iOException.getMessage());
            }
            catch (KeyStoreException keyStoreException) {
                Trace.msgSecurityPrintln(keyStoreException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Trace.msgSecurityPrintln(noSuchAlgorithmException.getMessage());
            }
            catch (CertificateException certificateException) {
                Trace.msgSecurityPrintln(certificateException.getMessage());
            }
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
    }

    public boolean add(Certificate certificate) throws KeyStoreException {
        return this.add(certificate, false);
    }

    public boolean add(Certificate certificate, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("deniedcertstore.cert.adding");
        String string = this.deniedKS.getCertificateAlias(certificate);
        boolean bl2 = true;
        if (string != null) {
            try {
                if (!bl || string.indexOf("$tsflag") > -1) {
                    bl2 = false;
                } else {
                    this.remove(certificate);
                }
            }
            catch (IOException iOException) {
                Trace.securityPrintException(iOException);
            }
        }
        if (bl2) {
            Random random = new Random();
            String string2 = null;
            while (this.deniedKS.getCertificate(string2 = bl ? "deploymentdeniedcert$tsflag" + random.nextLong() : "deploymentdeniedcert" + random.nextLong()) != null) {
            }
            this.deniedKS.setCertificateEntry(string2, certificate);
            Trace.msgSecurityPrintln("deniedcertstore.cert.added");
        }
        return true;
    }

    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("deniedcertstore.cert.removing");
        String string = this.deniedKS.getCertificateAlias(certificate);
        if (string != null) {
            this.deniedKS.deleteEntry(string);
        }
        Trace.msgSecurityPrintln("deniedcertstore.cert.removed");
        return true;
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        return this.contains(certificate, false);
    }

    public boolean contains(Certificate certificate, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("deniedcertstore.cert.instore");
        String string = this.deniedKS.getCertificateAlias(certificate);
        if (bl) {
            return string != null && string.indexOf("$tsflag") > -1;
        }
        return string != null;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        return false;
    }

    public Collection getCertificates() throws KeyStoreException {
        Trace.msgSecurityPrintln("deniedcertstore.cert.getcertificates");
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        Enumeration<String> enumeration = this.deniedKS.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this.deniedKS.getCertificate(string);
            arrayList.add(certificate);
        }
        return arrayList;
    }
}

