/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Security;
import java.security.cert.Certificate;
import sun.security.provider.PolicyFile;

public final class CeilingPolicy {
    private static PermissionCollection _trustedPerms = null;
    private static boolean _initialized = false;

    public static void addTrustedPermissions(PermissionCollection permissionCollection) {
        Object object;
        if (!_initialized) {
            _initialized = true;
            object = Config.getStringProperty("deployment.security.trusted.policy");
            if (object != null && ((String)object).length() > 0) {
                CodeSource codeSource = new CodeSource((URL)null, (Certificate[])null);
                int n = 1;
                while (Security.getProperty("policy.url." + n) != null) {
                    ++n;
                }
                String string = "policy.url." + n;
                Security.setProperty(string, (String)object);
                try {
                    PolicyFile policyFile = new PolicyFile();
                    _trustedPerms = ((Policy)policyFile).getPermissions(codeSource);
                }
                catch (Exception exception) {
                    Trace.ignoredException(exception);
                }
                Security.setProperty(string, "");
            } else {
                _trustedPerms = new Permissions();
                _trustedPerms.add(new AllPermission());
            }
        }
        if (_trustedPerms != null) {
            object = _trustedPerms.elements();
            while (object.hasMoreElements()) {
                permissionCollection.add((Permission)object.nextElement());
            }
        }
    }
}

