/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceObject;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.UpdateTracker;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;

public class MemoryCache {
    private static final Map loadedResource;
    private static ReferenceQueue refQueue;
    private static Thread cleanupThread;

    static synchronized void reset() {
        loadedResource.clear();
    }

    public static synchronized Object addLoadedResource(String string, Object object) {
        LoadedResourceReference loadedResourceReference;
        LoadedResourceReference loadedResourceReference2 = (LoadedResourceReference)loadedResource.get(string);
        if (loadedResourceReference2 != null && loadedResourceReference2.get() != null) {
            if (object == loadedResourceReference2.get()) {
                return null;
            }
            if (loadedResourceReference2.getReferenceCount() > 0 && DownloadEngine.isBackgroundUpdateRequest()) {
                return null;
            }
            Trace.println("Replacing MemoryCache entry (cnt=" + loadedResourceReference2.refcnt + ") for " + string + "was=" + loadedResourceReference2.get().getClass().getName() + " (" + loadedResourceReference2.get().hashCode() + ")" + " now=" + object.getClass().getName() + " (" + object.hashCode() + ")", TraceLevel.CACHE);
        }
        LoadedResourceReference loadedResourceReference3 = new LoadedResourceReference(object);
        if (!(object instanceof CacheEntry)) {
            loadedResourceReference3.registerReference(new CachedResourceReference(object, refQueue, string));
        }
        if ((loadedResourceReference = loadedResource.put(string, loadedResourceReference3)) != null) {
            return loadedResourceReference.get();
        }
        return null;
    }

    public static synchronized Object getLoadedResource(String string) {
        LoadedResourceReference loadedResourceReference = (LoadedResourceReference)loadedResource.get(string);
        if (loadedResourceReference == null) {
            return null;
        }
        Object object = loadedResourceReference.get();
        if (object != null) {
            if (MemoryCache.validateResource(object)) {
                MemoryCache.addResourceReference(object, string);
                return object;
            }
            loadedResource.remove(string);
        }
        return null;
    }

    static synchronized Object removeLoadedResource(String string) {
        LoadedResourceReference loadedResourceReference = (LoadedResourceReference)loadedResource.remove(string);
        if (loadedResourceReference != null) {
            Object object = loadedResourceReference.get();
            Trace.println("MemoryCache: removed entry " + string, TraceLevel.CACHE);
            return object;
        }
        return null;
    }

    public static synchronized void clearLoadedResources() {
        loadedResource.clear();
        UpdateTracker.clear();
        DownloadEngine.clearNoCacheJarFileList();
    }

    public static synchronized void shutdown() {
        MemoryCache.closeJars();
        MemoryCache.clearLoadedResources();
    }

    private static synchronized void closeJars() {
        Iterator iterator = loadedResource.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            MemoryCache.ensureJarsClosed(entry.getValue());
        }
        MemoryCache.reset();
    }

    private static void ensureJarsClosed(Object object) {
        if (object instanceof LoadedResourceReference) {
            LoadedResourceReference loadedResourceReference = (LoadedResourceReference)object;
            MemoryCache.closeIfJar(loadedResourceReference.get());
            Iterator iterator = loadedResourceReference.getReferences();
            while (iterator.hasNext()) {
                CachedResourceReference cachedResourceReference = (CachedResourceReference)iterator.next();
                MemoryCache.closeIfJar(cachedResourceReference.get());
            }
        }
    }

    private static void closeIfJar(Object object) {
        try {
            if (object instanceof CacheEntry) {
                CacheEntry cacheEntry = (CacheEntry)object;
                object = cacheEntry.getRefJar();
            } else if (object instanceof Resource && ((Resource)object).isJarFile()) {
                object = ((Resource)object).getJarFile();
            }
            if (object instanceof ResourceObject) {
                ((ResourceObject)object).doClose();
            } else if (object instanceof JarFile) {
                ((JarFile)object).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static synchronized void addResourceReference(Object object, String string) {
        LoadedResourceReference loadedResourceReference = (LoadedResourceReference)loadedResource.get(string);
        if (loadedResourceReference != null) {
            loadedResourceReference.registerReference(new CachedResourceReference(object, refQueue, string));
        }
    }

    static synchronized boolean contains(String string) {
        return loadedResource.containsKey(string);
    }

    private static boolean validateResource(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof CacheEntry) {
            CacheEntry cacheEntry = (CacheEntry)object;
            if (Cache.hasIncompatibleCompressEncoding(cacheEntry)) {
                return false;
            }
            if (!cacheEntry.storageFilesExist()) {
                return false;
            }
        }
        return true;
    }

    public static synchronized boolean isCacheEntryLoaded(String string, String string2) {
        CacheEntry cacheEntry;
        Object object = MemoryCache.getLoadedResource(string);
        return object instanceof CacheEntry && ((cacheEntry = (CacheEntry)object).getVersion() == null && string2 == null || string2 != null && string2.equals(cacheEntry.getVersion()));
    }

    static int getReferenceCount(String string) {
        LoadedResourceReference loadedResourceReference = (LoadedResourceReference)loadedResource.get(string);
        return loadedResourceReference == null ? 0 : loadedResourceReference.getReferenceCount();
    }

    static LoadedResourceReference getReferences(String string) {
        return (LoadedResourceReference)loadedResource.get(string);
    }

    static synchronized boolean hasReferencesTo(ResourceObject resourceObject) {
        String string = resourceObject.getResourceURL().toString();
        LoadedResourceReference loadedResourceReference = (LoadedResourceReference)loadedResource.get(string);
        if (loadedResourceReference != null && loadedResourceReference.get() instanceof CacheEntry) {
            Resource resource = (Resource)loadedResourceReference.get();
            return resource != null && resource.getJarFile() == resourceObject;
        }
        return false;
    }

    static {
        refQueue = new ReferenceQueue();
        loadedResource = new HashMap();
        cleanupThread = new LoadedResourceCleanupThread("CacheMemoryCleanUpThread");
        cleanupThread.setDaemon(true);
        cleanupThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                MemoryCache.shutdown();
            }
        });
    }

    private static class CachedResourceReference
    extends WeakReference {
        String url;

        public CachedResourceReference(Object object, ReferenceQueue referenceQueue, String string) {
            super(object, referenceQueue);
            this.url = string;
        }

        public String getURL() {
            return this.url;
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(Object object) {
            CachedResourceReference cachedResourceReference = (CachedResourceReference)object;
            return cachedResourceReference != null && this.get() == cachedResourceReference.get() && this.url.equals(cachedResourceReference.getURL());
        }
    }

    static class LoadedResourceCleanupThread
    extends Thread {
        LoadedResourceCleanupThread(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        CachedResourceReference cachedResourceReference = (CachedResourceReference)refQueue.remove();
                        Map map = loadedResource;
                        synchronized (map) {
                            String string = cachedResourceReference.getURL();
                            LoadedResourceReference loadedResourceReference = (LoadedResourceReference)loadedResource.get(string);
                            if (loadedResourceReference != null && loadedResourceReference.deregisterReference(cachedResourceReference)) {
                                MemoryCache.removeLoadedResource(string);
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception exception) {
                    if (!Trace.isEnabled(TraceLevel.CACHE)) continue;
                    Trace.ignored(exception);
                    continue;
                }
                break;
            }
        }
    }

    static class LoadedResourceReference {
        private Set resourceRefs = new HashSet();
        private int refcnt = 0;
        Object o;

        LoadedResourceReference(Object object) {
            this.o = object;
        }

        Object get() {
            return this.o;
        }

        synchronized void registerReference(Reference reference) {
            if (this.resourceRefs.add(reference)) {
                ++this.refcnt;
            }
        }

        synchronized boolean deregisterReference(Reference reference) {
            --this.refcnt;
            this.resourceRefs.remove(reference);
            return this.refcnt <= 1;
        }

        synchronized int getReferenceCount() {
            return this.refcnt;
        }

        synchronized Iterator getReferences() {
            return this.resourceRefs.iterator();
        }
    }
}

