/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class CachedManifest
extends Manifest {
    String resourceURL;
    boolean isReduced = false;
    boolean postponePostprocessing = false;
    static Field fEntries = null;
    static Field fAttributes = null;
    static /* synthetic */ Class class$java$util$jar$Manifest;
    static /* synthetic */ Class class$java$util$jar$Attributes;

    CachedManifest(String string, byte[] byArray, boolean bl) throws IOException {
        this.resourceURL = string;
        this.readFromBytes(byArray);
        this.isReduced = bl;
    }

    CachedManifest(Manifest manifest) throws IOException {
        try {
            if (fAttributes != null && fEntries != null) {
                fAttributes.set(this, fAttributes.get(manifest));
                fEntries.set(this, fEntries.get(manifest));
            }
        }
        catch (Exception exception) {
            fAttributes = null;
            fEntries = null;
        }
        this.isReduced = false;
    }

    public synchronized Map getEntries() {
        this.loadFullManifest();
        return super.getEntries();
    }

    private Map getEntriesLocal() {
        if (this.isReduced) {
            try {
                if (fEntries != null) {
                    return (Map)fEntries.get(this);
                }
            }
            catch (Exception exception) {
                Trace.ignoredException(exception);
            }
        }
        return this.getEntries();
    }

    public synchronized Attributes getAttributes(String string) {
        Map map;
        if (!CachedManifest.belongsToReducedManifest(string)) {
            this.loadFullManifest();
        }
        if ((map = this.getEntriesLocal()) != null) {
            return (Attributes)map.get(string);
        }
        return null;
    }

    public synchronized void clear() {
        super.clear();
        this.isReduced = false;
    }

    public int hashCode() {
        if (this.resourceURL != null) {
            return this.resourceURL.hashCode();
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof CachedManifest) {
            CachedManifest cachedManifest = (CachedManifest)object;
            if (this.resourceURL != null && this.resourceURL.equals(cachedManifest.resourceURL)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        CachedManifest cachedManifest = (CachedManifest)super.clone();
        cachedManifest.resourceURL = this.resourceURL;
        cachedManifest.isReduced = this.isReduced;
        return cachedManifest;
    }

    synchronized void postprocess() {
        if (!Environment.isJavaPlugin()) {
            this.getMainAttributes().remove(Attributes.Name.CLASS_PATH);
        }
        this.makeManifestImmutable(this);
    }

    private CacheEntry getCacheEntry() {
        CacheEntry cacheEntry = (CacheEntry)MemoryCache.getLoadedResource(this.resourceURL);
        if (cacheEntry == null) {
            Trace.println("Missing CacheEntry for " + this.resourceURL + "\n" + cacheEntry, TraceLevel.CACHE);
        }
        return cacheEntry;
    }

    private void loadFullManifest() {
        if (!this.isReduced) {
            return;
        }
        Trace.print("Loading full manifest for " + this.resourceURL, TraceLevel.CACHE);
        CacheEntry cacheEntry = this.getCacheEntry();
        if (cacheEntry != null) {
            try {
                byte[] byArray = cacheEntry.getFullManifestBytes();
                if (byArray != null) {
                    try {
                        Field field = (class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = CachedManifest.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest).getDeclaredField("attr");
                        field.setAccessible(true);
                        Field field2 = (class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = CachedManifest.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest).getDeclaredField("entries");
                        field2.setAccessible(true);
                        field.set(this, new Attributes());
                        field2.set(this, new HashMap());
                        this.isReduced = false;
                        this.readFromBytes(byArray);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
    }

    private int writeCompressed(Manifest manifest, OutputStream outputStream) throws IOException {
        if (manifest == null) {
            return 0;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        manifest.write(gZIPOutputStream);
        gZIPOutputStream.flush();
        gZIPOutputStream.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        outputStream.write(byArray);
        return byArray.length;
    }

    int writeReduced(OutputStream outputStream) throws IOException {
        Manifest manifest = this.reduce();
        return this.writeCompressed(manifest, outputStream);
    }

    int writeFull(OutputStream outputStream) throws IOException {
        this.loadFullManifest();
        return this.writeCompressed(this, outputStream);
    }

    private void readFromBytes(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        this.read(gZIPInputStream);
        gZIPInputStream.close();
        byteArrayInputStream.close();
    }

    public void read(InputStream inputStream) throws IOException {
        super.read(inputStream);
        if (!this.postponePostprocessing) {
            this.postprocess();
        }
    }

    private static boolean belongsToReducedManifest(String string) {
        return string.endsWith("/");
    }

    private Manifest reduce() {
        if (this.isReduced) {
            return this;
        }
        if (this.getEntries().size() < 25) {
            return null;
        }
        Manifest manifest = new Manifest();
        int n = 0;
        Attributes attributes = manifest.getMainAttributes();
        attributes.putAll((Map<?, ?>)this.getMainAttributes());
        Map<String, Attributes> map = manifest.getEntries();
        Iterator iterator = this.getEntries().keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (CachedManifest.belongsToReducedManifest(string)) {
                Attributes attributes2 = this.getAttributes(string);
                map.put(string, attributes2);
                continue;
            }
            ++n;
        }
        if (n < 25) {
            return null;
        }
        return manifest;
    }

    private void replaceAttributesMapWithImmutableMap(Attributes attributes) {
        try {
            Field field = (class$java$util$jar$Attributes == null ? (class$java$util$jar$Attributes = CachedManifest.class$("java.util.jar.Attributes")) : class$java$util$jar$Attributes).getDeclaredField("map");
            field.setAccessible(true);
            Map map = (Map)field.get(attributes);
            if (map != null) {
                map = Collections.unmodifiableMap(map);
                field.set(attributes, map);
            }
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }

    private void replaceEntriesMapWithImmutableMap(Manifest manifest) {
        try {
            Field field = (class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = CachedManifest.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest).getDeclaredField("entries");
            field.setAccessible(true);
            Map map = (Map)field.get(manifest);
            if (map != null) {
                this.makeEntriesAttributesImmutable(map);
                map = Collections.unmodifiableMap(map);
                field.set(manifest, map);
            }
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }

    private void makeEntriesAttributesImmutable(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            if (!(v instanceof Attributes)) continue;
            this.replaceAttributesMapWithImmutableMap((Attributes)v);
        }
    }

    private void makeManifestImmutable(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        this.replaceAttributesMapWithImmutableMap(attributes);
        this.replaceEntriesMapWithImmutableMap(manifest);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            fAttributes = (class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = CachedManifest.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest).getDeclaredField("attr");
            fAttributes.setAccessible(true);
            fEntries = (class$java$util$jar$Manifest == null ? (class$java$util$jar$Manifest = CachedManifest.class$("java.util.jar.Manifest")) : class$java$util$jar$Manifest).getDeclaredField("entries");
            fEntries.setAccessible(true);
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
    }
}

