/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.StringUtils;
import com.sun.deploy.util.SystemUtils;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;

public class Environment {
    public static final int ENV_PLUGIN = 0;
    public static final int ENV_JAVAWS = 1;
    public static final int ENV_JCP = 2;
    private static int environmentType = 0;
    public static final int JAVAFX_INSTALL_ONDEMAND = 0;
    public static final int JAVAFX_INSTALL_PRELOAD_INSTALLER = 1;
    public static final int JAVAFX_INSTALL_AUTOUPDATE = 2;
    private static int javaFxInstallMode = 0;
    private static boolean getenvSupported = true;
    private static boolean _javafx_install_initiated = false;
    private static String codebaseOverride = null;
    private static URL codebase = null;
    private static Date timestamp = null;
    private static Date expiration = null;
    private static String userAgent = null;
    private static boolean isSystemCache = false;
    private static boolean isSilentMode = false;
    private static boolean isImportMode = false;
    private static boolean isInstallMode = false;
    private static boolean _getenvSupported = true;
    private static String _javaHome;
    private static File deployment_home;
    private static String deploy_home_path;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$sun$deploy$Environment;

    public static boolean isJavaFXInstallInitiated() {
        return _javafx_install_initiated;
    }

    public static void setDownloadInitiated(boolean bl) {
        if (Environment.getJavaFxInstallMode() != 0) {
            _javafx_install_initiated = bl;
        }
    }

    public static boolean allowAltJavaFxRuntimeURL() {
        try {
            if (getenvSupported && System.getenv("ALLOW_ALT_JAVAFX_RT_URL") != null) {
                return true;
            }
        }
        catch (Error error) {
            getenvSupported = false;
        }
        return false;
    }

    public static int getJavaFxInstallMode() {
        return javaFxInstallMode;
    }

    public static void setJavaFxInstallMode(int n) {
        if (!(Environment.isImportMode() || n != 1 && n != 2)) {
            return;
        }
        javaFxInstallMode = n;
    }

    public static void setEnvironmentType(int n) {
        environmentType = n;
    }

    public static boolean isJavaWebStart() {
        return environmentType == 1;
    }

    public static boolean isJavaControlPanel() {
        return environmentType == 2;
    }

    public static boolean isJavaPlugin() {
        return environmentType == 0;
    }

    public static void setImportModeTimestamp(Date date) {
        timestamp = date;
    }

    public static Date getImportModeTimestamp() {
        return timestamp;
    }

    public static void setImportModeExpiration(Date date) {
        expiration = date;
    }

    public static Date getImportModeExpiration() {
        return expiration;
    }

    public static void setImportModeCodebase(URL uRL) {
        codebase = uRL;
    }

    public static void setImportModeCodebaseOverride(String string) {
        if (string != null && !string.endsWith("/")) {
            string = string + "/";
        }
        codebaseOverride = string;
    }

    public static URL getImportModeCodebase() {
        return codebase;
    }

    public static String getImportModeCodebaseOverride() {
        return codebaseOverride;
    }

    public static void setUserAgent(String string) {
        userAgent = string;
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static boolean isSystemCacheMode() {
        return isSystemCache;
    }

    public static void setSystemCacheMode(boolean bl) {
        isSystemCache = bl;
    }

    public static boolean isSilentMode() {
        return isSilentMode;
    }

    public static void setSilentMode(boolean bl) {
        isSilentMode = bl;
    }

    public static boolean isImportMode() {
        return isImportMode;
    }

    public static void setImportMode(boolean bl) {
        isImportMode = bl;
    }

    public static boolean isInstallMode() {
        return isInstallMode;
    }

    public static void setInstallMode(boolean bl) {
        isInstallMode = bl;
    }

    public static String getenv(String string) {
        try {
            if (_getenvSupported && string != null) {
                return System.getenv(string);
            }
        }
        catch (Error error) {
            _getenvSupported = false;
        }
        return null;
    }

    public static String getForcedJreRoot() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Environment.getenv("FORCED_JRE_ROOT");
            }
        });
    }

    public static String getForcedDeployRoot() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Environment.getenv("FORCED_DEPLOY_ROOT");
            }
        });
    }

    public static String getForcedBootClassPath() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Environment.getenv("FORCED_BOOTCLASSPATH");
            }
        });
    }

    public static boolean isForcedJreRoot(String string) {
        return Environment.getForcedJreRoot() != null && string != null && string.startsWith(Environment.getForcedJreRoot());
    }

    public static String getJavaHome() {
        if (_javaHome == null) {
            String string = Environment.getForcedDeployRoot();
            if (string != null) {
                _javaHome = string;
            } else {
                string = System.getProperty("jnlpx.home");
                string = string != null ? string.substring(0, string.lastIndexOf(File.separator)) : System.getProperty("java.home");
                _javaHome = string;
            }
        }
        return _javaHome;
    }

    public static void setJavaHome(String string) {
        _javaHome = string;
    }

    public static String getJavawsCommand() {
        String string = Environment.getDeploymentHomePath();
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        string = string + "bin" + File.separator + "javaws" + Platform.get().getPlatformExtension();
        return string;
    }

    private static File constructJavawPath(File file) {
        boolean bl = Config.getOSName().indexOf("Windows") != -1;
        return new File(file, "bin" + File.separator + (bl ? "javaw" : "java") + Platform.get().getPlatformExtension());
    }

    public static String getJavawCommand() {
        File file = null;
        File file2 = new File(SystemUtils.getJarPath(class$java$lang$Object == null ? (class$java$lang$Object = Environment.class$("java.lang.Object")) : class$java$lang$Object));
        if (file2 != null) {
            file = Environment.constructJavawPath(file2.getParentFile().getParentFile());
            if (!file.exists()) {
                file = Environment.constructJavawPath(file2.getParentFile());
            }
        } else {
            file = Environment.constructJavawPath(new File(System.getProperty("java.home")));
        }
        return file.getPath();
    }

    public static File getDeploymentHome() {
        String[] stringArray;
        if (null != deployment_home) {
            return deployment_home;
        }
        String string = Environment.getForcedDeployRoot();
        if (string != null && ((stringArray = new File(string)).exists() || stringArray.isDirectory())) {
            Trace.println("Use deploy home from FORCED_DEPLOY_ROOT: " + string, TraceLevel.BASIC);
            deployment_home = stringArray;
            return deployment_home;
        }
        string = System.getProperty("sun.boot.class.path");
        try {
            stringArray = string.split(File.pathSeparator);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            stringArray = StringUtils.splitString(string, File.pathSeparator);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith("deploy.jar")) continue;
            deployment_home = new File(stringArray[i]).getParentFile().getParentFile();
            Trace.println("Derive deploy home from bootclasspath: " + stringArray[i], TraceLevel.BASIC);
            return deployment_home;
        }
        try {
            String string2 = (class$com$sun$deploy$Environment == null ? (class$com$sun$deploy$Environment = Environment.class$("com.sun.deploy.Environment")) : class$com$sun$deploy$Environment).getProtectionDomain().getCodeSource().getLocation().getPath();
            String string3 = URLDecoder.decode(string2, "UTF-8");
            deployment_home = new File(string3).getParentFile().getParentFile();
            if (deployment_home.exists()) {
                return deployment_home;
            }
            deployment_home = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        string = Environment.getJavaHome();
        Trace.println("Assume Java home: " + string, TraceLevel.BASIC);
        deployment_home = new File(string);
        return deployment_home;
    }

    public static String getDeploymentHomePath() {
        if (deploy_home_path == null) {
            try {
                deploy_home_path = Environment.getDeploymentHome().getCanonicalPath();
            }
            catch (Exception exception) {
                deploy_home_path = Environment.getDeploymentHome().getPath();
            }
        }
        return deploy_home_path;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        deployment_home = null;
        deploy_home_path = null;
    }
}

