/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import sun.nio.fs.AbstractAclFileAttributeView;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.nio.fs.WindowsSecurity;
import sun.nio.fs.WindowsSecurityDescriptor;
import sun.nio.fs.WindowsUserPrincipals;

class WindowsAclFileAttributeView
extends AbstractAclFileAttributeView {
    private static final short SIZEOF_SECURITY_DESCRIPTOR = 20;
    private final WindowsPath file;
    private final boolean followLinks;

    WindowsAclFileAttributeView(WindowsPath windowsPath, boolean bl) {
        this.file = windowsPath;
        this.followLinks = bl;
    }

    private void checkAccess(WindowsPath windowsPath, boolean bl, boolean bl2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (bl) {
                securityManager.checkRead(windowsPath.getPathForPermissionCheck());
            }
            if (bl2) {
                securityManager.checkWrite(windowsPath.getPathForPermissionCheck());
            }
            securityManager.checkPermission(new RuntimePermission("accessUserInformation"));
        }
    }

    static NativeBuffer getFileSecurity(String string, int n) throws IOException {
        int n2 = 0;
        try {
            n2 = WindowsNativeDispatcher.GetFileSecurity(string, n, 0L, 0);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(string);
        }
        assert (n2 > 0);
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(n2);
        try {
            while (true) {
                int n3;
                if ((n3 = WindowsNativeDispatcher.GetFileSecurity(string, n, nativeBuffer.address(), n2)) <= n2) {
                    return nativeBuffer;
                }
                nativeBuffer.release();
                nativeBuffer = NativeBuffers.getNativeBuffer(n3);
                n2 = n3;
            }
        }
        catch (WindowsException windowsException) {
            nativeBuffer.release();
            windowsException.rethrowAsIOException(string);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserPrincipal getOwner() throws IOException {
        this.checkAccess(this.file, true, false);
        String string = WindowsLinkSupport.getFinalPath(this.file, this.followLinks);
        NativeBuffer nativeBuffer = WindowsAclFileAttributeView.getFileSecurity(string, 1);
        try {
            long l = WindowsNativeDispatcher.GetSecurityDescriptorOwner(nativeBuffer.address());
            if (l == 0L) {
                throw new IOException("no owner");
            }
            UserPrincipal userPrincipal = WindowsUserPrincipals.fromSid(l);
            return userPrincipal;
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(this.file);
            UserPrincipal userPrincipal = null;
            return userPrincipal;
        }
        finally {
            nativeBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AclEntry> getAcl() throws IOException {
        this.checkAccess(this.file, true, false);
        String string = WindowsLinkSupport.getFinalPath(this.file, this.followLinks);
        NativeBuffer nativeBuffer = WindowsAclFileAttributeView.getFileSecurity(string, 4);
        try {
            List<AclEntry> list = WindowsSecurityDescriptor.getAcl(nativeBuffer.address());
            return list;
        }
        finally {
            nativeBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOwner(UserPrincipal userPrincipal) throws IOException {
        if (userPrincipal == null) {
            throw new NullPointerException("'owner' is null");
        }
        if (!(userPrincipal instanceof WindowsUserPrincipals.User)) {
            throw new ProviderMismatchException();
        }
        WindowsUserPrincipals.User user = (WindowsUserPrincipals.User)userPrincipal;
        this.checkAccess(this.file, false, true);
        String string = WindowsLinkSupport.getFinalPath(this.file, this.followLinks);
        long l = 0L;
        try {
            l = WindowsNativeDispatcher.ConvertStringSidToSid(user.sidString());
        }
        catch (WindowsException windowsException) {
            throw new IOException("Failed to get SID for " + user.getName() + ": " + windowsException.errorString());
        }
        try {
            NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(20);
            try {
                WindowsNativeDispatcher.InitializeSecurityDescriptor(nativeBuffer.address());
                WindowsNativeDispatcher.SetSecurityDescriptorOwner(nativeBuffer.address(), l);
                WindowsSecurity.Privilege privilege = WindowsSecurity.enablePrivilege("SeRestorePrivilege");
                try {
                    WindowsNativeDispatcher.SetFileSecurity(string, 1, nativeBuffer.address());
                }
                finally {
                    privilege.drop();
                }
            }
            catch (WindowsException windowsException) {
                windowsException.rethrowAsIOException(this.file);
            }
            finally {
                nativeBuffer.release();
            }
        }
        finally {
            WindowsNativeDispatcher.LocalFree(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAcl(List<AclEntry> list) throws IOException {
        this.checkAccess(this.file, false, true);
        String string = WindowsLinkSupport.getFinalPath(this.file, this.followLinks);
        WindowsSecurityDescriptor windowsSecurityDescriptor = WindowsSecurityDescriptor.create(list);
        try {
            WindowsNativeDispatcher.SetFileSecurity(string, 4, windowsSecurityDescriptor.address());
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(this.file);
        }
        finally {
            windowsSecurityDescriptor.release();
        }
    }
}

