/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.loading.ClassLoaderRepository;

public class MBeanServerFactory {
    private static MBeanServerBuilder builder = null;
    private static final ArrayList<MBeanServer> mBeanServerList = new ArrayList();

    private MBeanServerFactory() {
    }

    public static void releaseMBeanServer(MBeanServer mBeanServer) {
        MBeanServerFactory.checkPermission("releaseMBeanServer");
        MBeanServerFactory.removeMBeanServer(mBeanServer);
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(null);
    }

    public static MBeanServer createMBeanServer(String string) {
        MBeanServerFactory.checkPermission("createMBeanServer");
        MBeanServer mBeanServer = MBeanServerFactory.newMBeanServer(string);
        MBeanServerFactory.addMBeanServer(mBeanServer);
        return mBeanServer;
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer newMBeanServer(String string) {
        MBeanServerBuilder mBeanServerBuilder;
        MBeanServerFactory.checkPermission("newMBeanServer");
        MBeanServerBuilder mBeanServerBuilder2 = mBeanServerBuilder = MBeanServerFactory.getNewMBeanServerBuilder();
        synchronized (mBeanServerBuilder2) {
            MBeanServerDelegate mBeanServerDelegate = mBeanServerBuilder.newMBeanServerDelegate();
            if (mBeanServerDelegate == null) {
                throw new JMRuntimeException("MBeanServerBuilder.newMBeanServerDelegate() returned null");
            }
            MBeanServer mBeanServer = mBeanServerBuilder.newMBeanServer(string, null, mBeanServerDelegate);
            if (mBeanServer == null) {
                throw new JMRuntimeException("MBeanServerBuilder.newMBeanServer() returned null");
            }
            return mBeanServer;
        }
    }

    public static synchronized ArrayList<MBeanServer> findMBeanServer(String string) {
        MBeanServerFactory.checkPermission("findMBeanServer");
        if (string == null) {
            return new ArrayList<MBeanServer>(mBeanServerList);
        }
        ArrayList<MBeanServer> arrayList = new ArrayList<MBeanServer>();
        for (MBeanServer mBeanServer : mBeanServerList) {
            String string2 = MBeanServerFactory.mBeanServerId(mBeanServer);
            if (!string.equals(string2)) continue;
            arrayList.add(mBeanServer);
        }
        return arrayList;
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer mBeanServer) {
        return mBeanServer.getClassLoaderRepository();
    }

    private static String mBeanServerId(MBeanServer mBeanServer) {
        try {
            return (String)mBeanServer.getAttribute(MBeanServerDelegate.DELEGATE_NAME, "MBeanServerId");
        }
        catch (JMException jMException) {
            JmxProperties.MISC_LOGGER.finest("Ignoring exception while getting MBeanServerId: " + jMException);
            return null;
        }
    }

    private static void checkPermission(String string) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            MBeanServerPermission mBeanServerPermission = new MBeanServerPermission(string);
            securityManager.checkPermission(mBeanServerPermission);
        }
    }

    private static synchronized void addMBeanServer(MBeanServer mBeanServer) {
        mBeanServerList.add(mBeanServer);
    }

    private static synchronized void removeMBeanServer(MBeanServer mBeanServer) {
        boolean bl = mBeanServerList.remove(mBeanServer);
        if (!bl) {
            JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINER, MBeanServerFactory.class.getName(), "removeMBeanServer(MBeanServer)", "MBeanServer was not in list!");
            throw new IllegalArgumentException("MBeanServer was not in list!");
        }
    }

    private static Class<?> loadBuilderClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            return classLoader.loadClass(string);
        }
        return Class.forName(string);
    }

    private static MBeanServerBuilder newBuilder(Class<?> clazz) {
        try {
            Object obj = clazz.newInstance();
            return (MBeanServerBuilder)obj;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            String string = "Failed to instantiate a MBeanServerBuilder from " + clazz + ": " + exception;
            throw new JMRuntimeException(string, exception);
        }
    }

    private static synchronized void checkMBeanServerBuilder() {
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("javax.management.builder.initial");
            String string = AccessController.doPrivileged(getPropertyAction);
            try {
                Class<?> clazz;
                Class clazz2 = string == null || string.length() == 0 ? MBeanServerBuilder.class : MBeanServerFactory.loadBuilderClass(string);
                if (builder != null && clazz2 == (clazz = builder.getClass())) {
                    return;
                }
                builder = MBeanServerFactory.newBuilder(clazz2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string2 = "Failed to load MBeanServerBuilder class " + string + ": " + classNotFoundException;
                throw new JMRuntimeException(string2, classNotFoundException);
            }
        }
        catch (RuntimeException runtimeException) {
            if (JmxProperties.MBEANSERVER_LOGGER.isLoggable(Level.FINEST)) {
                StringBuilder stringBuilder = new StringBuilder().append("Failed to instantiate MBeanServerBuilder: ").append(runtimeException).append("\n\t\tCheck the value of the ").append("javax.management.builder.initial").append(" property.");
                JmxProperties.MBEANSERVER_LOGGER.logp(Level.FINEST, MBeanServerFactory.class.getName(), "checkMBeanServerBuilder", stringBuilder.toString());
            }
            throw runtimeException;
        }
    }

    private static synchronized MBeanServerBuilder getNewMBeanServerBuilder() {
        MBeanServerFactory.checkMBeanServerBuilder();
        return builder;
    }
}

