/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class Inet6Address
extends InetAddress {
    static final int INADDRSZ = 16;
    private transient int cached_scope_id = 0;
    byte[] ipaddress;
    private int scope_id = 0;
    private boolean scope_id_set = false;
    private transient NetworkInterface scope_ifname = null;
    private boolean scope_ifname_set = false;
    private static final long serialVersionUID = 6880410070516793377L;
    private static final int INT16SZ = 2;
    private String ifname;

    Inet6Address() {
        this.hostName = null;
        this.ipaddress = new byte[16];
        this.family = 2;
    }

    Inet6Address(String string, byte[] byArray, int n) {
        this.hostName = string;
        if (byArray.length == 16) {
            this.family = 2;
            this.ipaddress = (byte[])byArray.clone();
        }
        if (n >= 0) {
            this.scope_id = n;
            this.scope_id_set = true;
        }
    }

    Inet6Address(String string, byte[] byArray) {
        try {
            this.initif(string, byArray, null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    Inet6Address(String string, byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        this.initif(string, byArray, networkInterface);
    }

    Inet6Address(String string, byte[] byArray, String string2) throws UnknownHostException {
        this.initstr(string, byArray, string2);
    }

    public static Inet6Address getByAddress(String string, byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        if (byArray != null && byArray.length == 16) {
            return new Inet6Address(string, byArray, networkInterface);
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    public static Inet6Address getByAddress(String string, byte[] byArray, int n) throws UnknownHostException {
        if (string != null && string.length() > 0 && string.charAt(0) == '[' && string.charAt(string.length() - 1) == ']') {
            string = string.substring(1, string.length() - 1);
        }
        if (byArray != null && byArray.length == 16) {
            return new Inet6Address(string, byArray, n);
        }
        throw new UnknownHostException("addr is of illegal length");
    }

    private void initstr(String string, byte[] byArray, String string2) throws UnknownHostException {
        try {
            NetworkInterface networkInterface = NetworkInterface.getByName(string2);
            if (networkInterface == null) {
                throw new UnknownHostException("no such interface " + string2);
            }
            this.initif(string, byArray, networkInterface);
        }
        catch (SocketException socketException) {
            throw new UnknownHostException("SocketException thrown" + string2);
        }
    }

    private void initif(String string, byte[] byArray, NetworkInterface networkInterface) throws UnknownHostException {
        this.hostName = string;
        if (byArray.length == 16) {
            this.family = 2;
            this.ipaddress = (byte[])byArray.clone();
        }
        if (networkInterface != null) {
            this.scope_ifname = networkInterface;
            this.scope_ifname_set = true;
            this.scope_id = this.deriveNumericScope(networkInterface);
            this.scope_id_set = true;
        }
    }

    private boolean differentLocalAddressTypes(Inet6Address inet6Address) {
        if (this.isLinkLocalAddress() && !inet6Address.isLinkLocalAddress()) {
            return false;
        }
        return !this.isSiteLocalAddress() || inet6Address.isSiteLocalAddress();
    }

    private int deriveNumericScope(NetworkInterface networkInterface) throws UnknownHostException {
        Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
        while (enumeration.hasMoreElements()) {
            Inet6Address inet6Address;
            InetAddress inetAddress = enumeration.nextElement();
            if (!(inetAddress instanceof Inet6Address) || !this.differentLocalAddressTypes(inet6Address = (Inet6Address)inetAddress)) continue;
            return inet6Address.scope_id;
        }
        throw new UnknownHostException("no scope_id found");
    }

    private int deriveNumericScope(String string) throws UnknownHostException {
        Enumeration<NetworkInterface> enumeration;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            throw new UnknownHostException("could not enumerate local network interfaces");
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if (!networkInterface.getName().equals(string)) continue;
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                Inet6Address inet6Address;
                InetAddress inetAddress = enumeration2.nextElement();
                if (!(inetAddress instanceof Inet6Address) || !this.differentLocalAddressTypes(inet6Address = (Inet6Address)inetAddress)) continue;
                return inet6Address.scope_id;
            }
        }
        throw new UnknownHostException("No matching address found for interface : " + string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.scope_ifname = null;
        this.scope_ifname_set = false;
        objectInputStream.defaultReadObject();
        if (this.ifname != null && !"".equals(this.ifname)) {
            try {
                this.scope_ifname = NetworkInterface.getByName(this.ifname);
                if (this.scope_ifname == null) {
                    this.scope_id_set = false;
                    this.scope_ifname_set = false;
                    this.scope_id = 0;
                } else {
                    try {
                        this.scope_id = this.deriveNumericScope(this.scope_ifname);
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        this.ipaddress = (byte[])this.ipaddress.clone();
        if (this.ipaddress.length != 16) {
            throw new InvalidObjectException("invalid address length: " + this.ipaddress.length);
        }
        if (this.family != 2) {
            throw new InvalidObjectException("invalid address family type");
        }
    }

    @Override
    public boolean isMulticastAddress() {
        return (this.ipaddress[0] & 0xFF) == 255;
    }

    @Override
    public boolean isAnyLocalAddress() {
        byte by = 0;
        for (int i = 0; i < 16; ++i) {
            by = (byte)(by | this.ipaddress[i]);
        }
        return by == 0;
    }

    @Override
    public boolean isLoopbackAddress() {
        byte by = 0;
        for (int i = 0; i < 15; ++i) {
            by = (byte)(by | this.ipaddress[i]);
        }
        return by == 0 && this.ipaddress[15] == 1;
    }

    @Override
    public boolean isLinkLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 128;
    }

    @Override
    public boolean isSiteLocalAddress() {
        return (this.ipaddress[0] & 0xFF) == 254 && (this.ipaddress[1] & 0xC0) == 192;
    }

    @Override
    public boolean isMCGlobal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 14;
    }

    @Override
    public boolean isMCNodeLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 1;
    }

    @Override
    public boolean isMCLinkLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 2;
    }

    @Override
    public boolean isMCSiteLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 5;
    }

    @Override
    public boolean isMCOrgLocal() {
        return (this.ipaddress[0] & 0xFF) == 255 && (this.ipaddress[1] & 0xF) == 8;
    }

    @Override
    public byte[] getAddress() {
        return (byte[])this.ipaddress.clone();
    }

    public int getScopeId() {
        return this.scope_id;
    }

    public NetworkInterface getScopedInterface() {
        return this.scope_ifname;
    }

    @Override
    public String getHostAddress() {
        String string = Inet6Address.numericToTextFormat(this.ipaddress);
        if (this.scope_ifname_set) {
            string = string + "%" + this.scope_ifname.getName();
        } else if (this.scope_id_set) {
            string = string + "%" + this.scope_id;
        }
        return string;
    }

    @Override
    public int hashCode() {
        if (this.ipaddress != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < 16) {
                int n3 = 0;
                for (int i = 0; i < 4 && n2 < 16; ++i, ++n2) {
                    n3 = (n3 << 8) + this.ipaddress[n2];
                }
                n += n3;
            }
            return n;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Inet6Address)) {
            return false;
        }
        Inet6Address inet6Address = (Inet6Address)object;
        for (int i = 0; i < 16; ++i) {
            if (this.ipaddress[i] == inet6Address.ipaddress[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isIPv4CompatibleAddress() {
        return this.ipaddress[0] == 0 && this.ipaddress[1] == 0 && this.ipaddress[2] == 0 && this.ipaddress[3] == 0 && this.ipaddress[4] == 0 && this.ipaddress[5] == 0 && this.ipaddress[6] == 0 && this.ipaddress[7] == 0 && this.ipaddress[8] == 0 && this.ipaddress[9] == 0 && this.ipaddress[10] == 0 && this.ipaddress[11] == 0;
    }

    static String numericToTextFormat(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(39);
        for (int i = 0; i < 8; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i << 1] << 8 & 0xFF00 | byArray[(i << 1) + 1] & 0xFF));
            if (i >= 7) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    private static native void init();

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.scope_ifname_set) {
            this.ifname = this.scope_ifname.getName();
        }
        objectOutputStream.defaultWriteObject();
    }

    static {
        Inet6Address.init();
    }
}

