/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.text.BreakIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import sun.text.Normalizer;

final class ConditionalSpecialCasing {
    static final int FINAL_CASED = 1;
    static final int AFTER_SOFT_DOTTED = 2;
    static final int MORE_ABOVE = 3;
    static final int AFTER_I = 4;
    static final int NOT_BEFORE_DOT = 5;
    static final int COMBINING_CLASS_ABOVE = 230;
    static Entry[] entry = new Entry[]{new Entry(931, new char[]{'\u03c2'}, new char[]{'\u03a3'}, null, 1), new Entry(775, new char[]{'\u0307'}, new char[0], "lt", 2), new Entry(73, new char[]{'i', '\u0307'}, new char[]{'I'}, "lt", 3), new Entry(74, new char[]{'j', '\u0307'}, new char[]{'J'}, "lt", 3), new Entry(302, new char[]{'\u012f', '\u0307'}, new char[]{'\u012e'}, "lt", 3), new Entry(204, new char[]{'i', '\u0307', '\u0300'}, new char[]{'\u00cc'}, "lt", 0), new Entry(205, new char[]{'i', '\u0307', '\u0301'}, new char[]{'\u00cd'}, "lt", 0), new Entry(296, new char[]{'i', '\u0307', '\u0303'}, new char[]{'\u0128'}, "lt", 0), new Entry(304, new char[]{'i', '\u0307'}, new char[]{'\u0130'}, "lt", 0), new Entry(775, new char[0], new char[]{'\u0307'}, "tr", 4), new Entry(775, new char[0], new char[]{'\u0307'}, "az", 4), new Entry(73, new char[]{'\u0131'}, new char[]{'I'}, "tr", 5), new Entry(73, new char[]{'\u0131'}, new char[]{'I'}, "az", 5), new Entry(105, new char[]{'i'}, new char[]{'\u0130'}, "tr", 0), new Entry(105, new char[]{'i'}, new char[]{'\u0130'}, "az", 0), new Entry(304, new char[]{'i', '\u0307'}, new char[]{'\u0130'}, "en", 0)};
    static Hashtable entryTable = new Hashtable();

    ConditionalSpecialCasing() {
    }

    static int toLowerCaseEx(String string, int n, Locale locale) {
        char[] cArray = ConditionalSpecialCasing.lookUpTable(string, n, locale, true);
        if (cArray != null) {
            if (cArray.length == 1) {
                return cArray[0];
            }
            return -1;
        }
        return Character.toLowerCase(string.codePointAt(n));
    }

    static int toUpperCaseEx(String string, int n, Locale locale) {
        char[] cArray = ConditionalSpecialCasing.lookUpTable(string, n, locale, false);
        if (cArray != null) {
            if (cArray.length == 1) {
                return cArray[0];
            }
            return -1;
        }
        return Character.toUpperCaseEx(string.codePointAt(n));
    }

    static char[] toLowerCaseCharArray(String string, int n, Locale locale) {
        return ConditionalSpecialCasing.lookUpTable(string, n, locale, true);
    }

    static char[] toUpperCaseCharArray(String string, int n, Locale locale) {
        char[] cArray = ConditionalSpecialCasing.lookUpTable(string, n, locale, false);
        if (cArray != null) {
            return cArray;
        }
        return Character.toUpperCaseCharArray(string.codePointAt(n));
    }

    private static char[] lookUpTable(String string, int n, Locale locale, boolean bl) {
        HashSet hashSet = (HashSet)entryTable.get(new Integer(string.codePointAt(n)));
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            String string2 = locale.getLanguage();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                String string3 = entry.getLanguage();
                if (string3 != null && !string3.equals(string2) || !ConditionalSpecialCasing.isConditionMet(string, n, locale, entry.getCondition())) continue;
                return bl ? entry.getLowerCase() : entry.getUpperCase();
            }
        }
        return null;
    }

    private static boolean isConditionMet(String string, int n, Locale locale, int n2) {
        switch (n2) {
            case 1: {
                return ConditionalSpecialCasing.isFinalCased(string, n, locale);
            }
            case 2: {
                return ConditionalSpecialCasing.isAfterSoftDotted(string, n);
            }
            case 3: {
                return ConditionalSpecialCasing.isMoreAbove(string, n);
            }
            case 4: {
                return ConditionalSpecialCasing.isAfterI(string, n);
            }
            case 5: {
                return !ConditionalSpecialCasing.isBeforeDot(string, n);
            }
        }
        return true;
    }

    private static boolean isFinalCased(String string, int n, Locale locale) {
        int n2;
        BreakIterator breakIterator = BreakIterator.getWordInstance(locale);
        breakIterator.setText(string);
        for (int i = n; i >= 0 && !breakIterator.isBoundary(i); i -= Character.charCount(n2)) {
            n2 = string.codePointBefore(i);
            if (!ConditionalSpecialCasing.isCased(n2)) continue;
            int n3 = string.length();
            for (i = n + Character.charCount(string.codePointAt(n)); i < n3 && !breakIterator.isBoundary(i); i += Character.charCount(n2)) {
                n2 = string.codePointAt(i);
                if (!ConditionalSpecialCasing.isCased(n2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isAfterI(String string, int n) {
        int n2;
        for (int i = n; i > 0; i -= Character.charCount(n2)) {
            n2 = string.codePointBefore(i);
            if (n2 == 73) {
                return true;
            }
            int n3 = Normalizer.getCombiningClass(n2);
            if (n3 != 0 && n3 != 230) continue;
            return false;
        }
        return false;
    }

    private static boolean isAfterSoftDotted(String string, int n) {
        int n2;
        for (int i = n; i > 0; i -= Character.charCount(n2)) {
            n2 = string.codePointBefore(i);
            if (ConditionalSpecialCasing.isSoftDotted(n2)) {
                return true;
            }
            int n3 = Normalizer.getCombiningClass(n2);
            if (n3 != 0 && n3 != 230) continue;
            return false;
        }
        return false;
    }

    private static boolean isMoreAbove(String string, int n) {
        int n2;
        int n3 = string.length();
        for (int i = n + Character.charCount(string.codePointAt(n)); i < n3; i += Character.charCount(n2)) {
            n2 = string.codePointAt(i);
            int n4 = Normalizer.getCombiningClass(n2);
            if (n4 == 230) {
                return true;
            }
            if (n4 != 0) continue;
            return false;
        }
        return false;
    }

    private static boolean isBeforeDot(String string, int n) {
        int n2;
        int n3 = string.length();
        for (int i = n + Character.charCount(string.codePointAt(n)); i < n3; i += Character.charCount(n2)) {
            n2 = string.codePointAt(i);
            if (n2 == 775) {
                return true;
            }
            int n4 = Normalizer.getCombiningClass(n2);
            if (n4 != 0 && n4 != 230) continue;
            return false;
        }
        return false;
    }

    private static boolean isCased(int n) {
        int n2 = Character.getType(n);
        if (n2 == 2 || n2 == 1 || n2 == 3) {
            return true;
        }
        if (n >= 688 && n <= 696) {
            return true;
        }
        if (n >= 704 && n <= 705) {
            return true;
        }
        if (n >= 736 && n <= 740) {
            return true;
        }
        if (n == 837) {
            return true;
        }
        if (n == 890) {
            return true;
        }
        if (n >= 7468 && n <= 7521) {
            return true;
        }
        if (n >= 8544 && n <= 8575) {
            return true;
        }
        return n >= 9398 && n <= 9449;
    }

    private static boolean isSoftDotted(int n) {
        switch (n) {
            case 105: 
            case 106: 
            case 303: 
            case 616: 
            case 1110: 
            case 1112: 
            case 7522: 
            case 7725: 
            case 7883: 
            case 8305: {
                return true;
            }
        }
        return false;
    }

    static {
        for (int i = 0; i < entry.length; ++i) {
            Entry entry = ConditionalSpecialCasing.entry[i];
            Integer n = new Integer(entry.getCodePoint());
            HashSet<Entry> hashSet = (HashSet<Entry>)entryTable.get(n);
            if (hashSet == null) {
                hashSet = new HashSet<Entry>();
            }
            hashSet.add(entry);
            entryTable.put(n, hashSet);
        }
    }

    static class Entry {
        int ch;
        char[] lower;
        char[] upper;
        String lang;
        int condition;

        Entry(int n, char[] cArray, char[] cArray2, String string, int n2) {
            this.ch = n;
            this.lower = cArray;
            this.upper = cArray2;
            this.lang = string;
            this.condition = n2;
        }

        int getCodePoint() {
            return this.ch;
        }

        char[] getLowerCase() {
            return this.lower;
        }

        char[] getUpperCase() {
            return this.upper;
        }

        String getLanguage() {
            return this.lang;
        }

        int getCondition() {
            return this.condition;
        }
    }
}

