/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class WindowsSpinnerUI
extends BasicSpinnerUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsSpinnerUI();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (XPStyle.getXP() != null) {
            this.paintXPBackground(graphics, jComponent);
        }
        super.paint(graphics, jComponent);
    }

    private TMSchema.State getXPState(JComponent jComponent) {
        TMSchema.State state = TMSchema.State.NORMAL;
        if (!jComponent.isEnabled()) {
            state = TMSchema.State.DISABLED;
        }
        return state;
    }

    private void paintXPBackground(Graphics graphics, JComponent jComponent) {
        XPStyle xPStyle = XPStyle.getXP();
        XPStyle.Skin skin = xPStyle.getSkin(jComponent, TMSchema.Part.EP_EDIT);
        TMSchema.State state = this.getXPState(jComponent);
        skin.paintSkin(graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), state);
    }

    @Override
    protected Component createPreviousButton() {
        if (XPStyle.getXP() != null) {
            XPStyle.GlyphButton glyphButton = new XPStyle.GlyphButton(this.spinner, TMSchema.Part.SPNP_DOWN);
            Dimension dimension = UIManager.getDimension("Spinner.arrowButtonSize");
            glyphButton.setPreferredSize(dimension);
            glyphButton.setRequestFocusEnabled(false);
            this.installPreviousButtonListeners(glyphButton);
            return glyphButton;
        }
        return super.createPreviousButton();
    }

    @Override
    protected Component createNextButton() {
        if (XPStyle.getXP() != null) {
            XPStyle.GlyphButton glyphButton = new XPStyle.GlyphButton(this.spinner, TMSchema.Part.SPNP_UP);
            Dimension dimension = UIManager.getDimension("Spinner.arrowButtonSize");
            glyphButton.setPreferredSize(dimension);
            glyphButton.setRequestFocusEnabled(false);
            this.installNextButtonListeners(glyphButton);
            return glyphButton;
        }
        return super.createNextButton();
    }

    private UIResource getUIResource(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof UIResource)) continue;
            return (UIResource)objectArray[i];
        }
        return null;
    }
}

