/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.wbmp;

import com.sun.imageio.plugins.common.ReaderUtil;
import com.sun.imageio.plugins.wbmp.WBMPImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class WBMPImageReaderSpi
extends ImageReaderSpi {
    private static final int MAX_WBMP_WIDTH = 1024;
    private static final int MAX_WBMP_HEIGHT = 768;
    private static String[] writerSpiNames = new String[]{"com.sun.imageio.plugins.wbmp.WBMPImageWriterSpi"};
    private static String[] formatNames = new String[]{"wbmp", "WBMP"};
    private static String[] entensions = new String[]{"wbmp"};
    private static String[] mimeType = new String[]{"image/vnd.wap.wbmp"};
    private boolean registered = false;

    public WBMPImageReaderSpi() {
        super("Oracle Corporation", "1.0", formatNames, entensions, mimeType, "com.sun.imageio.plugins.wbmp.WBMPImageReader", new Class[]{ImageInputStream.class}, writerSpiNames, true, null, null, null, null, true, "javax_imageio_wbmp_1.0", "com.sun.imageio.plugins.wbmp.WBMPMetadataFormat", null, null);
    }

    @Override
    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
    }

    @Override
    public String getDescription(Locale locale) {
        return "Standard WBMP Image Reader";
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        byte by = imageInputStream.readByte();
        byte by2 = imageInputStream.readByte();
        if (by != 0 || by2 != 0) {
            imageInputStream.reset();
            return false;
        }
        int n = ReaderUtil.readMultiByteInteger(imageInputStream);
        int n2 = ReaderUtil.readMultiByteInteger(imageInputStream);
        if (n <= 0 || n2 <= 0) {
            imageInputStream.reset();
            return false;
        }
        long l = imageInputStream.length();
        if (l == -1L) {
            imageInputStream.reset();
            return n < 1024 && n2 < 768;
        }
        imageInputStream.reset();
        long l2 = n / 8 + (n % 8 == 0 ? 0 : 1);
        return (l -= imageInputStream.getStreamPosition()) == l2 * (long)n2;
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IIOException {
        return new WBMPImageReader(this);
    }
}

