/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Hashtable;
import sun.jvm.hotspot.utilities.HashtableEntry;

public class SymbolTable
extends Hashtable {
    private static AddressField theTableField;
    private static int symbolTableSize;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("SymbolTable");
        theTableField = type.getAddressField("_the_table");
        symbolTableSize = db.lookupIntConstant("SymbolTable::symbol_table_size");
    }

    public static SymbolTable getTheTable() {
        Address tmp = theTableField.getValue();
        return (SymbolTable)VMObjectFactory.newObject(SymbolTable.class, tmp);
    }

    public static int getSymbolTableSize() {
        return symbolTableSize;
    }

    public SymbolTable(Address addr) {
        super(addr);
    }

    public Symbol probe(String name) {
        try {
            return this.probe(SymbolTable.toModifiedUTF8Bytes(name));
        }
        catch (IOException e) {
            return null;
        }
    }

    public Symbol probe(byte[] name) {
        long hashValue = SymbolTable.hashSymbol(name);
        for (HashtableEntry e = (HashtableEntry)this.bucket(this.hashToIndex(hashValue)); e != null; e = (HashtableEntry)e.next()) {
            Symbol sym;
            if (e.hash() != hashValue || !(sym = Symbol.create(e.literalValue())).equals(name)) continue;
            return sym;
        }
        return null;
    }

    public void symbolsDo(SymbolVisitor visitor) {
        int numBuckets = this.tableSize();
        for (int i = 0; i < numBuckets; ++i) {
            for (HashtableEntry e = (HashtableEntry)this.bucket(i); e != null; e = (HashtableEntry)e.next()) {
                visitor.visit(Symbol.create(e.literalValue()));
            }
        }
    }

    private static byte[] toModifiedUTF8Bytes(String name) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(name);
        dos.flush();
        byte[] buf = baos.toByteArray();
        byte[] res = new byte[buf.length - 2];
        System.arraycopy(buf, 2, res, 0, res.length);
        return res;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                SymbolTable.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static interface SymbolVisitor {
        public void visit(Symbol var1);
    }
}

