/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.BranchInstruction;
import sun.jvm.hotspot.asm.PCRelativeAddress;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCV9Instruction;

public class SPARCV9RegisterBranchInstruction
extends SPARCInstruction
implements SPARCV9Instruction,
BranchInstruction {
    protected final PCRelativeAddress addr;
    protected final boolean isAnnuled;
    protected final int regConditionCode;
    protected final SPARCRegister conditionRegister;
    protected final boolean predictTaken;

    public SPARCV9RegisterBranchInstruction(String name, PCRelativeAddress addr, boolean isAnnuled, int regConditionCode, SPARCRegister conditionRegister, boolean predictTaken) {
        super(name);
        this.addr = addr;
        this.isAnnuled = isAnnuled;
        this.regConditionCode = regConditionCode;
        this.conditionRegister = conditionRegister;
        this.predictTaken = predictTaken;
    }

    @Override
    public String asString(long currentPc, SymbolFinder symFinder) {
        long address = this.addr.getDisplacement() + currentPc;
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(symFinder.getSymbolFor(address));
        return buf.toString();
    }

    @Override
    public boolean isBranch() {
        return true;
    }

    @Override
    public Address getBranchDestination() {
        return this.addr;
    }

    public boolean isAnnuledBranch() {
        return this.isAnnuled;
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    public int getRegisterConditionCode() {
        return this.regConditionCode;
    }

    public SPARCRegister getConditionRegister() {
        return this.conditionRegister;
    }

    public boolean getPredictTaken() {
        return this.predictTaken;
    }
}

