/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.PCRelativeAddress;
import sun.jvm.hotspot.asm.SymbolFinder;
import sun.jvm.hotspot.asm.sparc.SPARCBranchInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCV9ConditionFlags;
import sun.jvm.hotspot.asm.sparc.SPARCV9Instruction;

public class SPARCV9BranchInstruction
extends SPARCBranchInstruction
implements SPARCV9Instruction {
    private final boolean predictTaken;
    private final int conditionFlag;

    public SPARCV9BranchInstruction(String name, PCRelativeAddress addr, boolean isAnnuled, int conditionCode, boolean predictTaken, int conditionFlag) {
        name = name + (predictTaken ? ",pt" : ",pn");
        super(name, addr, isAnnuled, conditionCode);
        this.predictTaken = predictTaken;
        this.conditionFlag = conditionFlag;
    }

    public boolean getPredictTaken() {
        return this.predictTaken;
    }

    public String getConditionFlagName() {
        return SPARCV9ConditionFlags.getFlagName(this.conditionFlag);
    }

    public int getConditionFlag() {
        return this.conditionFlag;
    }

    @Override
    public String asString(long currentPc, SymbolFinder symFinder) {
        long address = this.addr.getDisplacement() + currentPc;
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.getConditionFlagName());
        buf.append(comma);
        buf.append(symFinder.getSymbolFor(address));
        return buf.toString();
    }
}

