local assets = {
	Asset("ANIM", "anim/tai_build.zip"),
}

local prefabs = {
	"healthkit"
}

local brain = require "brains/puckbrain"

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddDynamicShadow()
	inst.entity:AddSoundEmitter()

	MakeCharacterPhysics(inst, 1, 0.5)
	inst.Physics:SetCollisionGroup(COLLISION.FLYERS)
	inst.Physics:ClearCollisionMask()
	inst.Physics:CollidesWith(COLLISION.WORLD)

	inst.Transform:SetTwoFaced()

	inst.AnimState:SetBuild("tai_build")
	inst.AnimState:SetBank("butterfly")
	inst.AnimState:PlayAnimation("idle")
	inst.AnimState:SetRayTestOnBB(true)

	inst.DynamicShadow:SetSize(0.8, 0.5)

	inst:AddTag("butterfly")
	inst:AddTag("flying")
	inst:AddTag("insect")
	inst:AddTag("smallcreature")
	inst:AddTag("cattoyairborne")
	inst:AddTag("wildfireprotected")
	inst:AddTag("fairy")

	inst:AddComponent("follower")

	inst:AddComponent("inspectable")

	inst:AddComponent("locomotor")
	inst.components.locomotor:EnableGroundSpeedMultiplier(false)
	inst.components.locomotor:SetTriggersCreep(false)

	inst:AddComponent("periodicspawner")
	inst.components.periodicspawner.prefab = "healthkit"
	inst.components.periodicspawner.basetime = TUNING.TOTAL_DAY_TIME * 2
	inst.components.periodicspawner.randtime = TUNING.TOTAL_DAY_TIME * 2
	inst.components.periodicspawner:Start()

	inst:SetBrain(brain)
	inst:SetStateGraph("SGbutterfly")

	inst.persists = false

	return inst
end

return Prefab("forest/common/puck", fn, assets, prefabs)
