local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
	Asset("ANIM", "anim/guts.zip"),
	Asset("ANIM", "anim/ghost_guts_build.zip"),
}

local prefabs = {
	"healthkit",
}

local start_inv = {
	"healthkit",
}

local giants = { bearger = true, deerclops = true, moose = true, dragonfly = true, minotaur = true }
local canteat = { meatballs = true, fishsticks = true, baconeggs = true, monsterlasagna = true, monstermeat = true, cookedmonstermeat = true, monstermeat_dried = true }

local function onkilledother(inst, data)
	local victim = data.victim
	if victim == nil then
		return
	end
	if victim.prefab == "butterfly" then
		inst.components.sanity:DoDelta(5)
		inst.components.talker:Say("You little shit!")
	elseif giants[victim.prefab] then
		inst.components.sanity:DoDelta(inst.components.sanity.max)
		inst.components.talker:Say("Rest in hell you faggot!")
	elseif victim:HasTag("monster") then
		inst.components.talker:Say("No big deal.")
	else
		inst.components.talker:Say("There was no place for you to hide.")
	end
end

local function wearOnlyEwecusHat(inst)
	local _Equip = inst.components.inventory.Equip
	inst.components.inventory.Equip = function(self, item, old_to_active)
		if not item or not item.components.equippable or not item:IsValid() then
			return
		end
		if item.components.equippable.equipslot == EQUIPSLOTS.HEAD then
			if not (item.prefab == "ewecushat") then
				self:DropItem(item)
				self:GiveItem(item)
				return
			end
		end
		return _Equip(self, item, old_to_active)
	end
end

local function cantEatSoftFood(inst)
	inst.components.eater.caneattest = function(self, food)
        if food ~= nil and canteat[food.prefab] then
            return false
        end
		return true
    end
end

local function trySpawnPuck(inst)
	local puck = SpawnPrefab("puck")
	if puck then
		puck.Transform:SetPosition(inst.Transform:GetWorldPosition())
		inst.components.leader:AddFollower(puck)
		inst._puck = puck
	else
		inst:DoTaskInTime(1, trySpawnPuck)
	end
end

local function loadGutsOnlyRecipes(inst)
	local punisher_recipe = Recipe("punisher",
		{ Ingredient("cutstone", 13), Ingredient("livinglog", 4), Ingredient("papyrus", 4), Ingredient("nightmarefuel", 23) },
		RECIPETABS.SURVIVAL, TECH.NONE)
	punisher_recipe.atlas = "images/inventoryimages/punisher.xml"
	punisher_recipe.sortkey = -1

	local armormosquito_recipe = Recipe("armormosquito",
	    { Ingredient("nightmarefuel", 17), Ingredient("cutstone", 7), Ingredient("mosquitosack_yellow", 10), Ingredient("stinger", 23) },
		RECIPETABS.WAR, TECH.SCIENCE_ONE)
	armormosquito_recipe.atlas = "images/inventoryimages/armormosquito.xml"
	armormosquito_recipe.sortkey = -1

	local ewecushat_recipe = Recipe("ewecushat",
	    { Ingredient("snakeskin", 23), Ingredient("redgem", 2), Ingredient("boneshard", 23), Ingredient("nightmarefuel", 23) },
		RECIPETABS.MAGIC, TECH.MAGIC_TWO)
	ewecushat_recipe.atlas = "images/inventoryimages/ewecushat.xml"
	ewecushat_recipe.sortkey = -1

	local grenade_recipe = Recipe("grenade",
	    { Ingredient("gunpowder", 1), Ingredient("limestone", 6), Ingredient("flint", 1) },
		RECIPETABS.SCIENCE, TECH.SCIENCE_TWO)
	grenade_recipe.atlas = "images/inventoryimages/grenade.xml"
	grenade_recipe.sortkey = -1
end

local fn = function(inst)
	inst.MiniMapEntity:SetIcon("guts.tex")

	inst:AddTag("insomniac")

	inst.soundsname = "maxwell"

	inst.components.health:SetMaxHealth(280)
	inst.components.hunger:SetMax(130)
	inst.components.sanity:SetMax(40)

	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6

	inst.components.combat.damagemultiplier = 1.5

	inst:ListenForEvent("killed", onkilledother)

	trySpawnPuck(inst)

	wearOnlyEwecusHat(inst)

	cantEatSoftFood(inst)

	loadGutsOnlyRecipes(inst)
end

return MakePlayerCharacter("guts", prefabs, assets, fn, start_inv)
