local function onPhaseChange(inst, val)
	if GetWorld():IsCave() then
		val = "night"
	end
	inst.Light:Enable(val == "night")
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddLight()

	inst.Light:SetRadius(3)
	inst.Light:SetFalloff(1)
	inst.Light:SetIntensity(0.8)
	inst.Light:SetColour(255/255, 0/255, 0/255)

    inst:ListenForEvent("daytime", function() onPhaseChange(inst, "day") end, GetWorld())
	inst:ListenForEvent("dusktime", function() onPhaseChange(inst, "dusk") end, GetWorld())
    inst:ListenForEvent("nighttime", function() onPhaseChange(inst, "night") end, GetWorld())
	onPhaseChange(inst, GetWorld().components.clock.phase)

	inst:AddTag("FX")

	inst.persists = false

	return inst
end

return Prefab("common/fx/ewecushatlight", fn)
