local assets = { 
	Asset("ANIM", "anim/ewecushat.zip"),
	Asset("ANIM", "anim/ewecushat_swap.zip"), 

	Asset("ATLAS", "images/inventoryimages/ewecushat.xml"),
	Asset("IMAGE", "images/inventoryimages/ewecushat.tex"),
}

local function health_drop(inst, owner)
	if owner then
		owner.components.combat.damagemultiplier = (owner.components.combat.damagemultiplier or 1) * 1.25
		inst.task = inst:DoPeriodicTask(5, function()
			if owner.components.health:IsDead() then
				if inst.task then
					inst.task:Cancel()
					inst.task = nil
				end
			else
				owner.components.health:DoDelta(-1, false, "ewecushat") 
			end
		end)
	end
end

local function health_stop(inst, owner)
	if owner then
		owner.components.combat.damagemultiplier = owner.components.combat.damagemultiplier / 1.25
		if inst.task then
			inst.task:Cancel()
			inst.task = nil
		end
	end
end

local function OnEquip(inst, owner) 
	owner.AnimState:OverrideSymbol("swap_hat", "ewecushat_swap", "swap_hat")

	owner.AnimState:Show("HAT")
	owner.AnimState:Show("HAT_HAIR")
	owner.AnimState:Hide("HAIR_NOHAT")
	owner.AnimState:Hide("HAIR")

	if owner:HasTag("player") then
		owner.AnimState:Hide("HEAD")
		owner.AnimState:Show("HEAD_HAT")
	end

	health_drop(inst, owner)

	if inst.fire == nil then
		inst.fire = SpawnPrefab("ewecushatlight")
		local follower = inst.fire.entity:AddFollower()
		follower:FollowSymbol(owner.GUID, "swap_body", 0, 0, 0)
	end
end

local function OnUnequip(inst, owner) 
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")

	if owner:HasTag("player") then
		owner.AnimState:Show("HEAD")
		owner.AnimState:Hide("HEAD_HAT")
	end

	health_stop(inst, owner)

	if inst.fire ~= nil then
		inst.fire:Remove()
		inst.fire = nil
	end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

	MakeInventoryPhysics(inst)

	inst.AnimState:SetBank("ewecushat")
	inst.AnimState:SetBuild("ewecushat")
	inst.AnimState:PlayAnimation("idle")

	inst:AddTag("hat")

	inst:AddComponent("armor")
	inst.components.armor:InitCondition(90000000, 0.8)

	inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip(OnEquip)
	inst.components.equippable:SetOnUnequip(OnUnequip)
	inst.components.equippable.walkspeedmult = 1.7

	if IsDLCEnabled(REIGN_OF_GIANTS) then
		inst.components.equippable.dapperness = -TUNING.DAPPERNESS_HUGE

		inst:AddComponent("waterproofer")
		inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
	else
		inst:AddComponent("dapperness")
		inst.components.dapperness.dapperness = -TUNING.DAPPERNESS_HUGE

		inst.components.dapperness.mitigates_rain = true
	end

	inst:AddComponent("inspectable")

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "ewecushat"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/ewecushat.xml"

	inst:AddComponent("tradable")

	return inst
end

return Prefab("common/inventory/ewecushat", fn, assets)
