require "behaviours/follow"
require "behaviours/wander"

local MIN_FOLLOW = 4
local MED_FOLLOW = 6
local MAX_FOLLOW = 11
local MAX_WANDER_DIST = 10

local PuckBrain = Class(Brain, function(self, inst)
	Brain._ctor(self, inst)
end)

function PuckBrain:OnStart()

	local root = PriorityNode({
		Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW, MED_FOLLOW, MAX_FOLLOW, true),
		Wander(self.inst, nil, MAX_WANDER_DIST)       
	}, 2)

	self.bt = BT(self.inst, root)
end

return PuckBrain
