
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/wisspharr.zip" ),
}

local start_inv = {
	"bluegem"
}

local fn = function(inst)
	
	inst.soundsname = "wilson"

	inst.MiniMapEntity:SetIcon( "wisspharr.tex" )

	inst.components.health:SetMaxHealth(TUNING.WISSPHARR_HEALTH)
	inst.components.hunger:SetMax(TUNING.WISSPHARR_STOMACH)
	inst.components.sanity:SetMax(TUNING.WISSPHARR_MENTAL_INTEGRITY)
    inst.components.combat.damagemultiplier = TUNING.WISSPHARR_STRENGHT
	inst.components.hunger.SetRate = TUNING.WISSPHARR_STOMACH_CONSUMPTION
	inst.components.sanity.night_drain_mult = TUNING.WISSPHARR_FEAR_TO_NIGHTANDENEMY
	inst.components.sanity.neg_aura_mult = TUNING.WISSPHARR_FEAR_TO_NIGHTANDENEMY
	inst.components.eater.stale_hunger = TUNING.WICKERBOTTOM_STALE_FOOD_HUNGER
	inst.components.eater.stale_health = TUNING.WICKERBOTTOM_STALE_FOOD_HEALTH
	inst.components.eater.spoiled_hunger = TUNING.WICKERBOTTOM_SPOILED_FOOD_HUNGER
	inst.components.eater.spoiled_health = TUNING.WICKERBOTTOM_SPOILED_FOOD_HEALTH
	inst.components.builder.magic_bonus = TUNING.WISSPHARR_MAGICAL_KNOWLEDGE
	inst.components.locomotor.walkspeed = (0.95 * 4)
	inst.components.locomotor.runspeed = (0.95 * 6)
	
    inst:AddTag("insomniac")
	
end

return MakePlayerCharacter("wisspharr", prefabs, assets, fn, start_inv)
