local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH
local function setSilkShoot(inst)
    GLOBAL.TheInput:AddKeyUpHandler(114, function()
    	if not inst.components.inventory:Has("silk", 1) then
    		inst.components.talker:Say('I need silk')
    		return
    	end
		local MouseCharacter = GLOBAL.TheInput:GetWorldEntityUnderMouse()
		if MouseCharacter then
			local prefab = MouseCharacter.prefab
			if MouseCharacter:HasTag('structure') or MouseCharacter:HasTag("tree") or 
				MouseCharacter.components.inspectable.nameoverride == "ROCK" or 
				prefab == 'rock_ice' or prefab == 'sanityrock' then
				inst.components.playercontroller:Enable(false)
				inst.components.inventory:ConsumeByName('silk', 1)
				local pos = MouseCharacter:GetPosition()
				local player_pos = inst:GetPosition()
			    local angle = inst:GetAngleToPoint(pos)
			    inst.Transform:SetRotation(angle)
				inst.AnimState:PlayAnimation("give")
				inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/spider_egg_sack")
			    local pt = Point(pos)
			    local dx = pos.x - player_pos.x
			    local dz = pos.z - player_pos.z
			    local dist = math.sqrt(dx * dx + dz * dz)
			    local give_time = 0.4
			    inst:DoTaskInTime(give_time, function()
				    inst.components.locomotor:RunInDirection(angle)
				    local speed = inst.components.locomotor.runspeed
				    inst.components.locomotor.runspeed = 100
				    local time = dist/90
					inst:DoTaskInTime(time, function()
						inst.components.playercontroller:Enable(true)
						inst.components.locomotor:Stop()
						inst.components.locomotor.runspeed = speed
					end)
				end)
			end
			print(MouseCharacter.prefab)
		end
	end)
end

local function applyupgrades(inst)
	local max_upgrades = 100
	local upgrades = math.min(inst.level, max_upgrades)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = 175 + upgrades * 1.5
	inst.components.health.maxhealth = 175 + upgrades * 0.8
	inst.components.sanity.max = 100 + upgrades * 1

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)

	inst.components.combat.damagemultiplier = 1 + inst.atk_level / 400
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * (1 + inst.atk_level / 400))
end

local function oneat(inst, food)
	if food then
		if food.prefab == 'spidereggsack' then
			if inst.level < 100 then
				inst.level = inst.level + 1			
				inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
				inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
				inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
			else
				inst.components.talker:Say('body grow max!')
			end
			inst.HUD.controls.status.heart:PulseGreen()
			inst.HUD.controls.status.stomach:PulseGreen()
			inst.HUD.controls.status.brain:PulseGreen()
		elseif food.prefab == 'stinger' then
			if inst.atk_level < 200 then
				inst.atk_level = inst.atk_level + 1
			end
		end
		applyupgrades(inst)
	end
end

local function onpreload(inst, data)
	inst.level = data.level or 0
	inst.atk_level = data.atk_level or 0
	applyupgrades(inst)
	--re-set these from the save data, because of load-order clipping issues
	if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
	if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
	if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
	inst.components.health:DoDelta(0)
	inst.components.hunger:DoDelta(0)
	inst.components.sanity:DoDelta(0)
end

local function onsave(inst, data)
	data.level = inst.level or 0
	data.atk_level = inst.atk_level or 0
end
	AddPrefabPostInit('spidereggsack', function(eggsack)
		eggsack:AddComponent("edible")
	    eggsack.components.edible.foodtype = "spidereggsack"
	    eggsack.components.edible.healthvalue = 40
	    eggsack.components.edible.hungervalue = 75
	    eggsack.components.edible.sanityvalue = 40
	end)
	AddPrefabPostInit('stinger', function(stinger)
		stinger:AddComponent("edible")
	    stinger.components.edible.foodtype = "stinger"
	    stinger.components.edible.healthvalue = -10
	    stinger.components.edible.hungervalue = 0
	    stinger.components.edible.sanityvalue = -10
	end)
local function plus(inst)
	table.insert(inst.components.eater.foodprefs, "stinger")
	table.insert(inst.components.eater.ablefoods, "stinger")
	table.insert(inst.components.eater.foodprefs, "spidereggsack")
	table.insert(inst.components.eater.ablefoods, "spidereggsack")
	inst.components.eater:SetOnEatFn(oneat)
	inst.OnPreLoad = onpreload
	inst.OnSave = onsave
    inst.components.beard:AddCallback(32, function()
        inst.AnimState:OverrideSymbol("beard", "beard_silk", "beardsilk_long")
        inst.components.beard.bits = 27
    end)
    --day64，胡子数量81
    inst.components.beard:AddCallback(64, function()
        inst.AnimState:OverrideSymbol("beard", "beard_silk", "beardsilk_long")
        inst.components.beard.bits = 81
    end)
    --day128，胡子数量243
    inst.components.beard:AddCallback(128, function()
        inst.AnimState:OverrideSymbol("beard", "beard_silk", "beardsilk_long")
        inst.components.beard.bits = 243
    end)
end

--t键召唤蜘蛛
GLOBAL.TheInput:AddKeyUpHandler(116, function()
	local player = GLOBAL.GetPlayer()
	if player.components.sanity.current > 10 then
		player.components.sanity:DoDelta(-10)
		GLOBAL.DebugSpawn('spider')
	else
		player.components.talker:Say('I dont have enought sanity!')
	end
end)

--z键召唤蜘蛛战士,30级可用
GLOBAL.TheInput:AddKeyUpHandler(122, function()
	local player = GLOBAL.GetPlayer()
	if player.components.sanity.current > 30 and player.level >= 30 then
		player.components.sanity:DoDelta(-30)
		GLOBAL.DebugSpawn('spider_warrior')
	end
end)

--x键召唤远程蜘蛛，50级可用
GLOBAL.TheInput:AddKeyUpHandler(120, function()
	local player = GLOBAL.GetPlayer()
	if player.components.sanity.current > 60 and player.level >= 50 then
		player.components.sanity:DoDelta(-60)
		GLOBAL.DebugSpawn('spider_spitter')
	end
end)

--c键召唤蜘蛛女王，100级可用
GLOBAL.TheInput:AddKeyUpHandler(99, function()
	local player = GLOBAL.GetPlayer()
	if player.components.sanity.current > 100 and player.level == 100 then
		player.components.sanity:DoDelta(-100)
		GLOBAL.DebugSpawn('spiderqueen')
	end
end)

AddPlayerPostInit(function(inst)
    if inst.prefab == "webber" then
    		plus(inst)
        	setSilkShoot(inst)
    end
end)

--可制作坎普斯背包
GLOBAL.Recipe("krampus_sack", 
	{
	Ingredient("beardhair", 80),
	Ingredient('silk', 40),
	Ingredient("twigs", 20)}, RECIPETABS.SURVIVAL, TECH.SCIENCE_TWO)
--修改远古奖章的配方（使用远古奖章种植远古祭坛）
GLOBAL.Recipe("nightmare_timepiece", {
	Ingredient('cutstone', 20),
	Ingredient("thulecite", 10),
	Ingredient('purplegem', 2)
	}, RECIPETABS.TOWN, TECH.ANCIENT_FOUR)
--可制作海象帽，非洲人的低保
GLOBAL.Recipe("walrushat", {
	Ingredient("beardhair", 20),
	Ingredient('silk', 10),
	Ingredient('rope', 1)
	}, RECIPETABS.DRESS, TECH.SCIENCE_TWO)
--使用冰和胡须制作蓝宝石
GLOBAL.Recipe("bluegem", {
	Ingredient("beardhair", 10),
	Ingredient('ice', 5)
	}, RECIPETABS.MAGIC, TECH.MAGIC_ONE)
--使用火药和胡须制作红宝石
GLOBAL.Recipe("redgem", {
	Ingredient("beardhair", 10),
	Ingredient('gunpowder', 1)
	}, RECIPETABS.MAGIC, TECH.MAGIC_ONE)


GLOBAL.STRINGS.RECIPE_DESC.NIGHTMARE_TIMEPIECE = 'place a ancient_altar'
GLOBAL.STRINGS.RECIPE_DESC.PURPLEGEM = 'place a sanityrock'

--使用远古奖章种植远古祭坛
AddPrefabPostInit('nightmare_timepiece', function(inst)
	local function OnDeploy (inst, pt)
	    GLOBAL.SpawnPrefab("ancient_altar").Transform:SetPosition(pt.x, pt.y, pt.z)
	    inst:Remove()
	end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
end)

--使用紫宝石种植方尖碑
AddPrefabPostInit('purplegem', function(inst)
	local function OnDeploy (inst, pt)
	    GLOBAL.SpawnPrefab("sanityrock").Transform:SetPosition(pt.x, pt.y, pt.z)
	    inst.components.stackable:Get():Remove()
	end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
end)

--使用稿子挖掘方尖碑出红宝石或蓝宝石或紫宝石
AddPrefabPostInit('sanityrock', function(inst)
	local function dig_up(inst, chopper)
		inst:Remove()
		local color = math.random(1, 3)
		if color == 1 then
			inst.components.lootdropper:SpawnLootPrefab("redgem")
		elseif color == 2 then
			inst.components.lootdropper:SpawnLootPrefab("bluegem")
		else
			inst.components.lootdropper:SpawnLootPrefab("purplegem")
		end
	end
	inst:AddComponent("workable")
	inst:AddComponent("lootdropper")
    inst.components.workable:SetWorkAction(GLOBAL.ACTIONS.DIG)
    inst.components.workable:SetOnFinishCallback(dig_up)
    inst.components.workable:SetWorkLeft(3)
end)