require "TimedActions/ISBaseTimedAction"

QGUnloadAction = ISBaseTimedAction:derive("QGUnloadAction")

function QGUnloadAction:isValid()
	if self.unloadable then
		return self.unloadable:isUnloadValid(self.character, self.square, self.mgr:getDifficulty())
	end
	return false
end

function QGUnloadAction:update()
end

function QGUnloadAction:start()
	if self.unloadable then
		self.unloadable:unloadStart(self.character, self.square, self.mgr:getDifficulty());
	end
end

function QGUnloadAction:stop()
	self.mgr:stopUnload()
	ISBaseTimedAction.stop(self)
end

function QGUnloadAction:perform()
	self.unloadable:unloadPerform(self.character, self.square, self.mgr:getDifficulty(), self.unloadWeapon)
	self.mgr.unloadable = self.unloadable -- goes nil sometimes
	self.mgr:stopUnloadSuccess()
	-- needed to remove from queue / start next.
	ISBaseTimedAction.perform(self)
end

function QGUnloadAction:new(unloadManager, char, square, time)
	local o = {}
	setmetatable(o, self)
	self.__index = self
	-- Required fields
	o.character = char
	o.stopOnWalk = false
	o.stopOnRun = true
	o.maxTime = time
	-- Custom fields
	o.mgr = unloadManager
	o.unloadable = unloadManager.unloadable
	o.unloadWeapon = unloadManager.unloadWeapon
	o.square = square
	return o
end

