require "Reloading/ISReloadableWeapon"
require "Reloading/ISReloadableMagazine"

QSWeaponAutoIMNC =  ISReloadableWeapon:derive("QSWeaponAutoIMNC");

--************************************************************************--
--** QSWeaponAutoIMNC:initialise
--**
--************************************************************************--
function QSWeaponAutoIMNC:initialise()

end

--************************************************************************--
--** QSWeaponAutoIMNC:new
--**
--************************************************************************--
function QSWeaponAutoIMNC:new()
	local o = {}
	--o.data = {}
	o = ISReloadableWeapon:new();
    setmetatable(o, self)
    self.__index = self
	o.reloadText = getText('ContextMenu_Reload');
	return o;
end

--************************************************************************--
--** QSWeaponAutoIMNC:isLoaded
--**
--** Returns whether or not the gun will fire when the mouse is next
--** clicked
--**
--************************************************************************--
function QSWeaponAutoIMNC:isLoaded(difficulty)
	return self.currentCapacity > 0;
end

--************************************************************************--
--** QSWeaponAutoIMNC:fireShot
--**
--** Action performed when a shot is fired. Should typically decrease
--** the current amount of ammo in the weapon
--**
--************************************************************************--
function QSWeaponAutoIMNC:fireShot(weapon, difficulty)
	if self.currentCapacity > 0 then
		self.currentCapacity = self.currentCapacity - 1;
	end
	self:syncReloadableToItem(weapon)
end

--************************************************************************--
--** QSWeaponAutoIMNC:canReload
--**
--** Whether the character attempting to reload has the necessary
--** prerequisites to perform the reload action. Called prior to
--** the timed action and not to be confused with isReloadValid
--**
--************************************************************************--
function QSWeaponAutoIMNC:canReload(chr)
	if(self.currentCapacity < self.maxCapacity
	and chr:getInventory():FindAndReturn(self.ammoType) ~= nil) then
		return true;
	end
	return false;
end

function QSWeaponAutoIMNC:canUnload(chr)
	if(self.currentCapacity > 0) then
		return true;
	end
	return false;
end

--************************************************************************--
--** QSWeaponAutoIMNC:isReloadValid
--**
--** Function for the TimedAction that determines whether the reload
--** action is still valid. If the player does something that should
--** interrupt the action, this should return false
--**
--** @param char - the character performing the action. Must not be nil
--** @param square - not used
--** @param difficulty - the difficulty level
--**
--** @return true if the action may continue to be performed
--**
--************************************************************************--
function QSWeaponAutoIMNC:isReloadValid(char, square, difficulty)
	if(self.currentCapacity < self.maxCapacity
		and char:getInventory():FindAndReturn(self.ammoType) ~= nil) then
			return true;
	end
	self.reloadInProgress = false;
	return false;
end

function QSWeaponAutoIMNC:isUnloadValid(char, square, difficulty)
	if(self.currentCapacity > 0) then
		return true;
	end
	self.unloadInProgress = false;
	return false;
end

--************************************************************************--
--** QSWeaponAutoIMNC:reloadStart
--**
--** Function that should be performed upon the start of the timed action
--** Considers the difficulty and performs the corresponding reload
--** action
--**
--** @param char - the character performing the action. Must not be nil
--** @param square - not used
--** @param difficulty - the difficulty level
--**
--************************************************************************--
function QSWeaponAutoIMNC:reloadStart(char, square, difficulty)
	self.reloadInProgress = true;
end

function QSWeaponAutoIMNC:unloadStart(char, square, difficulty)
	self.unloadInProgress = true;
end

--************************************************************************--
--** QSWeaponAutoIMNC:reloadPerform
--**
--** Function that should be performed upon successful completion of the
--** timed action. Considers the difficulty and performs the corresponding
--** reload action
--**
--** @param char - the character performing the action. Must not be nil
--** @param square - not used
--** @param difficulty - the difficulty level
--**
--************************************************************************--
function QSWeaponAutoIMNC:reloadPerform(char, square, difficulty, weapon)
	getSoundManager():PlayWorldSound(self.insertSound, char:getSquare(), 0, 10, 1.0, false);
	self.currentCapacity = self.currentCapacity + 1;
	-- remove the necessary ammo
	char:getInventory():RemoveOneOf(self.ammoType);
	self.reloadInProgress = false;
	self:syncReloadableToItem(weapon);
	char:getXp():AddXP(Perks.Reloading, 1);
	if(self.currentCapacity == self.maxCapacity) then
		return false;
	end
	return true;
end

function QSWeaponAutoIMNC:unloadPerform(char, square, difficulty, weapon)
	getSoundManager():PlayWorldSound(self.rackSound, char:getSquare(), 0, 10, 1.0, false);
	self.currentCapacity = self.currentCapacity - 1;
	char:getInventory():AddItem('QS.'..self.ammoType);
	self.unloadInProgress = false;
	self:syncReloadableToItem(weapon);
	char:getXp():AddXP(Perks.Reloading, 1);
	if(self.currentCapacity == 0) then
		return false;
	end
	return true;
end

--************************************************************************--
--** QSWeaponAutoIMNC:rackingStart
--**
--** Function that should be performed upon the start of the timed action
--**
--** @param char - the character performing the action. Must not be nil
--** @param square - not used
--**
--************************************************************************--
function QSWeaponAutoIMNC:rackingStart(char, square, weapon)
    getSoundManager():PlayWorldSound(self.rackSound, char:getSquare(), 0, 10, 1.0, false);
end

--************************************************************************--
--** QSWeaponAutoIMNC:rackingPerform
--**
--** Function that should be performed upon successful completion of the
--** timed action
--**
--** @param char - the character performing the action. Must not be nil
--** @param square - not used
--** @param weapon - the item being reloaded
--**
--************************************************************************--
function QSWeaponAutoIMNC:rackingPerform(char, square, weapon)

 	self:syncReloadableToItem(weapon);
end

--************************************************************************--
--** QSWeaponAutoIMNC:getRackTime
--**
--** Returns the time take to perform the reload action
--**
--************************************************************************--
function QSWeaponAutoIMNC:getRackTime()
	return self.rackTime;
end

function QSWeaponAutoIMNC:isChainUnloading()
	return true;
end

--************************************************************************--
--** QSWeaponAutoIMNC:getReloadTime
--**
--** Returns the time take to perform a single reload action
--**
--************************************************************************--
function QSWeaponAutoIMNC:getReloadTime()
	return self.reloadTime;
end

--************************************************************************--
--** QSWeaponAutoIMNC:syncItemToReloadable
--**
--** Function that copies details from an Item's modData to the instance
--** of this QSWeaponAutoIMNC
--**
--** @param weapon - the weapon from which the reloadable information
--** should be retrieved
--**
--************************************************************************--
function QSWeaponAutoIMNC:syncItemToReloadable(weapon)
	local modData = weapon:getModData();
	 -- handle switching difficulty
	ISReloadableWeapon.syncItemToReloadable(self, weapon);
end

--************************************************************************--
--** QSWeaponAutoIMNC:syncReloadableToItem
--**
--** Function that copies details from the instance of this
--** QSWeaponAutoIMNC to an Item's modData
--**
--** @param weapon - the weapon to which the reloadable information
--** should be copied
--**
--************************************************************************--
function QSWeaponAutoIMNC:syncReloadableToItem(weapon)
	 -- handle switching difficulty
	ISReloadableWeapon.syncReloadableToItem(self, weapon);
	local modData = weapon:getModData();
end

--************************************************************************--
--** QSWeaponAutoIMNC:setupReloadable
--**
--** Function that initialises all the required modData on an item.
--**
--** @param weapon - the weapon to setup
--** @param v - the lua table containing the key value pairs to attach
--** to the modData
--************************************************************************--
function QSWeaponAutoIMNC:setupReloadable(weapon, v)
	ISReloadableWeapon.setupReloadable(self, weapon, v);
	local modData = weapon:getModData();
end

function QSWeaponAutoIMNC:printWeaponDetails(item)
    self:printItemDetails(item);
    local modData = item:getModData();
    local outString  = '';
    print(outString);
    print('***************************************************************');
    print();
    print();
end


function QSWeaponAutoIMNC:printReloadableWeaponDetails()
    self:printReloadableDetails();
    local outString  = '';
    print(outString);
    print('***************************************************************');
    print();
    print();
end
