--***********************************************************
--**                    THE INDIE STONE                    **
--***********************************************************

require "Farming/basicFarming"

local Commands = {}
local noise = basicFarming.noise

function Commands.cureFlies(player, args)
	local plant = basicFarming.getPlantAt(args.x, args.y, args.z)
	if plant and plant.fliesLvl > 0 then
		basicFarming.cureFlies(plant, nil, args.uses)
	elseif not plant then
		noise('no plant found at '..args.x..','..args.y..','..args.z)
	end
end

function Commands.cureMildew(player, args)
	local plant = basicFarming.getPlantAt(args.x, args.y, args.z)
	if plant and plant.mildewLvl > 0 then
		basicFarming.cureMildew(plant, nil, args.uses)
	elseif not plant then
		noise('no plant found at '..args.x..','..args.y..','..args.z)
	end
end

function Commands.fertilize(player, args)
	local plant = basicFarming.getPlantAt(args.x, args.y, args.z)
	if plant then
		basicFarming.fertilize(null, plant)
	else
		noise('no plant found at '..args.x..','..args.y..','..args.z)
	end
end

function Commands.harvest(player, args)
	local plant = basicFarming.getPlantAt(args.x, args.y, args.z)
	if plant and plant:canHarvest() then
		basicFarming.harvest(plant, player)
	else
		noise('no plant found at '..args.x..','..args.y..','..args.z)
	end
end

function Commands.plow(player, args)
	local gridSquare = getCell():getGridSquare(args.x, args.y, args.z)
	if gridSquare then
		local plant = basicFarming.getPlantOnSquare(gridSquare)
		if plant then
			basicFarming.removePlant(plant)
		end
		basicFarming.plow(gridSquare)
	else
		noise('no gridSquare at '..args.x..','..args.y..','..args.z)
	end
end

function Commands.removePlant(player, args)
	local plant = basicFarming.getPlantAt(args.x, args.y, args.z)
	if plant then
		basicFarming.removePlant(plant)
	else
		noise('no plant found at '..args.x..','..args.y..','..args.z)
	end
end

function Commands.seed(player, args)
	local plant = basicFarming.getPlantAt(args.x, args.y, args.z)
	if plant and plant.state == "plow" then
		basicFarming.seed(args.typeOfSeed, plant)
	elseif not plant then
		noise('no plant found at '..args.x..','..args.y..','..args.z)
	else
		noise('ignored, plant not plowed at '..args.x..','..args.y..','..args.z)
	end
end

function Commands.water(player, args)
	local plant = basicFarming.getPlantAt(args.x, args.y, args.z)
	if plant then
		basicFarming.water(plant, null, args.uses)
	else
		noise('no plant found at '..args.x..','..args.y..','..args.z)
	end
end

function Commands.cheat(player, args)
	local plant = basicFarming.getPlantAt(args.x, args.y, args.z)
	if plant then
		plant[args.var] = plant[args.var] + args.count
		if plant[args.var] < 0 then plant[args.var] = 0 end
		if plant[args.var] > 100 then plant[args.var] = 100 end
		basicFarming.saveData(plant)
	else
		noise('no plant found at '..args.x..','..args.y..','..args.z)
	end
end

function basicFarming.OnClientCommand(module, command, player, args)
	if module ~= 'farming' then return end
	if Commands[command] then
		local argStr = ''
		for k,v in pairs(args) do argStr = argStr..' '..k..'='..v end
		noise('OnClientCommand '..module..' '..command..argStr)
		Commands[command](player, args)
	end
end

function basicFarming.OnServerCommand(module, command, args)
	if not isClient() then return end
	if module ~= 'farming' then return end
	local argStr = ''
	for k,v in pairs(args) do argStr = argStr..' '..k..'='..v end
	noise('OnServerCommand '..module..' '..command..argStr)
	if command == "hoursElapsed" then
		basicFarming.hoursElapsed = args.hoursElapsed
	end
end

Events.OnServerCommand.Add(basicFarming.OnServerCommand)

if isServer() then
	Events.OnClientCommand.Add(basicFarming.OnClientCommand)
end
