HCPlacingMenu = {};
HCPlacingMenu.currentSquare = nil;

function HCPlacingMenu.doPlacingMenu(player, context, worldobjects)
	if getSpecificPlayer(player):getInventory():contains("HCStonepillar") then
		context:addOption("Place Stone Pillar", worldobjects, HCPlacingMenu.onPlacePillar, player);
	end
	
	if getSpecificPlayer(player):getInventory():contains("HCLogpillar") then
		context:addOption("Place Log Pillar", worldobjects, HCPlacingMenu.onPlaceLPillar, player);
	end
	
	if getSpecificPlayer(player):getInventory():contains("HCBrickpillar") then
		context:addOption("Place Brick Pillar", worldobjects, HCPlacingMenu.onPlaceBPillar, player);
	end
	
	if getSpecificPlayer(player):getInventory():contains("HCWoodbeam") then
		context:addOption("Place Beam Pillar", worldobjects, HCPlacingMenu.onPlaceBePillar, player);
	end
	
	if getSpecificPlayer(player):getInventory():contains("HCLogbarricade") then
		context:addOption("Place Log Barricade", worldobjects, HCPlacingMenu.onPlaceLBarricade, player);
	end
	
	if getSpecificPlayer(player):getInventory():contains("HCBarbedwirebarricade") then
		context:addOption("Place Barbed Wire Barricade", worldobjects, HCPlacingMenu.onPlaceBWBarricade, player);
	end
	
	if getSpecificPlayer(player):getInventory():contains("HCConcertinawirebarricade") then
		context:addOption("Place Concertina Wire Barricade", worldobjects, HCPlacingMenu.onPlaceCWBarricade, player);
	end
	
	if getSpecificPlayer(player):getInventory():contains("HCSandbagbarricade") then
		context:addOption("Place Sand Bag Barricade", worldobjects, HCPlacingMenu.onPlaceSBBarricade, player);
	end
end

function HCPlacingMenu.onPlacePillar(worldobjects, player)
	local bo = HCStonePillar:new("media/textures/Object_HCStonepillar.png", player);
	bo.player = player;
	getCell():setDrag(bo, player);
end

function HCPlacingMenu.onPlaceLPillar(worldobjects, player)
	local bo = HCLogPillar:new("media/textures/Object_HCLogpillar.png", player);
	bo.player = player;
	getCell():setDrag(bo, player);
end

function HCPlacingMenu.onPlaceBPillar(worldobjects, player)
	local bo = HCBrickPillar:new("media/textures/Object_HCBrickpillar.png", player);
	bo.player = player;
	getCell():setDrag(bo, player);
end

function HCPlacingMenu.onPlaceBePillar(worldobjects, player)
	local bo = HCBeamPillar:new("media/textures/Object_HCBeampillar.png", player);
	bo.player = player;
	getCell():setDrag(bo, player);
end

function HCPlacingMenu.onPlaceLBarricade(worldobjects, player)
	local bo = HCLogBarricade:new("media/textures/Object_HCLogbarricadeL.png", "media/textures/Object_HCLogbarricadeR.png", player);
	bo.player = player;
	getCell():setDrag(bo, player);
end

function HCPlacingMenu.onPlaceBWBarricade(worldobjects, player)
	local bo = HCBarbedWireBarricade:new("media/textures/Object_HCBarbedwirebarricadeL.png", "media/textures/Object_HCBarbedwirebarricadeR.png", player);
	bo.player = player;
	getCell():setDrag(bo, player);
end

function HCPlacingMenu.onPlaceCWBarricade(worldobjects, player)
	local bo = HCConcertinaWireBarricade:new("media/textures/Object_HCConcertinawirebarricadeL.png", "media/textures/Object_HCConcertinawirebarricadeR.png", player);
	bo.player = player;
	getCell():setDrag(bo, player);
end

function HCPlacingMenu.onPlaceSBBarricade(worldobjects, player)
	local bo = HCSandBagBarricade:new("media/textures/Object_HCSandbagbarricadeL.png", "media/textures/Object_HCSandbagbarricadeR.png", player);
	bo.player = player;
	getCell():setDrag(bo, player);
end


Events.OnFillWorldObjectContextMenu.Add(HCPlacingMenu.doPlacingMenu);