--***********************************************************
--**                    ROBERT JOHNSON                     **
--***********************************************************

require "TimedActions/ISBaseTimedAction"

ISSeedAction = ISBaseTimedAction:derive("ISSeedAction");

function ISSeedAction:isValid()
	return true;
end

function ISSeedAction:update()
end

function ISSeedAction:start()
end

function ISSeedAction:stop()
    ISBaseTimedAction.stop(self);
end

--Added Supported Vines consume TrellisKit
function ISSeedAction:perform()
	local currentPlant = self.plant;
	for i=1, self.nbOfSeed do
		local seed = self.seeds[i];
		if self.typeOfSeed == "Bean" or self.typeOfSeed == "BellPepper" or self.typeOfSeed == "Eggplant" or self.typeOfSeed == "Grape" or self.typeOfSeed == "Pea" then
			self.character:getInventory():Remove("TrellisKit");
			self.character:getInventory():Remove(seed);
		else
			self.character:getInventory():Remove(seed);
		end
	end
	if isClient() then
		local sq = self.plant:getSquare()
		local args = { x = sq:getX(), y = sq:getY(), z = sq:getZ(), typeOfSeed = self.typeOfSeed }
		sendClientCommand(self.character, 'farming', 'seed', args)
	else
		basicFarming.seed(self.typeOfSeed, currentPlant)
	end
    -- needed to remove from queue / start next.
	ISBaseTimedAction.perform(self);
end

function ISSeedAction:new(character, seeds, nbOfSeed, typeOfSeed, plant, time)
	local o = {}
	setmetatable(o, self)
	self.__index = self
	o.character = character;
	o.seeds = seeds;
	o.nbOfSeed = nbOfSeed;
	o.typeOfSeed = typeOfSeed;
    o.plant = plant;
	o.stopOnWalk = true;
	o.stopOnRun = true;
	o.maxTime = time;
	return o;
end
