local mdir = "statusplus"
local rdir = mdir.."/"
local idir = "images/"..rdir

local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"
local Text = require "widgets/text"
local easing = require "easing"

local TempBadge = Class(Widget, function(self, owner)
	Widget._ctor(self, "TempBadge")
	self.owner = owner
	self:SetScale(1,1,1)
	self.unitstr = "\176"

	self.icon = self:AddChild(Image("images/inventoryimages.xml", "winterometer.tex"))
	self.icon:SetScale(2,1,1)
	self.icon:SetPosition(0,0,0)

	self.underNumber = self:AddChild(Widget("undernumber"))
	self.sanityarrow = self.underNumber:AddChild(UIAnim())
	self.sanityarrow:GetAnimState():SetBank("sanity_arrow")
	self.sanityarrow:GetAnimState():SetBuild("sanity_arrow")
	self.sanityarrow:GetAnimState():PlayAnimation("neutral")
	self.sanityarrow:SetClickable(false)
	self:StartUpdating()
end)

function TempBadge:OnUpdate(dt)
	if not (self.owner and self.owner.components and self.owner.components.temperature) then return end

	local val = self.owner.components.temperature.current
	local rate = self.owner.components.temperature.rate

	self.vmin = self.owner.components.temperature.mintemp
	self.vmax = self.owner.components.temperature.maxtemp

	local overheat = 100
	if self.owner.components.temperature.overheattemp then
		overheat = self.owner.components.temperature.overheattemp
	end
	self.dmax = self:GetP(overheat)
	self.dmin = self:GetP(5)

	local small_down = 0.1
	local med_down = 0.5
	local large_down = 2
	local small_up = small_down
	local med_up = med_down
	local large_up = large_down
	local anim = nil
	anim = "neutral"
	if rate > 0 and val < self.vmax then
		if rate > large_up then
			anim = "arrow_loop_increase_most"
		elseif rate > med_up then
			anim = "arrow_loop_increase_more"
		elseif rate > small_up then
			anim = "arrow_loop_increase"
		end
	elseif rate < 0 and val > self.vmin then
		if rate < -large_down then
			anim = "arrow_loop_decrease_most"
		elseif rate < -med_down then
			anim = "arrow_loop_decrease_more"
		elseif rate < -small_down then
			anim = "arrow_loop_decrease"
		end
	end
	
	if anim and self.arrowdir ~= anim then
		self.arrowdir = anim
		self.sanityarrow:GetAnimState():PlayAnimation(anim, true)
	end
	self:DrawTemp(val)
end

return TempBadge