local mdir = "statusplus"
local rdir = mdir.."/"
local idir = "images/"..rdir

local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"
local Text = require "widgets/text"
local easing = require "easing"

local SPThirstBadge = Class(Widget, function(self, owner)
	Widget._ctor(self, "SPThirstBadge")
	self.owner = owner
	self:SetScale(1,1,1)

	self.icon = self:AddChild(Image("images/inventoryimages.xml", "goatmilk.tex"))
--	self.icon = self:AddChild(Image(idir.."glass.xml", "glass.tex"))
	self.icon:SetScale(1,1,1)
	self.icon:SetPosition(0,0,0)

	self.underNumber = self:AddChild(Widget("undernumber"))
	self.sanityarrow = self.underNumber:AddChild(UIAnim())
	self.sanityarrow:GetAnimState():SetBank("sanity_arrow")
	self.sanityarrow:GetAnimState():SetBuild("sanity_arrow")
	self.sanityarrow:GetAnimState():PlayAnimation("neutral")
	self.sanityarrow:SetClickable(false)
	self:StartUpdating()
end)

function SPThirstBadge:OnUpdate(dt)
	if not (self.owner and self.owner.components and self.owner.components.thirst) then print ("No thirst") return end

	if self.owner.HUD and self.owner.HUD.controls and self.owner.HUD.controls.sidepanel and self.owner.HUD.controls.sidepanel.thirst then
		local old = self.owner.HUD.controls.sidepanel.thirst
		if old:IsEnabled() then
			old:Hide()
			old:Disable()
		end
	else
		if not self.dontwarn then print ("StatusPlus : Thirst - can't find old widget") end
		self.dontwarn=true -- prevent spam
	end

	local t = self.owner.components.thirst
	local val = t.current
	local rate = - t:GetDelta()

--	print ("rate = "..tostring(rate))
	self.vmin = 0
	self.vmax = t.max

	self.dmax = 0.5
	self.dmin = 0.2

--	local small_down = 0.1
--	local med_down = 0.5
--	local large_down = 2

	local small_down = 0.4
	local med_down = 0.7
	local large_down = 1

	local small_up = small_down
	local med_up = med_down
	local large_up = large_down
	local anim = nil
	anim = "neutral"
	if rate > 0 and val < self.vmax then
		if rate > large_up then
			anim = "arrow_loop_increase_most"
		elseif rate > med_up then
			anim = "arrow_loop_increase_more"
		elseif rate > small_up then
			anim = "arrow_loop_increase"
		end
	elseif rate < 0 and val > self.vmin then
		if rate < -large_down then
			anim = "arrow_loop_decrease_most"
		elseif rate < -med_down then
			anim = "arrow_loop_decrease_more"
		elseif rate < -small_down then
			anim = "arrow_loop_decrease"
		end
	end
	
	if anim and self.arrowdir ~= anim then
		self.arrowdir = anim
		self.sanityarrow:GetAnimState():PlayAnimation(anim, true)
	end
	self:DrawValue(val)
end

return SPThirstBadge