local mdir = "statusplus"
local rdir = mdir.."/"
local idir = "images/"..rdir

local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"
local Text = require "widgets/text"
local easing = require "easing"

local SPSleepinessBadge = Class(Widget, function(self, owner)
	Widget._ctor(self, "SPsleepinessBadge")
	self.owner = owner
	self:SetScale(1,1,1)

	self.icon = self:AddChild(Image("images/inventoryimages.xml", "bedroll_straw.tex"))
--	self.icon = self:AddChild(Image(idir.."glass.xml", "glass.tex"))
	self.icon:SetScale(1,1,1)
	self.icon:SetPosition(0,0,0)

	self.underNumber = self:AddChild(Widget("undernumber"))
	self.sanityarrow = self.underNumber:AddChild(UIAnim())
	self.sanityarrow:GetAnimState():SetBank("sanity_arrow")
	self.sanityarrow:GetAnimState():SetBuild("sanity_arrow")
	self.sanityarrow:GetAnimState():PlayAnimation("neutral")
	self.sanityarrow:SetClickable(false)
	self:StartUpdating()
end)

function SPSleepinessBadge:OnUpdate(dt)
	if not (self.owner and self.owner.components and self.owner.components.sleepiness) then print ("No sleepiness") return end

	if self.owner.HUD and self.owner.HUD.controls and self.owner.HUD.controls.status and self.owner.HUD.controls.status.sleepy then
		local old = self.owner.HUD.controls.status.sleepy
		if old:IsEnabled() then
			old:Hide()
			old:Disable()
		end
	else
		if not self.dontwarn then print ("StatusPlus : Sleepiness - can't find old widget") end
		self.dontwarn=true -- prevent spam
	end

	local t = self.owner.components.sleepiness
	local val = t.current

	self.vmin = 0
	self.vmax = t.max

	self.dmax = 0.5
	self.dmin = 0.2

	self:DrawReverseValue(val)
end

return SPSleepinessBadge