local mdir = "statusplus"
local rdir = mdir.."/"
local idir = "images/"..rdir

--require "statusplus/craputil"
local Widget = require "widgets/widget"
local Text = require "widgets/text"
local easing = require "easing"

local HPBadge = Class(Widget, function(self, owner, sponame, imagexml, imagetex)
	Widget._ctor(self, "HPBadge")
	self.owner = owner
	self:SetScale(1,1,1)

	if imagexml and (not imagetex) then imagetex = imagexml end
	if not imagexml then
		imagetex = "skull_wilson"
		imagexml = "images/inventoryimages"
	else
		imagexml = idir..imagexml
	end

	self.icon = self:AddChild(Image(imagexml..".xml", imagetex..".tex"))
	self.icon:SetScale(1,1,1)
	self.icon:SetPosition(-6,0,0)
	self.dmin = 0.3
	self.dmax = 0.6
	self.findrate = 5
	self.monrate = 1.0
	self.sponame = sponame
end)

function HPBadge:HPEnabled()
	local p = GetPlayer()
	local f = true
	if self.sponame and p and p.components and p.components.spdata and p.components.spdata.data and p.components.spdata.data[self.sponame] then
		f = p.components.spdata.data[self.sponame].data
	end
	return f
end

function HPBadge:SetTarget(inst)
	if self.hptarget then self:StopMon() end
	self.hptarget = inst
	self:StartMon()
end

function HPBadge:FindTarget(tag,autofind)  -- autofind target on death
	local this = self
	self:SetTarget(TheSim:FindFirstEntityWithTag(tag))
	if self.autofind then KillTask(self.owner,self.autofind) end
	if self.owner and self.owner.DoPeriodicTask then
		if autofind then 
			self.autofind = self.owner:DoPeriodicTask(self.findrate,
			function (i)
				if this.hptarget or (not this:HPEnabled()) then return end
				this:SetTarget(TheSim:FindFirstEntityWithTag(tag))
			end)
		end
	end
end

function HPBadge:StartMon()
	local this = self
	if self.hpmon then return end
	if not self.hptarget then return end
	if self.owner and self.owner.DoPeriodicTask then
		self.hpmon = self.owner:DoPeriodicTask(self.monrate,
			function (i)
				if not this.hptarget then 
					this:StopMon()
					return
				end
				if this.hptarget.components and this.hptarget.components.health and this.DrawValue then
					this.vmax = this.hptarget.components.health:GetMaxHealth()
					local hp = this.hptarget.components.health.currenthealth
					if (hp == nil) or (hp == 0) then 
						self:SetTarget(nil)
						this:DrawValue(0)
					else
						this:DrawValue(hp)
					end
				end
			end)
	end	
end

function HPBadge:StopMon()
	if self.hpmon then
		KillTask(self.owner,self.hpmon)
		self.hpmon = nil
	end
end

function HPBadge:OnUpdate(dt)
end

return HPBadge