require "util"
require "rincewind/craputil"
require "strings"
local Screen = require "widgets/screen"
local Button = require "widgets/button"
local Menu = require "widgets/menu"
local Grid = require "widgets/grid"
local Text = require "widgets/text"
local Spinner = require "widgets/spinner"
local Widget = require "widgets/widget"

local textfont = UIFONT
local spinnerFont = { font = BUTTONFONT, size = 28 }
local enableDisableOptions = { { text = STRINGS.UI.OPTIONS.DISABLED, data = false }, { text = STRINGS.UI.OPTIONS.ENABLED, data = true } }
local IsDLC1 = IsDLCEnabled and REIGN_OF_GIANTS and IsDLCEnabled(REIGN_OF_GIANTS)

--------------------------------------------------------------------------------------------------------------------------------------------------

local SPOptionsScreen = Class(Screen, function(self)
	Screen._ctor(self, "SPOptionsScreen")

	self.active = true
	SetPause(true,"pause")

	self.data = nil
	local p = GetPlayer()
	if p and p.components and p.components.spdata and p.components.spdata.data and (type(p.components.spdata.data)=="table") then
		self.data = p.components.spdata.data
		self.spdata = p.components.spdata
	end

	self.root = self:AddChild(Widget("ROOT"))
	self.root:SetVAnchor(ANCHOR_MIDDLE)
	self.root:SetHAnchor(ANCHOR_MIDDLE)
	self.root:SetPosition(0,0,0)
	self.root:SetScaleMode(SCALEMODE_PROPORTIONAL)
    
	local shield = self.root:AddChild( Image( "images/globalpanels.xml", "panel.tex" ) )
	shield:SetPosition( 0,0,0 )
	shield:SetSize( 900, 690 )		

	self.menu = self.root:AddChild(Menu(nil, 200, true))
	self.menu:SetPosition(-150, -250 ,0)
	self.menu:SetScale(0.6)
	self.menu:AddItem("Restore default", function() self:RestoreDefault() end)
	self.menu:AddItem("Save", function() self:SaveProf() end)
	self.menu:AddItem("Load", function() self:LoadProf() end)
	self.menu:AddItem("Close", function() self:Close() end)

	self.grid = self.root:AddChild(Grid())
	self.grid:InitSize(2, 10, 400, -70)
	self.grid:SetPosition(-180, 210, 0)
	self.grid:SetScale(0.9, 0.6, 0.9)

	self.wcolSpinner = Spinner(self:GetWCols())
	self.wcolSpinner.OnChanged = function( _, data ) self:ChangeWCol(data) end

	self.scaleSpinner = Spinner(self:GetScales())
	self.scaleSpinner.OnChanged = function( _, data ) self:ChangeScale(data) end

	self.barscaleSpinner = Spinner(self:GetBarScales())
	self.barscaleSpinner.OnChanged = function( _, data ) self:ChangeBarScale(data) end

	self.colorSpinner = Spinner(self:GetColors())
	self.colorSpinner.OnChanged = function( _, data ) self:ChangeColor(data) end

	self.barSpinner = Spinner(enableDisableOptions)
	self.barSpinner.OnChanged = function( _, data ) self:ChangeBar(data) end

	self.bgSpinner = Spinner(enableDisableOptions)
	self.bgSpinner.OnChanged = function( _, data ) self:ChangeBG(data) end

	self.fgSpinner = Spinner(enableDisableOptions)
	self.fgSpinner.OnChanged = function( _, data ) self:ChangeFG(data) end

	self.numSpinner = Spinner(enableDisableOptions)
	self.numSpinner.OnChanged = function( _, data ) self:ChangeNum(data) end

	self.mouseSpinner = Spinner(enableDisableOptions)
	self.mouseSpinner.OnChanged = function( _, data ) self:ChangeMouse(data) end

	self.keySpinner = Spinner(self:GetKeys())
	self.keySpinner.OnChanged = function( _, data ) self:ChangeKey(data) end

	local spinners = {}
	table.insert(spinners, {"Widgets in column", self.wcolSpinner})
	table.insert(spinners, {"Widget scale", self.scaleSpinner})
	table.insert(spinners, {"Bar length scale", self.barscaleSpinner})
	table.insert(spinners, {"Open settings w/mouse", self.mouseSpinner})
	table.insert(spinners, {"Open settings on ALT+", self.keySpinner})
	table.insert(spinners, {"Frame behind", self.barSpinner})
	table.insert(spinners, {"BG bar", self.bgSpinner})
	table.insert(spinners, {"FG bar (require BG)", self.fgSpinner})
	table.insert(spinners, {"Show numbers", self.numSpinner})
	table.insert(spinners, {"Color scheme", self.colorSpinner})

	for k,v in ipairs(spinners) do self.grid:AddItem(self:CreateSpinnerGroup(v[1], v[2]), 1, k) end

	self.widgetlist = self:GetWidgetList()

	spinners = {}
	for k,v in pairsByKeys(self.widgetlist) do
		self.widgetlist[k].spinner = Spinner(enableDisableOptions)
		self.widgetlist[k].spinner.OnChanged = function( _, data ) self:ChangeWidget(k,data) end
		table.insert( spinners, { self.widgetlist[k].text, self.widgetlist[k].spinner } )
	end
	for k,v in ipairs(spinners) do self.grid:AddItem(self:CreateSpinnerGroup(v[1], v[2]), 2, k) end

	self:InitializeSpinners()
	self.default_focus = self.grid
end)

function SPOptionsScreen:ChangeWidget(k,data)
	if self.data then 
		self.data[k].data = data
		self.spdata:Apply()
	end
end

function SPOptionsScreen:GetScales()
	if self.scaleslist then return self.scaleslist end
	self.scaleslist = {}
	for i = 0.5,1,0.1 do
		table.insert( self.scaleslist, {text = tostring(i), data = i } )
	end
	return self.scaleslist
end

function SPOptionsScreen:GetKeys()
	if self.keyslist then return self.keyslist end -- i am sure its pretty safe to use cashed version of array per session, dont think that during pause game state someone will change keyboard handler
	self.keyslist = GetFreeKeyList(self.data.keycode)
	return self.keyslist
end

function SPOptionsScreen:GetWCols()
	if self.wcolslist then return self.wcolslist end
	self.wcolslist = {}
	for i = 3,10,1 do
		table.insert( self.wcolslist, {text = tostring(i), data = i } )
	end
	return self.wcolslist
end

function SPOptionsScreen:GetBarScales()
	if self.barscaleslist then return self.barscaleslist end
	self.barscaleslist = {}
	for i = 0.4,1,0.1 do
		table.insert(self.barscaleslist, {text = tostring(i), data = i})
	end
	return self.barscaleslist
end

function SPOptionsScreen:GetColors()
	if self.colorslist then return self.colorslist end
	self.colorslist = {}
	table.insert(self.colorslist, {text = "Default", data = "default"})
	table.insert(self.colorslist, {text = "GreenOnly", data = "greenonly"})
	table.insert(self.colorslist, {text = "Bright", data = "bright"})
	table.insert(self.colorslist, {text = "Greyscale", data = "greyscale"})
	return self.colorslist
end

function SPOptionsScreen:GetWidgetList()
	if self.widgetlist then return self.widgetlist end
	self.widgetlist = {}
	if self.data then
		local p = GetPlayer()
		for k,v in pairsByKeys(self.data) do
			if self.data[k] and (type(self.data[k])=="table") and self.data[k].text then
				local f = true
				if (k == "beaver") and (p.prefab~="woodie") then f = false end
				if (k == "abigail") and (p.prefab~="wendy") then f = false end
				if (k == "wxlevel") and (p.prefab~="wx78") then f = false end
				if ((k == "glommer") or (k == "moistre")) and (not IsDLC1) then f = false end
				if (k == "thirst") and (not (p.components.thirst)) then f = false end
				if (k == "sleep") and (not (p.components.sleepiness)) then f = false end
				if (k == "sunshine") and (not (p.components.sunshine)) then f = false end
				if f then
					self.widgetlist[k] = {}
					self.widgetlist[k].text = self.data[k].text
					self.widgetlist[k].data = self.data[k].data
				end
			end
		end
	end
	return self.widgetlist
end

function SPOptionsScreen:RestoreDefault()
	if self.spdata then self.spdata:Restore() end
	self:Close()
end

function SPOptionsScreen:SaveProf()
	if self.spdata then self.spdata:SaveProf() end
	self:Close()
end

function SPOptionsScreen:LoadProf()
	if self.spdata then self.spdata:LoadProf() end
	self:Close()
end

function SPOptionsScreen:Close()
	self.active = false
	SetPause(false)
	TheFrontEnd:PopScreen()
end	

function SPOptionsScreen:CreateSpinnerGroup( text, spinner )
	local label_width = 200
	spinner:SetTextColour(0,0,0,1)
	local group = Widget("SpinnerGroup")
	local label = group:AddChild( Text( textfont, 30, text ) )
	label:SetPosition( -label_width/2, 0, 0 )
	label:SetRegionSize( label_width, 50 )
	label:SetHAlign( ANCHOR_RIGHT )
	group:AddChild( spinner )
	spinner:SetPosition( 125, 0, 0 )
	group.focus_forward = spinner
	return group
end

function SPOptionsScreen:ChangeScale(data)
	if self.data then 
		self.data.scale = data 
		self.spdata:Apply()
	end
end

function SPOptionsScreen:ChangeKey(data)
	if self.data then 
		self.data.keycode = data 
		self.spdata:Apply()
	end
end

function SPOptionsScreen:ChangeBarScale(data)
	if self.data then 
		self.data.barscale = data 
		self.spdata:Apply()
	end
end

function SPOptionsScreen:ChangeWCol(data)
	if self.data then 
		self.data.wcol = data 
		self.spdata:Apply()
	end
end

function SPOptionsScreen:ChangeColor(data)
	if self.data then 
		self.data.color = data
		self.spdata:Apply()
	end
end

function SPOptionsScreen:ChangeMouse(data)
	if self.data then self.data.mouse = data end
end

function SPOptionsScreen:ChangeBar(data)
	if self.data then 
		self.data.enablebar = data 
		self.spdata:Apply()
	end
end

function SPOptionsScreen:ChangeBG(data)
	if self.data then 
		self.data.enablebg = data 
		self.spdata:Apply()
	end
end

function SPOptionsScreen:ChangeFG(data)
	if self.data then 
		self.data.enablefg = data 
		self.spdata:Apply()
	end
end

function SPOptionsScreen:ChangeNum(data)
	if self.data then 
		self.data.enablenum = data 
		self.spdata:Apply()
	end
end

local function EnabledOptionsIndex( enabled )
	if enabled then	return 2 else return 1 end
end

function SPOptionsScreen:OnControl(control, down)
	if SPOptionsScreen._base.OnControl(self,control, down) then return true end

	if (control == CONTROL_PAUSE or control == CONTROL_CANCEL) and not down then	
		self.active = false
		TheFrontEnd:PopScreen() 
		SetPause(false)
		return true
	end

end

function SPOptionsScreen:OnUpdate(dt)
	if self.active then
		SetPause(true)
	end
end

function SPOptionsScreen:InitializeSpinners()
	if not self.data then return end

	self.barSpinner:SetSelectedIndex(EnabledOptionsIndex(self.data.enablebar))
	self.fgSpinner:SetSelectedIndex(EnabledOptionsIndex(self.data.enablefg))
	self.bgSpinner:SetSelectedIndex(EnabledOptionsIndex(self.data.enablebg))
	self.numSpinner:SetSelectedIndex(EnabledOptionsIndex(self.data.enablenum))
	self.mouseSpinner:SetSelectedIndex(EnabledOptionsIndex(self.data.mouse))
 
	local sc = self:GetScales()
	for i = 1,#sc do
		if math.abs(sc[i].data - self.data.scale) < 0.05 then 
			self.scaleSpinner:SetSelectedIndex(i)
			break
		end
	end

	local wc = self:GetWCols()
	for i = 1,#wc do
		if math.abs(wc[i].data - self.data.wcol) < 0.05 then 
			self.wcolSpinner:SetSelectedIndex(i)
			break
		end
	end

	local keys = self:GetKeys()
	for i = 1,#keys do
		if math.abs(keys[i].data - self.data.keycode) < 0.05 then 
			self.keySpinner:SetSelectedIndex(i)
			break
		end
	end

	local sb = self:GetBarScales()
	for i = 1,#sb do
		if math.abs(sb[i].data - self.data.barscale) < 0.05 then 
			self.barscaleSpinner:SetSelectedIndex(i)
			break
		end
	end

	local col = self:GetColors()
	for i = 1,#col do
		if col[i].data == self.data.color then 
			self.colorSpinner:SetSelectedIndex(i)
			break
		end
	end

	for k,v in pairsByKeys(self.widgetlist) do
		self.widgetlist[k].spinner:SetSelectedIndex(EnabledOptionsIndex(self.widgetlist[k].data))
	end
end

return SPOptionsScreen