require "util"
require "rincewind/craputil"

print ("StatusPlus : SPData component")

local SPData = Class(function(self, inst)
	self.inst = inst
	self.data = {}
	self.done = false
end)

function SPData:SetData(newdata)
	self.data = deepcopy(newdata)
end

function SPData:SetApplyFunc(func)
	if func and (type(func)=="function") then
		print ("SPData : setting apply function")
		self.applyfn = func
	end
end

function SPData:SetLoadFunc(func)
	if func and (type(func)=="function") then
		print ("SPData : setting load function")
		self.loadproffn = func
	end
end

function SPData:SetSaveFunc(func)
	if func and (type(func)=="function") then
		print ("SPData : setting save function")
		self.saveproffn = func
	end
end

function SPData:Apply()
	if self.applyfn then self.applyfn() end
end

function SPData:SaveProf()
	if self.saveproffn then self.saveproffn() end
end

function SPData:LoadProf()
	if self.loadproffn then self.loadproffn() end
end

function SPData:SetRestoreFunc(func)
	if func and (type(func)=="function") then
		print ("SPData : setting restore function")
		self.restorefn = func
	end
end

function SPData:Restore()
	if self.restorefn then self.restorefn() end
end

function SPData:GetData()
	return deepcopy(self.data)
end

function SPData:GetColor()
	if self.data and self.data.color then return self.data.color else return "default" end
end

function SPData:OnSave()    
	return {d = self.data}
end

function SPData:Merge(d)		-- merge options instead of override, if key not exists in new data, its will be saved.
	if not (d and (type(d)=="table")) then 
		print ("SPData Merge : input data is not exists or not valid")
		return 
	end
	for k, v in pairs(d) do
		if type(d[k])=="table" then self.data[k] = deepcopy(d[k]) else self.data[k] = d[k] end
	end
end

function SPData:OnLoad(data)
	if data then 
		if data.d and (type(data.d)=="table") and data.d.color and data.d.scale and data.d.barscale and data.d.sanity 
			and (type(data.d.sanity)=="table") then -- basic check if save is empty or bugged. veeeery basic.
				self:Merge(data.d)
		else
			print ("SPData Onload : something wrong with saved data, prefer to stay with default")
		end
	end
	self.done = true
end

function SPData:Status()
	print("SPData : done = "..tostring(self.done))
	PrintArray(self.data,"data")
end

return SPData
