local mdir = "statusplus"
local rdir = mdir.."/"
local idir = "images/"..rdir
local a = {"whitebar","bar","krampus","chester","glommer","abigail"}

Assets = {}
for k, v in pairs(a) do table.insert(Assets, Asset("ATLAS", idir..tostring(v)..".xml")) end

local IsDLC1 = GLOBAL.IsDLCEnabled and GLOBAL.REIGN_OF_GIANTS and GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS)

require	= GLOBAL.require

require "util"
require "rincewind/craputil"

local deepcopy		= GLOBAL.deepcopy
local PrintArray 	= GLOBAL.PrintArray
local array2str		= GLOBAL.array2str
local str2array		= GLOBAL.str2array
local cmp		= GLOBAL.cmp

local Kramped 		= require "components/spkramped"
local Widget 		= require "widgets/widget"
local Text 		= require "widgets/text"
local HungerBadge	= require "widgets/hungerbadge"
local HealthBadge	= require "widgets/healthbadge"
local SanityBadge	= require "widgets/sanitybadge"
local TempBadge		= require "widgets/tempbadge"
local KrampusBadge	= require "widgets/krampusbadge"
local HPBadge		= require "widgets/hpbadge"
local SPThirstBadge	= require "widgets/spthirstbadge"
local SPSleepBadge	= require "widgets/spsleepbadge"
local Eater		= require "components/wxeater"
local MoistureMeter 	= nil

local MOUSEBUTTON_MIDDLE 	= GLOBAL.MOUSEBUTTON_MIDDLE
local MOUSEBUTTON_RIGHT 	= GLOBAL.MOUSEBUTTON_RIGHT
local MOUSEBUTTON_LEFT 		= GLOBAL.MOUSEBUTTON_LEFT

local KEY_CTRL	= GLOBAL.KEY_CTRL
local KEY_ALT	= GLOBAL.KEY_ALT
local KEY_SHIFT	= GLOBAL.KEY_SHIFT
local KEY_E	= GLOBAL.KEY_E
local KEY_A	= GLOBAL.KEY_A
local KEY_Z	= GLOBAL.KEY_Z

local KeyDownHandler = nil
local KeyDownCode = nil

string		= GLOBAL.string
tonumber	= GLOBAL.tonumber
GetPlayer	= GLOBAL.GetPlayer
TheInput	= GLOBAL.TheInput
TheSim		= GLOBAL.TheSim
Image		= GLOBAL.Image
NUMBERFONT 	= GLOBAL.NUMBERFONT
TUNING 		= GLOBAL.TUNING
IsPaused	= GLOBAL.IsPaused
TheFrontEnd	= GLOBAL.TheFrontEnd

if IsDLC1 then
	MoistureMeter 	= require "widgets/moisturemeter"
end

local SPOptionsScreen 	= require "screens/spoptions"
local Badge 		= require "widgets/badge"
local UIAnim 		= require "widgets/uianim"

-------------------------------------------------------------------------------------------------------------------------------------

local delimer = " / "
local indicator = 80 	-- size of indicator
local barsize = 256	-- bar size
local curwidget = 0
local spwidget = {}
local widgetsnap = 8

-------------------------------------------------------------------------------------------------------------------------------------

local spo 	= {}		-- options
spo.wcol	= 5		-- widgets in one default column
spo.scale 	= 0.8		-- widget scale
spo.barscale 	= 0.7		-- bar length scale
spo.mouse 	= true		-- left mouse button click on widget opens options menu
spo.color 	= "default"	-- color scheme
spo.keycode	= KEY_E		-- ALT + keycode = options menu

spo.enablebar	= true		-- enable frame behind bar
spo.enablefg	= true		-- enable foreground bar
spo.enablebg	= true		-- enable background bar
spo.enablenum	= true		-- enable numbers on bar

spo.sanity 	= {text = "Sanity", data = true}
spo.health 	= {text = "Health", data = true}
spo.hunger 	= {text = "Hunger", data = true}
spo.moistre 	= {text = "Moisture (DLC)", data = true}
spo.temp 	= {text = "Temperature", data = true}
spo.krampus 	= {text = "Naughtiness", data = false}
spo.chester	= {text = "Chester HP", data = false}
spo.beaver 	= {text = "Beaverness", data = false}
spo.abigail	= {text = "Abigail HP", data = false}
spo.glommer	= {text = "Glommer HP(DLC)", data = false}
spo.wxlevel	= {text = "WX78 LVL", data = false}
spo.thirst	= {text = "Thirst (Mod)", data = true}
spo.sleep	= {text = "Sleepiness (Mod)", data = true}
spo.sunshine	= {text = "Sunshine (Mod)", data = true}

local spdata = {}
local k = "default"
spdata[k] = {}
spdata[k]["wx"]		= - math.ceil((barsize * spo.barscale / 2 + indicator ) * spo.scale / widgetsnap) * widgetsnap -- local widget start pos
spdata[k]["wy"]		= math.ceil(10 * spo.scale / widgetsnap) * widgetsnap
spdata[k]["wd"] 	= 0    -- addition for X between indicator and bar
spdata[k]["ws"] 	= spo.scale

spdata[k]["bsx"] 	= 0.9 * spo.barscale	-- bar scale for X
spdata[k]["bsy"] 	= 0.7   -- bar scale for Y
spdata[k]["fsx"] 	= spdata[k].bsx + 0.08 	-- frame scale for X
spdata[k]["fsy"] 	= spdata[k].bsy + 0.35 	-- frame scale for Y

k = "default"
local spcolor = {}
spcolor[k] = {}
spcolor[k]["g"] 	= "42531E"	--green
spcolor[k]["y"] 	= "D07921"	--yellow
spcolor[k]["r"] 	= "9F2D26"	--red
spcolor[k]["b"] 	= "4A536B"	--blue
spcolor[k]["w"] 	= "B59A6B"	--white

k = "bright"
spcolor[k] = {}
spcolor[k]["g"] 	= "21C642"
spcolor[k]["y"] 	= "D2C724"
spcolor[k]["r"] 	= "D22436"
spcolor[k]["b"] 	= "2481D2"
spcolor[k]["w"] 	= "C9C9C9"

k = "greyscale"
spcolor[k] = {}
spcolor[k]["g"] 	= "8D8D8D"
spcolor[k]["y"] 	= "DFDFDF"
spcolor[k]["r"] 	= "4D4D4D"
spcolor[k]["b"] 	= "7B7B7B"
spcolor[k]["w"] 	= "DCDCDC"

k = "greenonly"
spcolor[k] = {}
spcolor[k]["g"] 	= "42531E"	--green
spcolor[k]["y"] 	= spcolor[k]["g"]
spcolor[k]["r"] 	= spcolor[k]["g"]
spcolor[k]["b"] 	= "1D49D8"
spcolor[k]["w"] 	= "B59A6B"

-------------------------------------------------------------------------------------------------------------------------------------

local function GetRGBColor(color,index)
	if (not color) or (type(color)~="string") then
		print ("GetRGBColor : bad color = "..tostring(color))
		return 0
	end
	if (not index) or (type(index)~="number") or (index < 1) then index = 1 end
	if index > 3 then index = 3 end
	local pos = index * 2 - 1
	return tonumber(string.sub(color,pos,pos+1),16)/255
end


--------------------------------------------------------------------------------------------------------------------------------------------

local function ShowOptionsMenu()
	TheFrontEnd:PushScreen(SPOptionsScreen())
end

local function KeyShowOptionsMenu()
	if not IsPaused() and not TheInput:IsKeyDown(KEY_CTRL) and TheInput:IsKeyDown(KEY_ALT) and not TheInput:IsKeyDown(KEY_SHIFT) then
		ShowOptionsMenu()
	end
end

local function ChangeKeyDown(key)
	if not (key and (type(key)=="number")) then
		print ("ChangeKeyDown : invalid key ("..tostring(key)..")")
		return 
	end
	if KeyDownHandler and KeyDownCode and (key == KeyDownCode) then 
		print ("ChangeKeyDown : same key ("..tostring(key).."), skipping...")
		return 
	end
	if KeyDownHandler then TheInput.onkeydown:RemoveHandler(KeyDownHandler) end
	if (key == 0 ) or (key < KEY_A) or (key > KEY_Z) then 
		KeyDownCode = nil
		KeyDownHandler = nil
	else
		KeyDownCode = key
		KeyDownHandler = TheInput:AddKeyDownHandler(KeyDownCode, KeyShowOptionsMenu)
	end
end

local function ApplyCustomData(i)
	local p = GetPlayer()
	if p and p.components and p.components.spdata then
		for k,v in pairs(spwidget) do
			f = true
			if i and not (tostring(k)==tostring(i)) then f = false end
			
			if f and p.components.spdata.data[k] then
				local d = deepcopy(spdata["default"])
				if p.components.spdata.data[k].wx then 
					d.wx = p.components.spdata.data[k].wx 
				elseif spwidget[k].wd  then
					d.wx = spwidget[k].wd.wx 
				end
				if p.components.spdata.data[k].wy then 
					d.wy = p.components.spdata.data[k].wy 
				elseif spwidget[k].wd  then
					d.wy = spwidget[k].wd.wy 
				end
				d.ws = p.components.spdata.data.scale
				d.bsx = 0.9 * p.components.spdata.data.barscale
				d.fsx = d.bsx + 0.08
				spwidget[k]:SetWData(d)
				spwidget[k]:SetWColor(p.components.spdata:GetColor())
				spwidget[k]:ApplyData()
				spwidget[k]:SetFGTint("g")
				spwidget[k]:ReDraw()
				spwidget[k]:ShowWidget(p.components.spdata.data[k].data)
			else
				if f then print ("ApplyCustomData for "..tostring(k).." failed") end
			end
		end
		if p.components.spdata.data.keycode then
			ChangeKeyDown(p.components.spdata.data.keycode)
		end
	end
end

-------------------------------------------------------------------------------------------------------------------------------------

local function TweakNum(inst)
	inst.OldHide = inst.Hide or function() end
	inst.OldDeactivate = inst.Deactivate or function() end
	function inst:Hide() end
	function inst:Deactivate() end

	function inst:DoHide() if self.OldHide then self:OldHide() end end
	function inst:DoDeactivate() if self.OldDeactivate then self:OldDeactivate() end end

	function inst:OnLoseFocus() end
	function inst:OnGainFocus() end
end

local function TweakBadge(inst)
	inst.OldHide = inst.Hide or function() end
	inst.OldDeactivate = inst.Deactivate or function() end
	inst.OldScaleTo = inst.ScaleTo or function() end
	inst.oldOnUpdate = inst.OnUpdate or function() end
	
	function inst:CheckVar()
		if (not self.vmax) or (type(self.vmax)~="number") then self.vmax = 100 end
		if (not self.vmin) or (type(self.vmin)~="number") then self.vmin = 0 end
		if (not self.dmax) or (type(self.dmax)~="number") then self.dmax = 0.7 end
		if (not self.dmin) or (type(self.dmin)~="number") then self.dmin = 0.4 end
		if (not self.oldpercent) or (type(self.oldpercent)~="number") then self.oldpercent = -1000 end
		if self.vmax <= self.vmin then self.vmax = self.vmin + 100 end
		if (not self.unitstr) or (type(self.unitstr)~="string") then self.unitstr = "" end
	end
	
	function inst:ScaleTo(from, to, time, fn)
--		print ("scaleto")
	end

	function inst:GetValue(vval)		-- check value
		self:CheckVar()
		local val = vval
		if (not val) or (type(val)~="number") then val = 0 end
		if val > self.vmax then val = self.vmax end
		if val < self.vmin then val = self.vmin end
		return val
	end

	function inst:GetReverseValue(val)	-- returns reverse value (for DrawBar using)
		self:CheckVar()
		return self.vmax - self:GetValue(val) + self.vmin
	end

	function inst:GetValueFromPercent(ppercent)
		self:CheckVar()
		local percent = ppercent
		if (not percent) or (type(val)~="number") then percent = 0 end
		if percent > 1 then percent = 1 end
		if percent < 0 then percent = 0 end
		return percent * ( self.vmax - self.vmin)
	end

	function inst:GetBX() return self.wd.bsx * barsize /2 + indicator * 0.6 + self.wd.wd end
	function inst:GetBY() return -4 * self.wd.ws end
	function inst:GetFX(p) return - (1 - p) * barsize / 2 end
	function inst:GetFY(p) return 0 end

	function inst:GetP(val) 
		self:CheckVar()
-- for some reason this is not work as expected, sometimes division by 1000 gives huge period, 
-- so instead of limiting digits in float part, we will compare two float numbers in other way (cmp func from craputil)
--		local p = math.floor((self:GetValue(val) - self.vmin)/(self.vmax - self.vmin)*self.prec)/self.prec

		local p = (self:GetValue(val) - self.vmin)/(self.vmax - self.vmin)
		if p > 1 then p = 1 end
		if p < 0 then p = 0 end
		return p
	end

	function inst:SetBGTint(cc)
		if self.bg then
			local c = cc
			if (not c) or (type(c)~="string") then c = "w" end
			self.bg:SetTint(self.wc[c][1],self.wc[c][2],self.wc[c][3],1)
		end
	end

	function inst:SetFGTint(cc)
		if self.fg then
			local c = cc
			if (not c) or (type(c)~="string") then c = "g" end
			self.fg:SetTint(self.wc[c][1],self.wc[c][2],self.wc[c][3],1)
		end
	end

	function inst:SetNumValue(val)
		self:CheckVar()
		if self.num then
			if self.hidemax then
				self.num:SetString(tostring(math.floor(self:GetValue(val)+0.5)))
			else
				self.num:SetString(tostring(math.floor(self:GetValue(val)+0.5))..self.unitstr..delimer..tostring(math.floor(self.vmax+0.5))..self.unitstr)
			end
		end
	end

	function inst:IsSame(percent)
		self:CheckVar()
--		print("op:"..tostring(self.oldpercent)..", p="..tostring(percent).." result = "..tostring(cmp(self.oldpercent,percent)))
		return cmp(self.oldpercent,percent)
	end

	function inst:DrawBar(val)
		local p = self:GetP(val)
		if self:IsSame(p) then return else self.oldpercent = p end -- reducing number of useless updates, probably gives some perfomance.
		if self.debugme then
			print("inst="..tostring(self)..", v="..tostring(val)..", rv="..tostring(self:GetReverseValue(val)).." ,p="..tostring(p)..", op="..tostring(self.oldpercent))
			print("dmax = "..tostring(self.dmax)..", dmin = "..tostring(self.dmin))
		end
		if self.fg then 
			self.fg:SetPosition(self:GetFX(p),self:GetFY(p),0)
			self.fg:SetScale(p,1,1) 
		end
		if self.bg then
			local c = "w"
			if p < self.dmax then c = "y"  end
			if p < self.dmin then c = "r" end
			self:SetBGTint(c)
		end
	end

	function inst:DrawValue(val)
		local p = self:GetP(val)
		if self:IsSame(p) then return end
		self:DrawBar(val)
		self:SetNumValue(val)
	end

	function inst:DrawTempValue(val)
		local p = self:GetP(val)
		if self:IsSame(p) then return end
		self:DrawTemp(val)
		self:SetNumValue(val)
	end

	function inst:DrawReverseValue(val)
		local p = self:GetP(val)
		if self:IsSame(p) then return end
		self:DrawBar(self:GetReverseValue(val))
		self:SetNumValue(val)
	end

	function inst:DrawReverseTempValue(val)
		local p = self:GetP(val)
		if self:IsSame(p) then return end
		self:DrawTemp(self:GetReverseValue(val))
		self:SetNumValue(val)
	end

	function inst:DrawTemp(vval)
		local c = ""
		val = math.floor(vval)
		local p = self:GetP(val)
		if self:IsSame(p) then return else self.oldpercent = p end -- reducing number of useless updates, probably gives some perfomance.
		if inst.fg then 
			self.fg:SetPosition(self:GetFX(p),self:GetFY(p),0)
			self.fg:SetScale(p,1,1) 
			if p > self.dmax then  c = "r" else c = "g" end
			self:SetFGTint(c)
		end
		if inst.bg then
			if p < self.dmin then c = "b" else c = "w" end
			self:SetBGTint(c)
		end
		self:SetNumValue(val)
	end	
	
	function inst:SetWData(data)
		if not (data and (type(data)=="table")) then
			print ("SetWData : invalid data - "..tostring(data))
			return
		end
		self.wd = deepcopy(data)
--		PrintArray(self.wd,"wd")
	end

	function inst:SetDefaultData()
		print ("SetDefaultData : something wrong here if this was called")
		self.wd = {}
		self.wd["wx"] 	= - math.ceil((256 * 0.7 / 2 + 80 ) * 0.8 / 8) * 8
		self.wd["wy"] 	= math.ceil(10 * 0.8 / 8) * 8
		self.wd["wd"] 	= 0
		self.wd["ws"] 	= 0.8
		self.wd["bsx"] 	= 0.9 * 0.7
		self.wd["bsy"] 	= 0.7
		self.wd["fsx"] 	= self.wd.bsx + 0.08
		self.wd["fsy"] 	= self.wd.bsy + 0.35
	end

	function inst:SetDefaultColor()
		print ("SetDefaultColor : something wrong here if this was called")
		local c = {}
		c["g"] 	= "42531E"
		c["y"] 	= "D07921"
		c["r"] 	= "9f2d26"
		c["b"] 	= "4A536B"
		c["w"] 	= "B59A6B"
		for key,v in pairs(c) do
			self.wc[key] = {}
			for i = 1,3,1 do self.wc[key][i] = GetRGBColor(v,i) end
		end
		self:ReDraw()
	end

	function inst:SetWColor(pal) 
		if not (pal and (type(pal)=="string") and spcolor and spcolor[pal] and (type(spcolor[pal])=="table")) then
			if pal then print ("SetWColor : invalid pal - "..tostring(pal)) end
			self:SetDefaultColor()
			return
		end
		self.wc = {}
		for key,v in pairs(spcolor[pal]) do
			self.wc[key] = {}
			for i = 1,3,1 do self.wc[key][i] = GetRGBColor(v,i) end
		end
		self:ReDraw()
	end

	function inst:ApplyData()
		if (not self.wd) or (type(self.wd)~="table") then self:SetDefaultData() end  -- something is wrong ...
		self:SetPosition(self.wd.wx,self.wd.wy,0)
		self:SetScale(self.wd.ws,self.wd.ws,self.wd.ws)

		self:CheckBars()

		if self.bar then
			self.bar:SetScale(self.wd.fsx,self.wd.fsy,1)
   			self.bar:SetPosition(self:GetBX()-1,0,0)
		end

 		if self.bg then
			self.bg:SetScale(self.wd.bsx,self.wd.bsy,1)
 			self.bg:SetPosition(self:GetBX(),self:GetBY(),0)
 		end

		if self.fg then
			self.fg:SetScale(1,1,1)
	   		self.fg:SetPosition(0,0,0)
		end
		
		if self.num then self.num:SetPosition(self:GetBX(),self:GetBY(),0) end
	end
	
	function inst:GetWCol()
		local p = GetPlayer()
		if p and p.components and p.components.spdata and p.components.spdata.data 
			and p.components.spdata.data.wcol and (type(p.components.spdata.data.wcol)=="number") then
			return p.components.spdata.data.wcol
		else
			return 5
		end
	end

	function inst:GetWID()
		if (not self.wid) or (type(self.wid)~="number") then self.wid = 2 * self:GetWCol() + math.random(1,10) end
		return self.wid
	end

	function inst:GetInitX()
		local dx = - math.ceil((barsize * spo.barscale / 2 + indicator ) * spo.scale / widgetsnap) * widgetsnap
		local cx = math.floor((self:GetWID()-1)/self:GetWCol()) + 1
		dx = dx * cx - (5 + indicator * (cx - 1))
		return dx
	end

	function inst:GetInitY()
		local dy = math.ceil(10 * spo.scale / widgetsnap) * widgetsnap
		local cy = (self:GetWID()-1) % self:GetWCol()
		return dy - cy * indicator * self.wd.ws
	end
	
	function inst:SetInitXY()
		self.wd.wx = self:GetInitX()
		self.wd.wy = self:GetInitY()
	end

	function inst:InitData(wid)
		self.wid = wid
		if not self.wname then self.wname = "unknown" end
		self:SetWData(spdata["default"])
		self:SetWColor("default")
		self:SetInitXY()
		
		self:ApplyData()

		if self.num and self.num.Kill then self.num:Kill() end
		self.num = self:AddChild(Text(NUMBERFONT, 28))
		self.num:SetClickable(false)
		TweakNum(self.num)
		self:CheckNum()
	end

	function inst:CheckBars()  -- checking options for flags and disabling/enabling bars
		local p = GetPlayer()
		if p and p.components and p.components.spdata and p.components.spdata.data then
			self:EnableBar(p.components.spdata.data.enablebar)
			self:EnableBG(p.components.spdata.data.enablebg)
			self:EnableFG(p.components.spdata.data.enablefg)
			self:EnableNum(p.components.spdata.data.enablenum)
		end		
	end

	function inst:CheckNum()
		local p = GetPlayer()
		if p and p.components and p.components.spdata and p.components.spdata.data then
			self:EnableNum(p.components.spdata.data.enablenum)
		end		
	end

	function inst:EnableBar(f)
		if not self.bar then 
			self.bar = self:AddChild(Image(idir.."bar.xml", "bar.tex"))
		end
		if f then
			if self.bar then -- be paranoid, maybe creating failed
				self.bar:SetScale(self.wd.fsx,self.wd.fsy,1)
	   			self.bar:SetPosition(self:GetBX()-1,0,0)
				self.bar:MoveToBack()
				self.bar:Show()
			end
		else
			if self.bar then self.bar:Hide() end
		end
	end

	function inst:EnableBG(f)
		if not self.bg then 
			self.bg  = self:AddChild(Image(idir.."whitebar.xml", "whitebar.tex"))
		end
		if f then
 			if self.bg then
				self.bg:SetScale(self.wd.bsx,self.wd.bsy,1)
 				self.bg:SetPosition(self:GetBX(),self:GetBY(),0)
				self.bg:Show()
 			end
		else
			if self.bg then self.bg:Hide() end
		end
	end

	function inst:EnableFG(f)
		if not self.fg and self.bg then 
			self.fg = self.bg:AddChild(Image(idir.."whitebar.xml", "whitebar.tex"))
		end
		if f then
			if self.fg then
				self.fg:SetScale(1,1,1)
		   		self.fg:SetPosition(0,0,0)
				self:SetFGTint("g")
				self:ReDraw()
				self.fg:Show()
			end
		else
			if self.fg then self.fg:Hide() end
		end
	end

	function inst:EnableNum(f)
		if f and self.num then 
			self.num:Show() 
			self.num:MoveToFront() 
		end
		if not f and self.num then 
			if self.num.DoHide then self.num:DoHide() else self.num:Hide() end
		end
	end


	function inst:SetAnimValue(val)
		if self.anim then
			self.anim:GetAnimState():SetPercent("anim", 1 - self:GetP(val))
		end
	end

	function inst:SetPercent(val, max, penaltypercent)
		self:CheckVar()
		val = val or self.percent
		self.percent = val
		if max and (type(max) == "number") then self.vmax = max end
		val = self:GetValueFromPercent(self.percent)
		if self:IsSame(self.percent) then return else self.oldpercent = p end -- reducing number of useless updates, probably gives some perfomance.
		if self.anim then
			self.anim:GetAnimState():SetPercent("anim", 1 - self.percent)
		end
		self:SetNumValue(val)
		self:DrawBar(val)
		if self.topperanim then
			penaltypercent = penaltypercent or 0
			self.topperanim:GetAnimState():SetPercent("anim", penaltypercent)
		end
	end

	function inst:Hide() end
	function inst:Deactivate() end

	function inst:DoHide() if self.OldHide then self:OldHide() end end
	function inst:DoDeactivate() if self.OldDeactivate then self:OldDeactivate() end end

	function inst:OnLoseFocus() end
	function inst:OnGainFocus() end

	function inst:CustomFollowMouse()
		if self.followhandler then
			self.followhandler:Remove()
			self.followhandler = nil
			local p = GetPlayer()
			if p and p.components and p.components.spdata and self.wname and p.components.spdata.data[self.wname] then
				local l = self:GetLocalPosition()
				p.components.spdata.data[self.wname].wx = l.x
				p.components.spdata.data[self.wname].wy = l.y
--				p.components.spdata:Status()
			end
		else
        		self.followhandler = TheInput:AddMoveHandler(function(x,y) self:DeltaPosition(x,y) end)
		end
	end

	function inst:DeltaPosition(x, y)
		local delta = self:GetLocalPosition() - self:GetWorldPosition()
		x = math.ceil((x + delta.x)/widgetsnap)*widgetsnap
		y = math.ceil((y + delta.y)/widgetsnap)*widgetsnap
		self:SetPosition(x,y,0)
	end

	function inst:ShowOptions()
		ShowOptionsMenu()
	end

	function inst:OnMouseButton(button, down, x, y)
		if down and (button == MOUSEBUTTON_MIDDLE) then self:CustomFollowMouse() end
		local p = GetPlayer()
		if p and p.components and p.components.spdata and p.components.spdata.data.mouse then
			if down and (button == MOUSEBUTTON_RIGHT) then self:ShowOptions() end
		end
	end

	function inst:ReDraw(v,m)
		self.vmax = m
		local p = self:GetP(v)
		self.oldpercent = -1000
		if v and m then self:SetPercent(p,m) end
	end

	function inst:ShowWidget(enable)
		if enable then
			self:Enable()
			self:Show()
		else
			self:DoHide()
			self:Disable()
		end
	end

	function inst:PeriodicDraw()
	end

	function inst:OnUpdate(dt)
		if inst.oldOnUpdate then self:oldOnUpdate(dt) end
		self:PeriodicDraw()
	end

	p=GetPlayer()
	if p then p:DoPeriodicTask(1,function() inst:PeriodicDraw() end, 1.5) end
end

local function TweakWXHeart(inst)
	function inst:SetNumValue(val)
		self:CheckVar()
		local p = GetPlayer()
		local s = ""
		if p and p.components and p.components.spdata and p.components.spdata.data and p.components.spdata.data.wxlevel and
			p.components.spdata.data.wxlevel.data and p.prefab and p.prefab=="wx78" and p.level then 
				s = " lv"..tostring(p.level) 
		end
		self.num:SetString(tostring(math.floor(self:GetValue(val)+0.5))..self.unitstr..delimer..tostring(math.floor(self.vmax)+0.5)..self.unitstr..s)
	end
end

----------------------------------------------------------------------------------------------------------------------------

local function TweakMoisturemeter(inst)
	inst.vmax = math.floor(inst.owner.components.moisture.moistureclamp.max+0.5)
	inst.dmin = 0.5
	inst.dmax = 0.7

	function inst:PeriodicDraw()
		self:DrawBar(self:GetReverseValue(math.floor(self.owner.components.moisture:GetMoisture()+0.5)))
	end
	inst:Activate()
end

local function TweakHealthBadge(inst)
	function inst:PeriodicDraw()
		if not (self.owner or self.owner.components or self.owner.components.health) then return end
		self:SetPercent(self:GetP(self.owner.components.health.currenthealth),self.owner.components.health:GetMaxHealth())
	end
end

local function TweakSanityBadge(inst)
	function inst:PeriodicDraw()
		if not (self.owner or self.owner.components or self.owner.components.sanity) then return end
		self:SetPercent(self:GetP(self.owner.components.sanity.current),self.owner.components.sanity:GetMaxSanity())
	end
end

local function TweakHungerBadge(inst)
	function inst:PeriodicDraw()
		if not (self.owner or self.owner.components or self.owner.components.hunger) then return end
		self:SetPercent(self:GetP(self.owner.components.hunger.current),self.owner.components.hunger.max)
	end
end

local function PlaceIt(inst,name)
	if inst and inst.InitData then 
		curwidget = curwidget + 1
		inst:InitData(curwidget)
		spwidget[name] = inst
		inst.wname = name
	else
		print ("PlaceIt Error : inst = "..tostring(inst)..", name = "..tostring(name))
	end
end	

local BeaverBadge = Class(Badge, function(self, owner)
	Badge._ctor(self, "beaver_meter", owner)
end)

local function TweakBeaverBadge(inst)
	inst.initstarted = true
	TweakBadge(inst)
	local p = GetPlayer()
	inst.dmin = 0
	inst.dmax = 0.8
	if p.components.beaverness then inst.vmax = p.components.beaverness.max end
	function inst:DrawBeaver(val,data)
		inst:DrawTempValue(val)
		inst:SetAnimValue(val)
		if data then
			if not data.overtime then
				if data.newpercent > data.oldpercent then
					inst:PulseGreen()
					TheFrontEnd:GetSound():PlaySound("dontstarve/HUD/health_up")
				elseif data.newpercent < data.oldpercent then
					TheFrontEnd:GetSound():PlaySound("dontstarve/HUD/health_down")
					inst:PulseRed()
				end
			end
		end
	end
	inst:DrawBeaver(0)
	inst.initfinished = true
end

local function TweakStatusDisplays(inst)

	function inst:SetPosition(pos, y, z) -- fix for caves
    		if type(pos) == "number" then
        		if pos >= 0 then self.inst.UITransform:SetPosition(pos,y,z or 0) end
		else
        		if not self.inst:IsValid() then print (debugstack()) end
        		if pos.x >= 0 then self.inst.UITransform:SetPosition(pos.x,pos.y,pos.z) end
		end
	end

	local p = GetPlayer()

	PlaceIt(inst.heart,"health")
	PlaceIt(inst.brain,"sanity")
	PlaceIt(inst.stomach,"hunger")

	inst.temp = inst:AddChild(TempBadge(inst.owner))
	PlaceIt(inst.temp,"temp")

	if p.prefab=="wendy" then
		inst.abigail = inst:AddChild(HPBadge(inst.owner,"abigail","abigail"))
		PlaceIt(inst.abigail,"abigail")
		inst.abigail:SetPercent(0,0)
		inst.abigail:FindTarget("abigail",true)
	else
		inst.abigail = nil
	end

	if p.prefab=="woodie" then
		inst.beaver = inst:AddChild(BeaverBadge(inst.owner))
		TweakBeaverBadge(inst.beaver)
		PlaceIt(inst.beaver,"beaver")
	else
		inst.beaver = nil
	end

	if p.prefab=="wx78" then 
		TweakWXHeart(inst.heart)
		if inst.heart.ReDraw then inst.heart:ReDraw() end
	end

	if IsDLC1 then PlaceIt(inst.moisturemeter,"moistre") end

	--inst.HUD.controls.sidepanel.thirst
	inst.thirst=nil
	if p.components.thirst then
		print ("StatusPlus : changing thirst meter")
		spo.thirst.data = true
		inst.thirst = inst:AddChild(SPThirstBadge(inst.owner))
		PlaceIt(inst.thirst,"thirst") 
	end

	inst.sleep=nil
	if p.components.sleepiness then
		print ("StatusPlus : creating sleepiness meter")
		spo.sleep.data = true
		inst.sleep = inst:AddChild(SPSleepBadge(inst.owner))
		PlaceIt(inst.sleep,"sleep") 
	end

	inst.krampus = inst:AddChild(KrampusBadge(inst.owner))
	PlaceIt(inst.krampus,"krampus")
	inst.krampus:SetPercent(0,TUNING.KRAMPUS_THRESHOLD)

	inst.chester = inst:AddChild(HPBadge(inst.owner,"chester","chester"))
	PlaceIt(inst.chester,"chester")
	inst.chester:SetPercent(0,0)
	inst.chester:FindTarget("chester",true)

	if IsDLC1 then
		inst.glommer = inst:AddChild(HPBadge(inst.owner,"glommer","glommer"))
		PlaceIt(inst.glommer,"glommer")
		inst.glommer:SetPercent(0,0)
		inst.glommer:FindTarget("glommer",true)
	end
end

local function CheckWallFlower()
	p=GetPlayer()
	inst=nil
	if p and p.HUD and p.HUD.controls and p.HUD.controls.status then inst=p.HUD.controls.status end
	if inst and p and p.prefab=="wallflower" then 
		inst.sunshine=nil
            	if p.components.sunshine and inst.children then
			for k,v in pairs(inst.children) do
--				if v then PrintArray(v) print (".....") end
				if v and (type(v.sunshine_charge)=="number") then
					print "StatusPlus: Wallflower mod detected"
					inst.sunshine=v
					TweakBadge(inst.sunshine)
					spo.sunshine.data = true
					inst.sunshine.vmax=p.components.sunshine.sunshineclamp.max
					inst.sunshine.vmin=0
					inst.sunshine.dmin=0
					inst.sunshine.dmax=0
					inst.sunshine.hidemax=true
--					function inst.sunshine:PeriodicDraw()
--						if not (self.owner or self.owner.components or self.owner.components.sunshine) then return end
--						self:SetPercent(self:GetP(self.owner.components.sunshine.sunshine_charge))
--					end

					PlaceIt(inst.sunshine,"sunshine")
					ApplyCustomData("sunshine")
				end
			end
		else
			print ("Wallflower : meter = "..tostring(inst.sunshineMeter)..", component = "..tostring(p.components.sunshine))
		end

		if inst.sunshine and inst.sunshine.ReDraw then inst.sunshine:ReDraw() end
	end
end

local function RestoreCustomData()
	local p = GetPlayer()
	if p and p.components and p.components.spdata then
		local wcol = p.components.spdata.data.wcol
		local keycode = p.components.spdata.data.keycode
		p.components.spdata:SetData(spo) 
		if wcol and (type(wcol)=="number") then p.components.spdata.data.wcol = wcol end
		if keycode and (type(keycode)=="number") then p.components.spdata.data.keycode = keycode end
		local d = deepcopy(spdata["default"])
		for k,v in pairs(spwidget) do
			if p.components.spdata.data[k] then
				p.components.spdata.data[k].wy = spwidget[k]:GetInitY()
				p.components.spdata.data[k].wx = spwidget[k]:GetInitX()
			end
		end
		ApplyCustomData()
	end
end

local function SaveCustomData()
	local p = GetPlayer()
	if p and p.components and p.components.spdata and p.components.spdata.data then
		local s = array2str(p.components.spdata.data)
		if s and (type(s)=="string") and (string.len(s) > 0) then
			print ("StatusPlus : Saving profile data..."..tostring(string.len(s)).." bytes")
			GLOBAL.Profile:SetValue("statusplus",s)
			GLOBAL.Profile:Save()
		else
			print ("Invalid data : "..tostring(s))
		end
	end
end

local function LoadCustomData()
	local p = GetPlayer()
	if p and p.components and p.components.spdata and p.components.spdata.data then
		local s = GLOBAL.Profile:GetValue("statusplus")
		if s and (type(s)=="string") and (string.len(s) > 0) then
			print ("StatusPlus : Loading profile data..."..tostring(string.len(s)).." bytes")
			local a = str2array(s)
			local count = 0
			for _ in pairs(a) do count = count + 1 end
			print ("StatusPlus : "..tostring(count).." records loaded")
			if a and (type(a)=="table") and (count > 0) then
				a.beaver.data = (p.prefab=="woodie")
				a.abigail.data = (p.prefab=="wendy")
				if p.prefab~="wx78" then a.wxlevel.data = false end
				if not IsDLC1 then
					a.moistre.data = false
					a.glommer.data = false
				end
				p.components.spdata:Merge(a) -- profile data can be outdated
				ApplyCustomData()
			end
		end
	end
end

-- from betterconsole by squeek
local function SPAddComponent()
	local character = GLOBAL.SaveGameIndex:GetSlotCharacter()
	TheSim:LoadPrefabs {character}
	local oldfn = GLOBAL.Prefabs[character].fn
	GLOBAL.Prefabs[character].fn = 
		function(...)
			local inst = oldfn(...)
			if (type(character)=="string") and (character=="woodie")then spo.beaver.data = true end
			if (type(character)=="string") and (character=="wendy")then spo.abigail.data = true end
--			if (type(character)=="string") and (character=="wallflower")then spo.sunshine.data = true end
			inst:AddComponent("spdata")
			if inst.components.spdata then
				inst.components.spdata:SetData(spo)
				inst.components.spdata:SetApplyFunc(ApplyCustomData)
				inst.components.spdata:SetRestoreFunc(RestoreCustomData)
				inst.components.spdata:SetLoadFunc(LoadCustomData)
				inst.components.spdata:SetSaveFunc(SaveCustomData)
			end
			return inst
		end
end

local function TweakKramped(Kramped,inst)
	inst:ListenForEvent("killed", function(inst,data) Kramped:SPReport() end)
end

local function BeavernessStatus(Health,inst)
	inst:ListenForEvent("beavernessdelta", function(inst, data) 
			-- btw in theory this event can be called by NPC, but widget will ignore spam of nonchanged values from player, so no problem here
			local p = GetPlayer()
			if (p.prefab~="woodie") then return end
			if p and p.HUD and p.HUD.controls and p.HUD.controls.status and p.HUD.controls.status.beaver and p.HUD.controls.status.beaver.initfinished then
				p.HUD.controls.status.beaver:DrawBeaver(p.components.beaverness.current,data)
			end
			if p and p.HUD and p.HUD.controls and p.HUD.controls.beaverbadge and p.HUD.controls.beaverbadge:IsEnabled() then
				p.HUD.controls.beaverbadge:Disable()
				p.HUD.controls.beaverbadge:Hide()
				p.HUD.controls.status:Show()
			end
		end )
end

local function SPostInit(inst)
	if inst and inst.components and inst.components.spdata then
		print ("StatusPlus : Loading data...") 
		if not inst.components.spdata.done then
			print ("StatusPlus : data not loaded...") 
			inst:DoTaskInTime(0.2, function() ApplyCustomData() end)
		else
			ApplyCustomData()
		end
		inst:DoTaskInTime(0.3, function() CheckWallFlower() end)
        else 
		print ("StatusPlus : spdata component failed")
	end
end

----------------------------------------------------------------------------------------------------------------------------

AddClassPostConstruct("widgets/sanitybadge", TweakBadge)
AddClassPostConstruct("widgets/sanitybadge", TweakSanityBadge)
AddClassPostConstruct("widgets/healthbadge", TweakBadge)
AddClassPostConstruct("widgets/healthbadge", TweakHealthBadge)
AddClassPostConstruct("widgets/hungerbadge", TweakBadge)
AddClassPostConstruct("widgets/hungerbadge", TweakHungerBadge)
AddClassPostConstruct("widgets/spthirstbadge", TweakBadge)
AddClassPostConstruct("widgets/spsleepbadge", TweakBadge)
if IsDLC1 then
	AddClassPostConstruct("widgets/moisturemeter", TweakBadge)
	AddClassPostConstruct("widgets/moisturemeter", TweakMoisturemeter)
end
AddClassPostConstruct("widgets/tempbadge",   TweakBadge)
AddClassPostConstruct("widgets/krampusbadge",   TweakBadge)
AddClassPostConstruct("widgets/hpbadge",   TweakBadge)
AddClassPostConstruct("widgets/statusdisplays", TweakStatusDisplays)
AddComponentPostInit("kramped",TweakKramped)
AddComponentPostInit("beaverness",BeavernessStatus)
AddPrefabPostInit("world", SPAddComponent)
AddSimPostInit(SPostInit)
