
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/ryuko.zip" ),
}
local prefabs = {}

local start_inv = {
        "redblade",
}

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wallace"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "ryuko.tex" )

	-- todo: Add an example special power here.
	inst.components.health:SetMaxHealth(175)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(100)
	inst.components.combat.damagemultiplier = 1
    inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.15)
    inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2)
    inst.components.combat:SetAttackPeriod(TUNING.WILSON_ATTACK_PERIOD * 1.6)
    

end
STRINGS.CHARACTER_TITLES.ryuko = "The Drifter"
STRINGS.CHARACTER_NAMES.ryuko = "Ryuko"  -- Note! This line is especially important as some parts of the game require
                                            -- the character to have a valid name.

STRINGS.CHARACTER_DESCRIPTIONS.ryuko = "*Has a red Scissor Blade\n*Talks to her clothes\n*Good at fighting, but gets tired easily"
STRINGS.CHARACTER_QUOTES.ryuko = "\"Nonsensical is our thing!\""

STRINGS.CHARACTERS.RYUKO = require "speech_ryuko"

return MakePlayerCharacter("ryuko", prefabs, assets, fn, start_inv)
