local assets =
{
    Asset("ANIM", "anim/redblade.zip"),
   	Asset("ANIM", "anim/swap_redblade.zip"),
	Asset("ATLAS", "images/inventoryimages/redblade.xml")
}

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_redblade", "swap_nightmaresword")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function fn(Sim)
  local inst = CreateEntity()
	 local trans = inst.entity:AddTransform()
	 local anim = inst.entity:AddAnimState()
	 MakeInventoryPhysics(inst)
	 
	 anim:SetBank("nightmaresword")
	 anim:SetBuild("redblade")
	 anim:PlayAnimation("idle")
	 
  inst:AddTag("sharp")
    
  inst:AddComponent("weapon")
  inst.components.weapon:SetDamage(TUNING.SPEAR_DAMAGE * 2.0)
  inst.components.weapon:SetRange(2.8, 2.5)

	inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.CHOP)
    
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/redblade.xml"
    
  inst:AddComponent("inspectable")
   	
  inst:AddTag("irreplaceable")
    
  inst:AddComponent("equippable")
  inst.components.equippable:SetOnEquip( onequip )
  inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
	 
end

return Prefab("common/inventory/redblade", fn, assets)
