local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset("ANIM", "anim/wilson.zip"),
	Asset("ANIM", "anim/beard.zip"),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
        Asset( "ANIM", "anim/sgn.zip" ),
		Asset( "ANIM", "anim/suf.zip"), 
}

local prefabs = 
{
    "beardhair",
}

local fn = function(inst)

    inst:AddComponent("beard")
    inst.components.beard.onreset = function()
        inst.AnimState:ClearOverrideSymbol("beard")
    end
    inst.components.beard.prize = "beardhair"
    
    --tune the beard economy...
	local beard_days = {4, 8, 16}
	local beard_bits = {1, 3,  9}
    
    inst.components.beard:AddCallback(beard_days[1], function()
        inst.AnimState:OverrideSymbol("beard", "beard", "beard_short")
        inst.components.beard.bits = beard_bits[1]
    end)
    
    inst.components.beard:AddCallback(beard_days[2], function()
        inst.AnimState:OverrideSymbol("beard", "beard", "beard_medium")
        inst.components.beard.bits = beard_bits[2]
    end)
    
    inst.components.beard:AddCallback(beard_days[3], function()
        inst.AnimState:OverrideSymbol("beard", "beard", "beard_long")
        inst.components.beard.bits = beard_bits[3]
    end) 

	inst.soundsname = "wilson"

	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "wilson.png" )

	--Stats
	inst.components.health:SetMaxHealth(TUNING.WILSON_HEALTH)
	inst.components.hunger:SetMax(TUNING.WILSON_HUNGER)
	inst.components.sanity:SetMax(TUNING.WILSON_SANITY)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED)
       
	
	--Vast Expletive Mode
	inst:ListenForEvent("sanitydelta", function(inst, data)
        if data.newpercent >= .30 then
        inst.AnimState:SetBuild("sgn")
        inst.components.combat.damagemultiplier = (TUNING.WILSON_DAMAGE)
        inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED)
        inst.components.health:StopRegen()
        inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
        inst.components.eater.monsterimmune = false
        inst.entity:AddLight()
	inst.Light:Enable(false)
	inst.Light:SetRadius(13)
	inst.Light:SetFalloff(.5)
	inst.Light:SetIntensity(.8)
	inst.Light:SetColour(75/255,120/255,240/255)
        else
	inst.AnimState:SetBuild("suf")
        inst.components.combat.damagemultiplier = 1.7
   	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.6)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.6)
        inst.components.health:StartRegen(1, 15)
        inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 2)
        inst.components.eater.monsterimmune = true
        inst.entity:AddLight()
	inst.Light:Enable(true)
	inst.Light:SetRadius(13)
	inst.Light:SetFalloff(.5)
	inst.Light:SetIntensity(.8)
	inst.Light:SetColour(75/255,120/255,240/255)
        end
    end)
end

local start_inv =
{

}

return MakePlayerCharacter("sgn", prefabs, assets, fn, start_inv)
