--[[
*********************************************************************************************************
Original coding created by: DMCartz
Massively rewritten by: phixius83
Date: 12/17/15
Description: Tweak the durability for weapons, armor, staffs, amulets, tools, traps, clothing and lights.
File: fueled.lua
Modded Section(s):Header, DoDelta
*********************************************************************************************************
]]

--[[MODNOTE: Mod Variable Declaration ]]--
local foldername = KnownModIndex:GetModActualName("Tweak Those Tools, Tweaked!")
local WEAPON_DURABILITY = GetModConfigData("WEAPON_DURABILITY", foldername)
local STAFF_DURABILITY = GetModConfigData("STAFF_DURABILITY", foldername)
local AMULET_DURABILITY = GetModConfigData("AMULET_DURABILITY", foldername)
local TOOL_DURABILITY = GetModConfigData("TOOL_DURABILITY", foldername)
local GOLD_DURABILITY = GetModConfigData("GOLD_DURABILITY", foldername)
local TRAP_DURABILITY = GetModConfigData("TRAP_DURABILITY", foldername)
local ARMOR_DURABILITY = GetModConfigData("ARMOR_DURABILITY", foldername)
local CLOTHING_DURABILITY = GetModConfigData("CLOTHING_DURABILITY", foldername)
local LIGHT_DURABILITY = GetModConfigData("LIGHT_DURABILITY", foldername)
local CAMPING_DURABILITY = GetModConfigData("CAMPING_DURABILITY", foldername)
local BOOK_DURABILITY = GetModConfigData("BOOK_DURABILITY", foldername)
local FOOD_PRESERVATION = GetModConfigData("FOOD_PRESERVATION", foldername)
local FOOD_SELECTION = GetModConfigData("FOOD_SELECTION", foldername)
local BOAT_DURABILITY = GetModConfigData("BOAT_DURABILITY", foldername)
local DEBUGOPTIONS = GetModConfigData("DEBUGOPTIONS", foldername)
local SWDLC = ""
local ROGDLC = ""

if IsDLCEnabled(CAPY_DLC) then
	SWDLC = true
else
	SWDLC = false
end

if IsDLCEnabled(REIGN_OF_GIANTS) then
	ROGDLC = true
else
	ROGDLC = false
end

--[[MODNOTE: End Mod Variables ]]--

--[[MODNOTE: Mod Debug Function ]]--
local function ModDeBug(inst,currentfuel,maxfuel)
	local DebugTag = "N/A"
	local DebugDura = "N/A"
	if DEBUGOPTIONS ~= "Off" then
		if DEBUGOPTIONS == "Weapon" then
			DebugTag = "TweakWeapon"
			DebugDura = WEAPON_DURABILITY
		elseif DEBUGOPTIONS == "Staff" then
			DebugTag = "TweakStaff"
			DebugDura = STAFF_DURABILITY
		elseif DEBUGOPTIONS == "Amulet" then
			DebugTag = "TweakAmulet"
			DebugDura = AMULET_DURABILITY
		elseif DEBUGOPTIONS == "Tool" then
			DebugTag = "TweakTool"
			DebugDura = TOOL_DURABILITY
		elseif DEBUGOPTIONS == "GoldTool" then
			DebugTag = "TweakGold"
			DebugDura = GOLD_DURABILITY
		elseif DEBUGOPTIONS == "Trap" then
			DebugTag = "TweakTrap"
			DebugDura = TRAP_DURABILITY
		elseif DEBUGOPTIONS == "Armor" then
			DebugTag = "TweakArmor"
			DebugDura = ARMOR_DURABILITY
		elseif DEBUGOPTIONS == "Clothing" then
			DebugTag = "TweakClothes"
			DebugDura = CLOTHING_DURABILITY
		elseif DEBUGOPTIONS == "Light" then
			DebugTag = "TweakLight"
			DebugDura = LIGHT_DURABILITY
		elseif DEBUGOPTIONS == "Camping" then
			DebugTag = "TweakCamping"
			DebugDura = CAMPING_DURABILITY
		elseif DEBUGOPTIONS == "Book" then
			DebugTag = "TweakBook"
			DebugDura = BOOK_DURABILITY
		elseif DEBUGOPTIONS == "Food" then
			if FOOD_SELECTION == "Preserved" then 
				DebugTag = "TweakJerky"
			else
				DebugTag = "TweakFood"
			end
			DebugDura = FOOD_PRESERVATION
		elseif DEBUGOPTIONS == "Boat" then
			DebugTag = "TweakBoat"
			DebugDura = BOAT_DURABILITY
		end
	end

	if inst:HasTag(DebugTag) then
		print(inst.name.. " - Tweaked. Durability: " .. DebugDura .. ". " .. currentfuel .. "/" .. maxfuel .. " before extinguish.")
	end
end

--[[MODNOTE: End Mod Debug Function ]]--
local Fueled = ""

if SWDLC == true then
	Fueled = Class(function(self, inst)
		self.inst = inst
		self.consuming = false
    
		self.maxfuel = 0
		self.currentfuel = 0
		self.rate = 1
    
		self.accepting = false
		self.fueltype = "BURNABLE"
		self.secondaryfueltype = nil
		self.sections = 1
		self.sectionfn = nil
		self.period = 1
		self.bonusmult = 1
		self.depleted = nil
		self.depletionmultiplier = 1
	end)
elseif ROGDLC == true then
	Fueled = Class(function(self, inst)
		self.inst = inst
		self.consuming = false
    
		self.maxfuel = 0
		self.currentfuel = 0
		self.rate = 1
    
		self.accepting = false
		self.fueltype = "BURNABLE"
		self.secondaryfueltype = nil
		self.sections = 1
		self.sectionfn = nil
		self.period = 1
		self.bonusmult = 1
		self.depleted = nil
	end)
else
	Fueled = Class(function(self, inst)
		self.inst = inst
		self.consuming = false
    
		self.maxfuel = 0
		self.currentfuel = 0
		self.rate = 1
    
		self.accepting = false
		self.fueltype = "BURNABLE"
		self.sections = 1
		self.sectionfn = nil
		self.period = 1
		self.bonusmult = 1
		self.depleted = nil
	end)
end


function Fueled:MakeEmpty()
	if self.currentfuel > 0 then
		self:DoDelta(-self.currentfuel)
	end
end

function Fueled:OnSave()
    if self.currentfuel ~= self.maxfuel then
        return {fuel = self.currentfuel}
    end
end

function Fueled:OnLoad(data)
    if data.fuel then
        self:InitializeFuelLevel(data.fuel)
    end
end

function Fueled:SetSectionCallback(fn)
    self.sectionfn = fn
end

function Fueled:SetDepletedFn(fn)
    self.depleted = fn
end

function Fueled:IsEmpty()
    return self.currentfuel <= 0
end

function Fueled:SetSections(num)
    self.sections = num
end

if SWDLC == true or ROGDLC == true then
	function Fueled:CanAcceptFuelItem(item)
		return self.accepting and item and item.components.fuel and (item.components.fuel.fueltype == self.fueltype or item.components.fuel.fueltype == self.secondaryfueltype)
	end
else
	function Fueled:CanAcceptFuelItem(item)
		return self.accepting and item and item.components.fuel and item.components.fuel.fueltype == self.fueltype
	end
end

function Fueled:GetCurrentSection()
    if self:IsEmpty() then
        return 0
    else
        return math.min( math.floor(self:GetPercent()* self.sections)+1, self.sections)
    end
end

function Fueled:ChangeSection(amount)
    local fuelPerSection = self.maxfuel / self.sections
    self:DoDelta((amount * fuelPerSection)-1)
end

if SWDLC == true or ROGDLC == true then
	function Fueled:TakeFuelItem(item)
	    if self:CanAcceptFuelItem(item) then
			local oldsection = self:GetCurrentSection()
    
			-- self.currentfuel = self.currentfuel + (item.components.fuel.fuelvalue * self.bonusmult)
			-- if self.currentfuel > self.maxfuel then
			--     self.currentfuel = self.maxfuel
			-- end

			local moisturemgr = GetWorld().components.moisturemanager
			local fuelamt = item.components.fuel.fuelvalue * self.bonusmult
			if moisturemgr and not moisturemgr:IsEntityDry(item) then
				fuelamt = fuelamt * TUNING.WET_FUEL_PENALTY
			end
			self:DoDelta(fuelamt)

			if item.components.fuel then
				item.components.fuel:Taken(self.inst)
			end
			item:Remove()
        
			if self.sections > 1 and self.sectionfn then
        
				local newsection = self:GetCurrentSection()
				if oldsection ~= newsection then
					self.sectionfn(newsection,oldsection, self.inst)
				end
            
			end
        
			if self.ontakefuelfn then
				self.ontakefuelfn(self.inst)
			end
        
			return true
		end
    end
else
	function Fueled:TakeFuelItem(item)
		if self:CanAcceptFuelItem(item) then
			local oldsection = self:GetCurrentSection()
    
			-- self.currentfuel = self.currentfuel + (item.components.fuel.fuelvalue * self.bonusmult)
			-- if self.currentfuel > self.maxfuel then
			--     self.currentfuel = self.maxfuel
			-- end

			self:DoDelta(item.components.fuel.fuelvalue * self.bonusmult)

			if item.components.fuel then
				item.components.fuel:Taken(self.inst)
			end
			item:Remove()
        
			if self.sections > 1 and self.sectionfn then
				local newsection = self:GetCurrentSection()
				if oldsection ~= newsection then
					self.sectionfn(newsection,oldsection)
				end
			end
        
			if self.ontakefuelfn then
				self.ontakefuelfn(self.inst)
			end
        
			return true
		end
	end
end


function Fueled:SetUpdateFn(fn)
    self.updatefn = fn
end

function Fueled:GetDebugString()

    local section = self:GetCurrentSection()
    
    return string.format("%s %2.2f/%2.2f (-%2.2f) : section %d/%d %2.2f", self.consuming and "ON" or "OFF", self.currentfuel, self.maxfuel, self.rate, section, self.sections, self:GetSectionPercent())
end

function Fueled:AddThreshold(percent, fn)
    table.insert(self.thresholds, {percent=percent, fn=fn})
    --table.sort(self.thresholds, function(l,r) return l.percent < r.percent)
end

function Fueled:GetSectionPercent()
    local section = self:GetCurrentSection()
    return (self:GetPercent() - (section - 1)/self.sections) / (1/self.sections)
end


function Fueled:GetPercent()
    if self.maxfuel > 0 then 
        return math.min(1, self.currentfuel / self.maxfuel)
    else
        return 0
    end
end

function Fueled:SetPercent(amount)
    local target = (self.maxfuel * amount)
    self:DoDelta(target - self.currentfuel)
end

function Fueled:StartConsuming()
    self.consuming = true
    if self.task == nil then
        self.task = self.inst:DoPeriodicTask(self.period, function() self:DoUpdate(self.period) end)
    end
end

if SWDLC == true or ROGDLC == true then
	function Fueled:InitializeFuelLevel(fuel)
		local oldsection = self:GetCurrentSection()
		if self.maxfuel < fuel then
			self.maxfuel = fuel
		end
		self.currentfuel = fuel
    
		local newsection = self:GetCurrentSection()
		if oldsection ~= newsection and self.sectionfn then
			self.sectionfn(newsection, oldsection, self.inst)
		end
	end
else
	function Fueled:InitializeFuelLevel(fuel)
    local oldsection = self:GetCurrentSection()
    if self.maxfuel < fuel then
        self.maxfuel = fuel
    end
    self.currentfuel = fuel
    
    local newsection = self:GetCurrentSection()
    if oldsection ~= newsection and self.sectionfn then
        self.sectionfn(newsection,oldsection)
    end
	end
end


if SWDLC == true then
	function Fueled:DoDelta(amount)
		local oldsection = self:GetCurrentSection()
    
		amount = amount * self.depletionmultiplier
		
		--[[MODNOTE: This section deals with the update math, which is where tweak will be applied]]--
		--[[self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )]]--  Original Text for this section
	
		--[[Get the tags for the item currently being processed, and change our variable to match]]--
		local DURABILITYSETTING = "Default"
			
		if self.inst:HasTag("TweakClothes") then
			DURABILITYSETTING = CLOTHING_DURABILITY
		elseif self.inst:HasTag("TweakWeapon") then
			DURABILITYSETTING = WEAPON_DURABILITY
		elseif self.inst:HasTag("TweakStaff") then
			DURABILITYSETTING = STAFF_DURABILITY
		elseif self.inst:HasTag("TweakAmulet") then
			DURABILITYSETTING = AMULET_DURABILITY
		elseif self.inst:HasTag("TweakTool") then
			DURABILITYSETTING = TOOL_DURABILITY
		elseif self.inst:HasTag("TweakGold") then
			DURABILITYSETTING = GOLD_DURABILITY
		elseif self.inst:HasTag("TweakTrap") then
			DURABILITYSETTING = TRAP_DURABILITY
		elseif self.inst:HasTag("TweakArmor") then
			DURABILITYSETTING = ARMOR_DURABILITY
		elseif self.inst:HasTag("TweakLight") then
			DURABILITYSETTING = LIGHT_DURABILITY
		elseif self.inst:HasTag("TweakCamping") then
			DURABILITYSETTING = CAMPING_DURABILITY
		elseif self.inst:HasTag("TweakBook") then
			DURABILITYSETTING = BOOK_DURABILITY
		elseif self.inst:HasTag("TweakJerky") then
			DURABILITYSETTING = FOOD_PRESERVATION
		elseif self.inst:HasTag("TweakFood") then
			DURABILITYSETTING = FOOD_PRESERVATION
		elseif self.inst:HasTag("TweakBoat") then
			DURABILITYSETTING = BOAT_DURABILITY
		end
		
		if DURABILITYSETTING ~= "Default" then
			if amount >= 1 then  -- Check to see if we're adding fuel to our item, and thus do not need to tweak the value
				self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )
			else
				if DURABILITYSETTING == "Infinite" then
					if self.currentfuel >= 270 and self.inst:HasTag("TweakPit") then
						self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )
					else
						self.currentfuel = self.currentfuel
					end
				else
					self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + (amount / DURABILITYSETTING)) )
				end
			end
		else
			self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )
		end
	
		ModDeBug(self.inst,self.currentfuel,self.maxfuel)  --[[MODNOTE: Send Debug Message as requested by mod]]--
		--[[MODNOTE: End of Modded Section]]--	
    
		local newsection = self:GetCurrentSection()
    
		if oldsection ~= newsection then
			if self.sectionfn then
				self.sectionfn(newsection,oldsection, self.inst)
			end
			if self.currentfuel <= 0 and self.depleted then
				self.depleted(self.inst)
			end
		end

		self.inst:PushEvent("percentusedchange", {percent = self:GetPercent(), fuel = self.currentfuel})
	end
elseif ROGDLC == true then
	function Fueled:DoDelta(amount)
		local oldsection = self:GetCurrentSection()
		
		--[[MODNOTE: This section deals with the update math, which is where tweak will be applied]]--
		--[[self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )]]--  Original Text for this section
	
		--[[Get the tags for the item currently being processed, and change our variable to match]]--
		local DURABILITYSETTING = "Default"
			
		if self.inst:HasTag("TweakClothes") then
			DURABILITYSETTING = CLOTHING_DURABILITY
		elseif self.inst:HasTag("TweakWeapon") then
			DURABILITYSETTING = WEAPON_DURABILITY
		elseif self.inst:HasTag("TweakStaff") then
			DURABILITYSETTING = STAFF_DURABILITY
		elseif self.inst:HasTag("TweakAmulet") then
			DURABILITYSETTING = AMULET_DURABILITY
		elseif self.inst:HasTag("TweakTool") then
			DURABILITYSETTING = TOOL_DURABILITY
		elseif self.inst:HasTag("TweakGold") then
			DURABILITYSETTING = GOLD_DURABILITY
		elseif self.inst:HasTag("TweakTrap") then
			DURABILITYSETTING = TRAP_DURABILITY
		elseif self.inst:HasTag("TweakArmor") then
			DURABILITYSETTING = ARMOR_DURABILITY
		elseif self.inst:HasTag("TweakLight") then
			DURABILITYSETTING = LIGHT_DURABILITY
		elseif self.inst:HasTag("TweakCamping") then
			DURABILITYSETTING = CAMPING_DURABILITY
		elseif self.inst:HasTag("TweakBook") then
			DURABILITYSETTING = BOOK_DURABILITY
		elseif self.inst:HasTag("TweakJerky") then
			DURABILITYSETTING = FOOD_PRESERVATION
		elseif self.inst:HasTag("TweakFood") then
			DURABILITYSETTING = FOOD_PRESERVATION
		elseif self.inst:HasTag("TweakBoat") then
			DURABILITYSETTING = BOAT_DURABILITY
		end
		
		if DURABILITYSETTING ~= "Default" then
			if amount >= 1 then  -- Check to see if we're adding fuel to our item, and thus do not need to tweak the value
				self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )
			else
				if DURABILITYSETTING == "Infinite" then
					if self.currentfuel >= 270 and self.inst:HasTag("TweakPit") then
						self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )
					else
						self.currentfuel = self.currentfuel
					end
				else
					self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + (amount / DURABILITYSETTING)) )
				end
			end
		else
			self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )
		end
	
		ModDeBug(self.inst,self.currentfuel,self.maxfuel)  --[[MODNOTE: Send Debug Message as requested by mod]]--
		--[[MODNOTE: End of Modded Section]]--		
    
		local newsection = self:GetCurrentSection()
    
		if oldsection ~= newsection then
			if self.sectionfn then
				self.sectionfn(newsection,oldsection, self.inst)
			end
			if self.currentfuel <= 0 and self.depleted then
				self.depleted(self.inst)
			end
		end
    
		self.inst:PushEvent("percentusedchange", {percent = self:GetPercent()})    
	end
else
	function Fueled:DoDelta(amount)
		local oldsection = self:GetCurrentSection()
    
		--[[MODNOTE: This section deals with the update math, which is where tweak will be applied]]--
		--[[self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )]]--  Original Text for this section
	
		--[[Get the tags for the item currently being processed, and change our variable to match]]--
		local DURABILITYSETTING = "Default"
			
		if self.inst:HasTag("TweakClothes") then
			DURABILITYSETTING = CLOTHING_DURABILITY
		elseif self.inst:HasTag("TweakWeapon") then
			DURABILITYSETTING = WEAPON_DURABILITY
		elseif self.inst:HasTag("TweakStaff") then
			DURABILITYSETTING = STAFF_DURABILITY
		elseif self.inst:HasTag("TweakAmulet") then
			DURABILITYSETTING = AMULET_DURABILITY
		elseif self.inst:HasTag("TweakTool") then
			DURABILITYSETTING = TOOL_DURABILITY
		elseif self.inst:HasTag("TweakGold") then
			DURABILITYSETTING = GOLD_DURABILITY
		elseif self.inst:HasTag("TweakTrap") then
			DURABILITYSETTING = TRAP_DURABILITY
		elseif self.inst:HasTag("TweakArmor") then
			DURABILITYSETTING = ARMOR_DURABILITY
		elseif self.inst:HasTag("TweakLight") then
			DURABILITYSETTING = LIGHT_DURABILITY
		elseif self.inst:HasTag("TweakCamping") then
			DURABILITYSETTING = CAMPING_DURABILITY
		elseif self.inst:HasTag("TweakBook") then
			DURABILITYSETTING = BOOK_DURABILITY
		elseif self.inst:HasTag("TweakJerky") then
			DURABILITYSETTING = FOOD_PRESERVATION
		elseif self.inst:HasTag("TweakFood") then
			DURABILITYSETTING = FOOD_PRESERVATION
		elseif self.inst:HasTag("TweakBoat") then
			DURABILITYSETTING = BOAT_DURABILITY
		end
		
		if DURABILITYSETTING ~= "Default" then
			if amount >= 1 then  -- Check to see if we're adding fuel to our item, and thus do not need to tweak the value
				self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )
			else
				if DURABILITYSETTING == "Infinite" then
					if self.currentfuel >= 270 and self.inst:HasTag("TweakPit") then
						self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )
					else
						self.currentfuel = self.currentfuel
					end
				else
					self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + (amount / DURABILITYSETTING)) )
				end
			end
		else
			self.currentfuel = math.max(0, math.min(self.maxfuel, self.currentfuel + amount) )
		end
	
		ModDeBug(self.inst,self.currentfuel,self.maxfuel)  --[[MODNOTE: Send Debug Message as requested by mod]]--
		--[[MODNOTE: End of Modded Section]]--
    
		local newsection = self:GetCurrentSection()
    
		if oldsection ~= newsection then
			if self.sectionfn then
				self.sectionfn(newsection,oldsection)
			end
			if self.currentfuel <= 0 and self.depleted then
				self.depleted(self.inst)
			end
		end
    
		self.inst:PushEvent("percentusedchange", {percent = self:GetPercent()})    
	end
end

function Fueled:DoUpdate( dt )
    if self.consuming then
        self:DoDelta(-dt*self.rate)
    end
    
    if self:IsEmpty() then
        self:StopConsuming()
    end
    
    if self.updatefn then
        self.updatefn(self.inst)
    end

end

function Fueled:DoUpdate( dt )
    if self.consuming then
        self:DoDelta(-dt*self.rate)
    end
    
    if self:IsEmpty() then
        self:StopConsuming()
    end
    
    if self.updatefn then
        self.updatefn(self.inst)
    end

end

function Fueled:StopConsuming()
    self.consuming = false
    if self.task then
        self.task:Cancel()
        self.task = nil
    end
end

function Fueled:LongUpdate(dt)
	self:DoUpdate(dt)
end

return Fueled

