--[[
*********************************************************************************************************
Original coding created by: DMCartz
Massively rewritten by: phixius83
Date: 12/17/15
Description: Tweak the durability for weapons, armor, staffs, amulets, tools, traps, clothing and lights.
File: finiteuses.lua
Modded Section(s):Header, Use
*********************************************************************************************************
]]

--[[MODNOTE: Mod Variable Declaration ]]--
local foldername = KnownModIndex:GetModActualName("Tweak Those Tools, Tweaked!")
local WEAPON_DURABILITY = GetModConfigData("WEAPON_DURABILITY", foldername)
local STAFF_DURABILITY = GetModConfigData("STAFF_DURABILITY", foldername)
local AMULET_DURABILITY = GetModConfigData("AMULET_DURABILITY", foldername)
local TOOL_DURABILITY = GetModConfigData("TOOL_DURABILITY", foldername)
local GOLD_DURABILITY = GetModConfigData("GOLD_DURABILITY", foldername)
local TRAP_DURABILITY = GetModConfigData("TRAP_DURABILITY", foldername)
local ARMOR_DURABILITY = GetModConfigData("ARMOR_DURABILITY", foldername)
local CLOTHING_DURABILITY = GetModConfigData("CLOTHING_DURABILITY", foldername)
local LIGHT_DURABILITY = GetModConfigData("LIGHT_DURABILITY", foldername)
local CAMPING_DURABILITY = GetModConfigData("CAMPING_DURABILITY", foldername)
local BOOK_DURABILITY = GetModConfigData("BOOK_DURABILITY", foldername)
local FOOD_PRESERVATION = GetModConfigData("FOOD_PRESERVATION", foldername)
local FOOD_SELECTION = GetModConfigData("FOOD_SELECTION", foldername)
local BOAT_DURABILITY = GetModConfigData("BOAT_DURABILITY", foldername)
local DEBUGOPTIONS = GetModConfigData("DEBUGOPTIONS", foldername)
--[[MODNOTE: End Mod Variables ]]--

--[[MODNOTE: Mod Debug Function ]]--
local function ModDeBug(inst,current)
	local DebugTag = "N/A"
	local DebugDura = "N/A"
	if DEBUGOPTIONS ~= "Off" then
		if DEBUGOPTIONS == "Weapon" then
			DebugTag = "TweakWeapon"
			DebugDura = WEAPON_DURABILITY
		elseif DEBUGOPTIONS == "Staff" then
			DebugTag = "TweakStaff"
			DebugDura = STAFF_DURABILITY
		elseif DEBUGOPTIONS == "Amulet" then
			DebugTag = "TweakAmulet"
			DebugDura = AMULET_DURABILITY
		elseif DEBUGOPTIONS == "Tool" then
			DebugTag = "TweakTool"
			DebugDura = TOOL_DURABILITY
		elseif DEBUGOPTIONS == "GoldTool" then
			DebugTag = "TweakGold"
			DebugDura = GOLD_DURABILITY
		elseif DEBUGOPTIONS == "Trap" then
			DebugTag = "TweakTrap"
			DebugDura = TRAP_DURABILITY
		elseif DEBUGOPTIONS == "Armor" then
			DebugTag = "TweakArmor"
			DebugDura = ARMOR_DURABILITY
		elseif DEBUGOPTIONS == "Clothing" then
			DebugTag = "TweakClothes"
			DebugDura = CLOTHING_DURABILITY
		elseif DEBUGOPTIONS == "Light" then
			DebugTag = "TweakLight"
			DebugDura = LIGHT_DURABILITY
		elseif DEBUGOPTIONS == "Camping" then
			DebugTag = "TweakCamping"
			DebugDura = CAMPING_DURABILITY
		elseif DEBUGOPTIONS == "Book" then
			DebugTag = "TweakBook"
			DebugDura = BOOK_DURABILITY
		elseif DEBUGOPTIONS == "Food" then
			if FOOD_SELECTION == "Preserved" then 
				DebugTag = "TweakJerky"
			else
				DebugTag = "TweakFood"
			end
			DebugDura = FOOD_PRESERVATION
		elseif DEBUGOPTIONS == "Boat" then
			DebugTag = "TweakBoat"
			DebugDura = BOAT_DURABILITY
		end
	end

	if inst:HasTag(DebugTag) then
		print(inst.name.. " - Tweaked. Durability: " .. DebugDura .. ". " .. current .. " durability left.")
	end
end

--[[MODNOTE: End Mod Debug Function ]]--

local FiniteUses = Class(function(self, inst)
    self.inst = inst
    self.total = 100
    self.current = 100
    self.consumption = {}
end)

function FiniteUses:SetConsumption(action, uses)
    self.consumption[action] = uses
end

function FiniteUses:GetDebugString()
	return string.format("%d/%d", self.current, self.total)
end

function FiniteUses:OnSave()
    if self.current ~= self.total then
        return {uses = self.current}
    end
end

function FiniteUses:OnLoad(data)
    if data.uses then
        self:SetUses(data.uses)
    end
end


function FiniteUses:SetMaxUses(val)
    self.total = val
end

function FiniteUses:SetUses(val)
    local was_positive = self.current > 0
    self.current = val
    self.inst:PushEvent("percentusedchange", {percent = self:GetPercent()})    
    if self.current <= 0 then
        self.current = 0
        if was_positive and self.onfinished then
            self.onfinished(self.inst)
        end
    end
    
end

function FiniteUses:GetUses()
    return self.current
end

function FiniteUses:Use(num)
	--[[MODNOTE: This section deals with the update math, which is where tweak will be applied]]--
	--[[self:SetUses(self.current - (num or 1))]]--  Original Text for this section
	
	--[[Get the tags for the item currently being processed, and change our variable to match]]--
	local DURABILITYSETTING = "Default"
			
	if self.inst:HasTag("TweakClothes") then
		DURABILITYSETTING = CLOTHING_DURABILITY
	elseif self.inst:HasTag("TweakWeapon") then
		DURABILITYSETTING = WEAPON_DURABILITY
	elseif self.inst:HasTag("TweakStaff") then
		DURABILITYSETTING = STAFF_DURABILITY
	elseif self.inst:HasTag("TweakAmulet") then
		DURABILITYSETTING = AMULET_DURABILITY
	elseif self.inst:HasTag("TweakTool") then
		DURABILITYSETTING = TOOL_DURABILITY
	elseif self.inst:HasTag("TweakGold") then
		DURABILITYSETTING = GOLD_DURABILITY
	elseif self.inst:HasTag("TweakTrap") then
		DURABILITYSETTING = TRAP_DURABILITY
	elseif self.inst:HasTag("TweakArmor") then
		DURABILITYSETTING = ARMOR_DURABILITY
	elseif self.inst:HasTag("TweakLight") then
		DURABILITYSETTING = LIGHT_DURABILITY
	elseif self.inst:HasTag("TweakCamping") then
		DURABILITYSETTING = CAMPING_DURABILITY
	elseif self.inst:HasTag("TweakBook") then
		DURABILITYSETTING = BOOK_DURABILITY
	elseif self.inst:HasTag("TweakJerky") then
		DURABILITYSETTING = FOOD_PRESERVATION
	elseif self.inst:HasTag("TweakFood") then
		DURABILITYSETTING = FOOD_PRESERVATION
	elseif self.inst:HasTag("TweakBoat") then
				DURABILITYSETTING = BOAT_DURABILITY
	end
	
	if DURABILITYSETTING ~= "Default" then
		if DURABILITYSETTING == "Infinite" then
			self:SetUses(self.current)
		else
			self:SetUses(self.current - ((num or 1) / DURABILITYSETTING))
		end
	else
		self:SetUses(self.current - (num or 1))
	end
	
	ModDeBug(self.inst,self.current)  --[[MODNOTE: Send Debug Message as requested by mod]]--
	--[[MODNOTE: End of Modded Section]]--	
end

function FiniteUses:OnUsedAsItem(action)
    local uses = self.consumption[action]
    if uses then
        self:Use(uses)
    end
end

function FiniteUses:GetPercent()
    return self.current / self.total
end

function FiniteUses:SetPercent(amount)
    local target = (self.total * amount)
    self:SetUses((target - self.current) + self.current)
end

function FiniteUses:SetOnFinished(fn)
    self.onfinished = fn
end

return FiniteUses