--[[
*********************************************************************************************************
Original coding created by: DMCartz
Massively rewritten by: phixius83
Date: 12/17/15
Description: Tweak the durability for weapons, armor, staffs, amulets, tools, traps, clothing and lights.
*********************************************************************************************************
]]

-- Store information from configuration menu. 
---------------------------------------------
local TUNING = GLOBAL.TUNING

--[[MODNOTE: Mod Variable Declaration ]]--
local WEAPON_DURABILITY = GetModConfigData("WEAPON_DURABILITY")
local STAFF_DURABILITY = GetModConfigData("STAFF_DURABILITY")
local AMULET_DURABILITY = GetModConfigData("AMULET_DURABILITY")
local TOOL_DURABILITY = GetModConfigData("TOOL_DURABILITY")
local GOLD_DURABILITY = GetModConfigData("GOLD_DURABILITY")
local TRAP_DURABILITY = GetModConfigData("TRAP_DURABILITY")
local ARMOR_DURABILITY = GetModConfigData("ARMOR_DURABILITY")
local CLOTHING_DURABILITY = GetModConfigData("CLOTHING_DURABILITY")
local LIGHT_DURABILITY = GetModConfigData("LIGHT_DURABILITY")
local CAMPING_DURABILITY = GetModConfigData("CAMPING_DURABILITY")
local BOOK_DURABILITY = GetModConfigData("BOOK_DURABILITY")
local FOOD_PRESERVATION = GetModConfigData("FOOD_PRESERVATION")
local FOOD_SELECTION = GetModConfigData("FOOD_SELECTION")
local BOAT_DURABILITY = GetModConfigData("BOAT_DURABILITY")
local DEBUGOPTIONS = GetModConfigData("DEBUGOPTIONS")
--[[MODNOTE: End Mod Variables ]]--

--[[
*******************************************************************
Begin code for tuning the durability of each item with percentages!
*******************************************************************
]]

	-- Weapons
	----------
	
	-- Tweak durability based on tag  
	function AddWeaponTag(inst)
		-- Sets up the Tagging function for weapons
				inst:AddTag("TweakWeapon")
	end
	
    AddPrefabPostInit("batbat", AddWeaponTag)
    AddPrefabPostInit("blowdart_fire", AddWeaponTag)
    AddPrefabPostInit("blowdart_pipe", AddWeaponTag)
    AddPrefabPostInit("blowdart_poison", AddWeaponTag)
    AddPrefabPostInit("blowdart_sleep", AddWeaponTag)
    AddPrefabPostInit("boomerang", AddWeaponTag)
    AddPrefabPostInit("cutlass", AddWeaponTag)
    AddPrefabPostInit("hambat", AddWeaponTag)
    AddPrefabPostInit("harpoon", AddWeaponTag)
    AddPrefabPostInit("javelin", AddWeaponTag)
    AddPrefabPostInit("nightstick", AddWeaponTag)
    AddPrefabPostInit("nightsword", AddWeaponTag)
    AddPrefabPostInit("obsidianmachete", AddWeaponTag)
    AddPrefabPostInit("obsidianspeargun", AddWeaponTag)
    AddPrefabPostInit("peg_leg", AddWeaponTag)
    AddPrefabPostInit("ruins_bat", AddWeaponTag)
    AddPrefabPostInit("scythe", AddWeaponTag)
    AddPrefabPostInit("spear", AddWeaponTag)
    AddPrefabPostInit("spear_obsidian", AddWeaponTag)
    AddPrefabPostInit("spear_poison", AddWeaponTag)
    AddPrefabPostInit("spear_wathgrithr", AddWeaponTag)
    AddPrefabPostInit("speargun", AddWeaponTag)
    AddPrefabPostInit("speargun_poison", AddWeaponTag)
    AddPrefabPostInit("staff_tornado", AddWeaponTag)
    AddPrefabPostInit("tentaclespike", AddWeaponTag)
	
	-- Armor
	--------
	function AddArmorTag(inst)
		-- Sets up the Tagging function for Armors
				inst:AddTag("TweakArmor")
	end
	
	AddPrefabPostInit("armor_limestone", AddArmorTag)
	AddPrefabPostInit("armor_sanity", AddArmorTag)
	AddPrefabPostInit("armordragonfly", AddArmorTag)
	AddPrefabPostInit("armorgrass", AddArmorTag)
	AddPrefabPostInit("armorobsidian", AddArmorTag)
	AddPrefabPostInit("armorruins", AddArmorTag)
	AddPrefabPostInit("armorseashell", AddArmorTag)
	AddPrefabPostInit("armorsnurtleshell", AddArmorTag)
	AddPrefabPostInit("armorwood", AddArmorTag)
	AddPrefabPostInit("beefalo_hide", AddArmorTag)
	AddPrefabPostInit("beehat", AddArmorTag)
	AddPrefabPostInit("footballhat", AddArmorTag)
	AddPrefabPostInit("ruinshat", AddArmorTag)
	AddPrefabPostInit("slurtlehat", AddArmorTag)
	AddPrefabPostInit("wathgrithrhat", AddArmorTag)
	
	-- Staffs
	---------
	function AddStaffTag(inst)
		-- Sets up the Tagging function for Staves
				inst:AddTag("TweakStaff")
	end
	
    AddPrefabPostInit("firestaff", AddStaffTag)
    AddPrefabPostInit("greenstaff", AddStaffTag)
    AddPrefabPostInit("icestaff", AddStaffTag)
    AddPrefabPostInit("orangestaff", AddStaffTag)
    AddPrefabPostInit("telestaff", AddStaffTag)
    AddPrefabPostInit("volcanostaff", AddStaffTag)
    AddPrefabPostInit("yellowstaff", AddStaffTag)
	
	-- Amulets
	----------
	function AddAmuletTag(inst)
		-- Sets up the Tagging function for Amulets
			inst:AddTag("TweakAmulet")
	end
	
	AddPrefabPostInit("amulet", AddAmuletTag)
	AddPrefabPostInit("blueamulet", AddAmuletTag)
	AddPrefabPostInit("greenamulet", AddAmuletTag)
	AddPrefabPostInit("yellowamulet", AddAmuletTag)
	AddPrefabPostInit("purpleamulet", AddAmuletTag)
	AddPrefabPostInit("orangeamulet", AddAmuletTag)
	
	-- Tools
	--------
	function AddToolTag(inst)
		-- Sets up the Tagging function for Tools
				inst:AddTag("TweakTool")
	end
	
    AddPrefabPostInit("axe", AddToolTag)
    AddPrefabPostInit("bell", AddToolTag)
    AddPrefabPostInit("boatrepairkit", AddToolTag)
    AddPrefabPostInit("bugnet", AddToolTag)
    AddPrefabPostInit("compass", AddToolTag)
    AddPrefabPostInit("featherfan", AddToolTag)
    AddPrefabPostInit("fertilizer", AddToolTag)
    AddPrefabPostInit("firesuppressor", AddToolTag)
    AddPrefabPostInit("fishingrod", AddToolTag)
    AddPrefabPostInit("hammer", AddToolTag)
    AddPrefabPostInit("horn", AddToolTag)
    AddPrefabPostInit("icemaker", AddToolTag)
    AddPrefabPostInit("machete", AddToolTag)
    AddPrefabPostInit("monkeyball", AddToolTag)
    AddPrefabPostInit("multitool_axe_pickaxe", AddToolTag)
    AddPrefabPostInit("obsidianaxe", AddToolTag)
    AddPrefabPostInit("panflute", AddToolTag)
    AddPrefabPostInit("pickaxe", AddToolTag)
    AddPrefabPostInit("pitchfork", AddToolTag)
    AddPrefabPostInit("seatrap", AddToolTag)
    AddPrefabPostInit("sewing_kit", AddToolTag)
    AddPrefabPostInit("shovel", AddToolTag)
    AddPrefabPostInit("supertelescope", AddToolTag)
    AddPrefabPostInit("telescope", AddToolTag)
	
	function AddGoldTag(inst)
		-- Sets up the Tagging function for Tools
				inst:AddTag("TweakGold")
	end
	
    AddPrefabPostInit("goldenaxe", AddGoldTag)
    AddPrefabPostInit("goldenmachete", AddGoldTag)
    AddPrefabPostInit("goldenpickaxe", AddGoldTag)
    AddPrefabPostInit("goldenshovel", AddGoldTag)                                                                                                                                                                                         
	  
	-- Traps
	--------
	function AddTrapTag(inst)
		-- Sets up the Tagging function for Traps
				inst:AddTag("TweakTrap")
	end
	
    AddPrefabPostInit("trap", AddTrapTag)
    AddPrefabPostInit("birdtrap", AddTrapTag)
    AddPrefabPostInit("trap_teeth", AddTrapTag)
	
	
	-- Clothes
	----------
	function AddClothesTag(inst)
		-- Sets up the Tagging function for Clothes
				inst:AddTag("TweakClothes")
	end
		
    AddPrefabPostInit("aerodynamichat", AddClothesTag)
    AddPrefabPostInit("armor_lifejacket", AddClothesTag)
    AddPrefabPostInit("armor_snakeskin", AddClothesTag)
    AddPrefabPostInit("armor_windbreaker", AddClothesTag)
    AddPrefabPostInit("armorslurper", AddClothesTag)
    AddPrefabPostInit("beargervest", AddClothesTag)
    AddPrefabPostInit("beefalohat", AddClothesTag)
    AddPrefabPostInit("blubbersuit", AddClothesTag)
    AddPrefabPostInit("brainjellyhat", AddClothesTag)
    AddPrefabPostInit("captainhat", AddClothesTag)
    AddPrefabPostInit("catcoonhat", AddClothesTag)
    AddPrefabPostInit("double_umbrellahat", AddClothesTag)
    AddPrefabPostInit("earmuffshat", AddClothesTag)
    AddPrefabPostInit("eyebrellahat", AddClothesTag)
    AddPrefabPostInit("featherhat", AddClothesTag)
    AddPrefabPostInit("flowerhat", AddClothesTag)
    AddPrefabPostInit("gashat", AddClothesTag)
    AddPrefabPostInit("grass_umbrella", AddClothesTag)
    AddPrefabPostInit("hawaiianshirt", AddClothesTag)
    AddPrefabPostInit("icehat", AddClothesTag)
    AddPrefabPostInit("onemandband", AddClothesTag)
    AddPrefabPostInit("palmleaf_umbrella", AddClothesTag)
    AddPrefabPostInit("piratehat", AddClothesTag)
    AddPrefabPostInit("raincoat", AddClothesTag)
    AddPrefabPostInit("rainhat", AddClothesTag)
    AddPrefabPostInit("reflectivevest", AddClothesTag)
    AddPrefabPostInit("snakeskinhat", AddClothesTag)
    AddPrefabPostInit("spiderhat", AddClothesTag)
    AddPrefabPostInit("strawhat", AddClothesTag)
    AddPrefabPostInit("sweatervest", AddClothesTag)
    AddPrefabPostInit("tophat", AddClothesTag)
    AddPrefabPostInit("trunkvest_summer", AddClothesTag)
    AddPrefabPostInit("trunkvest_winter", AddClothesTag)
    AddPrefabPostInit("umbrella", AddClothesTag)
    AddPrefabPostInit("walrushat", AddClothesTag)
    AddPrefabPostInit("watermelonhat", AddClothesTag)
    AddPrefabPostInit("winterhat", AddClothesTag)

	
	-- Light
	--------
	function AddLightTag(inst)
		-- Sets up the Tagging function for Light Sources
				inst:AddTag("TweakLight")
	end
	
    AddPrefabPostInit("boat_lantern", AddLightTag)
    AddPrefabPostInit("boat_torch", AddLightTag)
    AddPrefabPostInit("bottlelantern", AddLightTag)
    AddPrefabPostInit("lantern", AddLightTag)
    AddPrefabPostInit("minerhat", AddLightTag)
    AddPrefabPostInit("molehat", AddLightTag)
    AddPrefabPostInit("nightlight", AddLightTag)
    AddPrefabPostInit("pumpkin_lantern", AddLightTag)
    AddPrefabPostInit("torch", AddLightTag)
	
	-- Camping
	----------
	function AddCampingTag(inst)
		-- Sets up the Tagging function for Camping
				inst:AddTag("TweakCamping")
	end

	function AddPitTag(inst)
		-- Sets up the Tagging function to identify Fire Pits.  This is so that when infinite is set, they can decay past massive blaze, but not below regular fire
			inst:AddTag("TweakPit")
	end
		
    AddPrefabPostInit("bedroll_furry", AddCampingTag)
    AddPrefabPostInit("bedroll_straw", AddCampingTag)
    AddPrefabPostInit("campfire", AddCampingTag)
    AddPrefabPostInit("chiminea", AddCampingTag)
    AddPrefabPostInit("coldfire", AddCampingTag)
    AddPrefabPostInit("coldfirepit", AddCampingTag)
    AddPrefabPostInit("deluxe_firepit", AddCampingTag)
    AddPrefabPostInit("endo_firepit", AddCampingTag)
    AddPrefabPostInit("endothermic_torch", AddCampingTag)
    AddPrefabPostInit("firepit", AddCampingTag)
    AddPrefabPostInit("heat_star", AddCampingTag)
    AddPrefabPostInit("ice_star", AddCampingTag)
    AddPrefabPostInit("obsidianfirepit", AddCampingTag)
    AddPrefabPostInit("palmleaf_hut", AddCampingTag)
    AddPrefabPostInit("siestahut", AddCampingTag)
    AddPrefabPostInit("tent", AddCampingTag)
	
    AddPrefabPostInit("campfire", AddPitTag)
    AddPrefabPostInit("chiminea", AddPitTag)
    AddPrefabPostInit("coldfire", AddPitTag)
    AddPrefabPostInit("coldfirepit", AddPitTag)
    AddPrefabPostInit("deluxe_firepit", AddPitTag)
    AddPrefabPostInit("endo_firepit", AddPitTag)
    AddPrefabPostInit("endothermic_torch", AddPitTag)
    AddPrefabPostInit("firepit", AddPitTag)
    AddPrefabPostInit("heat_star", AddPitTag)
    AddPrefabPostInit("ice_star", AddPitTag)
    AddPrefabPostInit("obsidianfirepit", AddPitTag)
	
	-- Librarian's Books
	----------
	function AddBookTag(inst)
		-- Sets up the Tagging function for Camping
				inst:AddTag("TweakBook")
	end
	
    AddPrefabPostInit("book_birds", AddBookTag)
    AddPrefabPostInit("book_brimstone", AddBookTag)
    AddPrefabPostInit("book_gardening", AddBookTag)
    AddPrefabPostInit("book_sleep", AddBookTag)
    AddPrefabPostInit("book_tentacles", AddBookTag)
	
	-- Dried Meats
	----------
	function AddJerkyTag(inst)
		-- Sets up the Tagging function for preserved foods
				inst:AddTag("TweakJerky")
	end
	
    AddPrefabPostInit("jellyjerky", AddJerkyTag)
    AddPrefabPostInit("meat_dried", AddJerkyTag)
    AddPrefabPostInit("monstermeat_dried", AddJerkyTag)
    AddPrefabPostInit("seaweed_dried", AddJerkyTag)
    AddPrefabPostInit("smallmeat_dried", AddJerkyTag)
	
		-- All Other Food
	----------
	function AddFoodTag(inst)
		-- Sets up the Tagging function for preserved foods
				inst:AddTag("TweakFood")
	end
	
	if FOOD_SELECTION == "All" then			-- Check to see if we're applying this tweak to all foods, and if so, go nuts
    AddPrefabPostInit("acorn_cooked", AddFoodTag)
    AddPrefabPostInit("baconeggs", AddFoodTag)
    AddPrefabPostInit("bananapop", AddFoodTag)
    AddPrefabPostInit("batwing", AddFoodTag)
    AddPrefabPostInit("batwing_cooked", AddFoodTag)
    AddPrefabPostInit("berries", AddFoodTag)
    AddPrefabPostInit("berries_cooked", AddFoodTag)
    AddPrefabPostInit("bird_egg", AddFoodTag)
    AddPrefabPostInit("bird_egg_cooked", AddFoodTag)
    AddPrefabPostInit("bisque", AddFoodTag)
    AddPrefabPostInit("blue_cap", AddFoodTag)
    AddPrefabPostInit("blue_cap_cooked", AddFoodTag)
    AddPrefabPostInit("bonestew", AddFoodTag)
    AddPrefabPostInit("butter", AddFoodTag)
    AddPrefabPostInit("butterflymuffin", AddFoodTag)
    AddPrefabPostInit("butterflywings", AddFoodTag)
    AddPrefabPostInit("cactus_flower", AddFoodTag)
    AddPrefabPostInit("cactus_meat", AddFoodTag)
    AddPrefabPostInit("cactus_meat_cooked", AddFoodTag)
    AddPrefabPostInit("californiaroll", AddFoodTag)
    AddPrefabPostInit("carrot", AddFoodTag)
    AddPrefabPostInit("carrot_cooked", AddFoodTag)
    AddPrefabPostInit("carrot_seeds", AddFoodTag)
    AddPrefabPostInit("cave_banana", AddFoodTag)
    AddPrefabPostInit("cave_banana_cooked", AddFoodTag)
    AddPrefabPostInit("ceviche", AddFoodTag)
    AddPrefabPostInit("coconut", AddFoodTag)
    AddPrefabPostInit("coconut_cooked", AddFoodTag)
    AddPrefabPostInit("coffee", AddFoodTag)
    AddPrefabPostInit("cookedmeat", AddFoodTag)
    AddPrefabPostInit("cookedmonstermeat", AddFoodTag)
    AddPrefabPostInit("cookedsmallmeat", AddFoodTag)
    AddPrefabPostInit("coral_brain", AddFoodTag)
    AddPrefabPostInit("corn", AddFoodTag)
    AddPrefabPostInit("corn_cooked", AddFoodTag)
    AddPrefabPostInit("corn_seeds", AddFoodTag)
    AddPrefabPostInit("cutlichen", AddFoodTag)
    AddPrefabPostInit("dead_swordfish", AddFoodTag)
    AddPrefabPostInit("dragonfruit", AddFoodTag)
    AddPrefabPostInit("dragonfruit_cooked", AddFoodTag)
    AddPrefabPostInit("dragonfruit_seeds", AddFoodTag)
    AddPrefabPostInit("dragonpie", AddFoodTag)
    AddPrefabPostInit("drumstick", AddFoodTag)
    AddPrefabPostInit("drumstick_cooked", AddFoodTag)
    AddPrefabPostInit("durian", AddFoodTag)
    AddPrefabPostInit("durian_cooked", AddFoodTag)
    AddPrefabPostInit("durian_seeds", AddFoodTag)
    AddPrefabPostInit("eel", AddFoodTag)
    AddPrefabPostInit("eel_cooked", AddFoodTag)
    AddPrefabPostInit("eggplant", AddFoodTag)
    AddPrefabPostInit("eggplant_cooked", AddFoodTag)
    AddPrefabPostInit("eggplant_seeds", AddFoodTag)
    AddPrefabPostInit("fish", AddFoodTag)
    AddPrefabPostInit("fish_cooked", AddFoodTag)
    AddPrefabPostInit("fish_med", AddFoodTag)
    AddPrefabPostInit("fish_med_cooked", AddFoodTag)
    AddPrefabPostInit("fish_raw", AddFoodTag)
    AddPrefabPostInit("fish_raw_small", AddFoodTag)
    AddPrefabPostInit("fish_raw_small_cooked", AddFoodTag)
    AddPrefabPostInit("fishsticks", AddFoodTag)
    AddPrefabPostInit("fishtacos", AddFoodTag)
    AddPrefabPostInit("flowersalad", AddFoodTag)
    AddPrefabPostInit("foliage", AddFoodTag)
    AddPrefabPostInit("frogglebunwich", AddFoodTag)
    AddPrefabPostInit("froglegs", AddFoodTag)
    AddPrefabPostInit("froglegs_cooked", AddFoodTag)
    AddPrefabPostInit("fruitmedley", AddFoodTag)
    AddPrefabPostInit("goatmilk", AddFoodTag)
    AddPrefabPostInit("green_cap", AddFoodTag)
    AddPrefabPostInit("green_cap_cooked", AddFoodTag)
    AddPrefabPostInit("guacamole", AddFoodTag)
    AddPrefabPostInit("honey", AddFoodTag)
    AddPrefabPostInit("honeyham", AddFoodTag)
    AddPrefabPostInit("honeynuggets", AddFoodTag)
    AddPrefabPostInit("hotchili", AddFoodTag)
    AddPrefabPostInit("ice", AddFoodTag)
    AddPrefabPostInit("icecream", AddFoodTag)
    AddPrefabPostInit("jammypreserves", AddFoodTag)
    AddPrefabPostInit("jellyfish_cooked", AddFoodTag)
    AddPrefabPostInit("jellyfish_dead", AddFoodTag)
    AddPrefabPostInit("jellyopop", AddFoodTag)
    AddPrefabPostInit("kabobs", AddFoodTag)
    AddPrefabPostInit("lightbulb", AddFoodTag)
    AddPrefabPostInit("limpets", AddFoodTag)
    AddPrefabPostInit("limpets_cooked", AddFoodTag)
    AddPrefabPostInit("lobsterbisque", AddFoodTag)
    AddPrefabPostInit("lobsterdinner", AddFoodTag)
    AddPrefabPostInit("mandrakesoup", AddFoodTag)
    AddPrefabPostInit("meat", AddFoodTag)
    AddPrefabPostInit("meatballs", AddFoodTag)
    AddPrefabPostInit("monsterlasagna", AddFoodTag)
    AddPrefabPostInit("monstermeat", AddFoodTag)
    AddPrefabPostInit("mussel", AddFoodTag)
    AddPrefabPostInit("mussel_cooked", AddFoodTag)
    AddPrefabPostInit("perogies", AddFoodTag)
    AddPrefabPostInit("petals", AddFoodTag)
    AddPrefabPostInit("petals_evil", AddFoodTag)
    AddPrefabPostInit("plantmeat", AddFoodTag)
    AddPrefabPostInit("plantmeat_cooked", AddFoodTag)
    AddPrefabPostInit("pomegranate", AddFoodTag)
    AddPrefabPostInit("pomegranate_cooked", AddFoodTag)
    AddPrefabPostInit("pomegranate_seeds", AddFoodTag)
    AddPrefabPostInit("powcake", AddFoodTag)
    AddPrefabPostInit("pumpkin", AddFoodTag)
    AddPrefabPostInit("pumpkin_cooked", AddFoodTag)
    AddPrefabPostInit("pumpkin_seeds", AddFoodTag)
    AddPrefabPostInit("pumpkincookie", AddFoodTag)
    AddPrefabPostInit("ratatouille", AddFoodTag)
    AddPrefabPostInit("red_cap", AddFoodTag)
    AddPrefabPostInit("red_cap_cooked", AddFoodTag)
    AddPrefabPostInit("seafoodgumbo", AddFoodTag)
    AddPrefabPostInit("seaweed", AddFoodTag)
    AddPrefabPostInit("seaweed_cooked", AddFoodTag)
    AddPrefabPostInit("seeds", AddFoodTag)
    AddPrefabPostInit("seeds_cooked", AddFoodTag)
    AddPrefabPostInit("shark_fin", AddFoodTag)
    AddPrefabPostInit("sharkfinsoup", AddFoodTag)
    AddPrefabPostInit("smallmeat", AddFoodTag)
    AddPrefabPostInit("stuffedeggplant", AddFoodTag)
    AddPrefabPostInit("surfnturf", AddFoodTag)
    AddPrefabPostInit("sweet_potato", AddFoodTag)
    AddPrefabPostInit("sweet_potato_cooked", AddFoodTag)
    AddPrefabPostInit("sweet_potato_seeds", AddFoodTag)
    AddPrefabPostInit("taffy", AddFoodTag)
    AddPrefabPostInit("tallbirdegg", AddFoodTag)
    AddPrefabPostInit("tallbirdegg_cooked", AddFoodTag)
    AddPrefabPostInit("trailmix", AddFoodTag)
    AddPrefabPostInit("tropical_fish", AddFoodTag)
    AddPrefabPostInit("trunk_cooked", AddFoodTag)
    AddPrefabPostInit("trunk_summer", AddFoodTag)
    AddPrefabPostInit("trunk_winter", AddFoodTag)
    AddPrefabPostInit("turkeydinner", AddFoodTag)
    AddPrefabPostInit("unagi", AddFoodTag)
    AddPrefabPostInit("waffles", AddFoodTag)
    AddPrefabPostInit("watermelon", AddFoodTag)
    AddPrefabPostInit("watermelon_cooked", AddFoodTag)
    AddPrefabPostInit("watermelon_seeds", AddFoodTag)
    AddPrefabPostInit("watermelonicle", AddFoodTag)
    AddPrefabPostInit("wetgoop", AddFoodTag)
    AddPrefabPostInit("wormlight", AddFoodTag)
	end
	
	-- Boats
	----------
	function AddBoatTag(inst)
		-- Sets up the Tagging function for boats
				inst:AddTag("TweakBoat")
	end
	
    AddPrefabPostInit("armouredboat", AddBoatTag)
    AddPrefabPostInit("boatcannon", AddBoatTag)
    AddPrefabPostInit("cargoboat", AddBoatTag)
    AddPrefabPostInit("clothsail", AddBoatTag)
    AddPrefabPostInit("lograft", AddBoatTag)
    AddPrefabPostInit("raft", AddBoatTag)
    AddPrefabPostInit("rowboat", AddBoatTag)
    AddPrefabPostInit("sail", AddBoatTag)
    AddPrefabPostInit("snakeskinsail", AddBoatTag)
    AddPrefabPostInit("surfboard", AddBoatTag)