
local MakePlayerCharacter = require ("prefabs/player_common")

local assets = {
    Asset( "ANIM", "anim/teemo.zip" ),
    Asset( "ANIM", "anim/ghost_teemo_build.zip" ),
}
local prefabs = {}

-- 開始時のアイテム
local start_inv = {
    "noxious_trap",
    "red_cap",
    "red_cap",
    "red_cap",
--    "goldenaxe",
--	  "ruinshat",
--	  "footballhat",
--	  "winterhat",
--	  "flowerhat",
}

local function doPassive(inst)
    --inst.components.talker:Say("DO passive")
    -- 透明になる
    if not inst.isPassive then
        -- パッシブ発動
        inst.isPassive = true
        inst:AddTag("notarget")
        -- 透明度
        inst.AnimState:SetMultColour(.1,.1,.1,.5)
        -- 影なし
        inst.DynamicShadow:Enable(false)
    end

    ---- inst.sg:GoToState("hide")
    local x,y,z = inst.Transform:GetWorldPosition() 
    local ents = TheSim:FindEntities(x, y, z, 20)
    for k,v in pairs(ents) do
        if v.components.combat and v.components.combat.target == inst then
            -- 攻撃対象ではなくなる
            -- v.components.combat.target = nil

            -- passive発動中はteemoに攻撃出来ない（1秒
            v.components.combat:BlankOutAttacks(1.0)
        end
    end
end

local function doUnPassive(inst)
    --inst.components.talker:Say("UN passive")
    -- パッシブが発動してなければなにもしない
    if not inst.isPassive then return end

    -- パッシブ解除
    inst.isPassive = false
    inst:RemoveTag("notarget")
    -- 透明解除
    inst.AnimState:SetMultColour(1.0,1.0,1.0,1.0)
    -- 影あり
    inst.DynamicShadow:Enable(true)

    -- 透明パッシブが切れると3秒間攻撃速度40%アップ
    inst.components.combat.min_attack_period = TUNING.WILSON_ATTACK_PERIOD - (TUNING.WILSON_ATTACK_PERIOD * 0.4)
    inst:DoTaskInTime(3.0, function(inst)
        inst.components.combat.min_attack_period = TUNING.WILSON_ATTACK_PERIOD
    end, inst)
end

local function updatePassiveStat(inst)
    -- local pos = Vector3(inst.Transform:GetWorldPosition())
    -- inst.passive_p = pos
    inst.passive_t = GetTime()
    inst.passive_h = inst.components.health.currenthealth
end

local function initPassive(inst)
    doUnPassive(inst)
    updatePassiveStat(inst)


    -- -- teemoがいたぞ
    -- local x,y,z = inst.Transform:GetWorldPosition() 
    -- local ents = TheSim:FindEntities(x, y, z, 10)
    -- for k,v in pairs(ents) do
    --     if v.components.combat then
    --         -- teemoを攻撃対象にする
    --         v.components.combat:SuggestTarget(inst)
    --     end
    -- end
end

local function checkPassive(inst)
    
    -- SAN値が3割を切っている場合はパッシブ無効
    if inst.components.sanity:GetPercent() < .3 then
        initPassive(inst)
        return
    end

    -- ヘルスが減っていたらパッシブ無効
    if inst.components.health.currenthealth < inst.passive_h then
        initPassive(inst)
        return
    end

    -- 左クリックを押してる間はパッシブ無効
    if TheInput:IsControlPressed(CONTROL_PRIMARY) then
        initPassive(inst)
        return
    end

    -- 移動しているか確認
    -- local pos = Vector3(inst.Transform:GetWorldPosition())
    -- if pos == inst.passive_p then
    local running = inst.components.locomotor:WantsToRun()
    if not running then
        -- 2秒間動かない場合はパッシブ発動
        if GetTime() - inst.passive_t > 2.0 then doPassive(inst) end
    else
        initPassive(inst)
    end
end

local function onKeyEvent(inst)
    initPassive(inst)
end

local function onPrimaryKeyEvent(inst)
    initPassive(inst)
end

local function onSecondaryKeyEvent(inst)
    initPassive(inst)
end

-- local function isDead(inst)
--     if inst:HasTag("playerghost") then
--          print("playerghost")
--         return true
--     end
--     if inst.ghostenabled then
--          print("ghostenabled")
--         return true
--     end
--     return false
-- end

local function onAttacked(inst, data)
    -- 攻撃を受けたら移動速度アップ無効
    inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED

    -- 死んでたら移動速度は戻らない
    -- if isDead(inst) then return end

    -- 5秒後にパッシブ発動
    inst.doMoveQuick = inst:DoTaskInTime(5.0, function(inst)
        inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * 1.26
    end, inst)
end

local function stopPassive(inst)
    if inst.passiveTask ~= nil then
        inst.passiveTask:Cancel()
        inst.passiveTask = nil
    end

    if inst.doMoveQuick ~= nil then
        inst.doMoveQuick:Cancel()
        inst.doMoveQuick = nil
    end

    inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED
end

local function startPassive(inst)
    -- パッシブタスクが起動してたら無効にする
    stopPassive(inst)

    -- パッシブ用の変数
    inst.isPassive = false
    initPassive(inst)
    -- Camouflage(透明になるパッシブ)
    inst.passiveTask = inst:DoPeriodicTask(1.0, checkPassive)
    -- Move Quick(足早パッシブ)
    inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * 1.26
end

local function onDeath(inst, data)
    inst.deathcause = data ~= nil and data.cause or "unknown"
    if inst.deathcause == "file_load" then
        return
    end
    stopPassive(inst)
end

local function restoreStat(inst)
    startPassive(inst)
end

-- local function onKilled(inst, data)
-- end

-- local function onAttackOther(inst, data)
-- end

-- local function test(inst)
--     inst.components.talker:Say("8:["..inst.components.sanity.ghost_drain_mult.."]")
-- end

-- ホストとクライアント両方の設定
local common_postinit = function(inst)
    -- "wilson", "willow", "wolfgang", "wendy", "wx78", "wickerbottom", "woodie", "wes", "waxwell"
	inst.soundsname = "teemo"
	-- ミニマップの見た目
	inst.MiniMapEntity:SetIcon( "teemo.tex" )
end

-- ホストの設定
local master_postinit = function(inst)

    -- ユニークアイテム作成者
	inst:AddTag("noxious_trap_builder")
    -- 自分の罠にかからない為のタグ(SetAlignment())
	inst:AddTag("teemo")
	
	-- 能力設定(カッコ内は通常値)
    -- 最大ヘルス
	inst.components.health:SetMaxHealth(100)
    -- 最大お腹
	inst.components.hunger:SetMax(100)
    -- 最大SAN値
	inst.components.sanity:SetMax(100)

    -- 攻撃間隔 (0.1)秒以上開いていれば次の攻撃を行える
    -- inst.components.combat.min_attack_period = TUNING.WILSON_ATTACK_PERIOD
    -- -- ダメージレート（武器ダメ*レート）？ (1.0?)
    -- inst.components.combat.damagemultiplier = 1.0
    -- -- 殴りダメージ
    -- inst.components.combat.defaultdamage = 10
    -- -- 最高体温(40)
    -- inst.components.temperature.maxtemp = 40
    -- -- 最低体温(-20)
    -- inst.components.temperature.mintemp = -20
    -- -- お腹の減りやすさ(calories_per_day(75)/total_day_time(30*16) = 0.15625)
    -- inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE
    -- -- お腹が減っている時のダメージレート(1.25?)
    -- inst.components.hunger.hurtrate = TUNING.WILSON_HEALTH/TUNING.STARVE_KILL_TIME
    -- -- 歩くスピード(4.0)
    -- inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED
    -- -- 走るスピード(6.0)
    -- inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * 1.26
    -- -- 夜のSAN値減少度？(1.0)
    -- inst.components.sanity.night_drain_mult = 1.0
    -- -- ゴーストSAN値減少度？(0.0)
    -- inst.components.sanity.ghost_drain_mult = 0

    -- 無敵(false)
    -- inst.components.health.invincible = true

    -- パッシブスタート
    startPassive(inst)

    -- 攻撃イベントリスナ
    -- inst:ListenForEvent("onattackother", onAttackOther)
    -- イベントリスナ解除の場合
    --owner:RemoveEventCallback("onattackother", OnAttackOther)

    -- モンスターを倒した場合のイベントリスナ
    --inst:ListenForEvent("killed", onKilled)

    -- ?秒後に処理実行
    -- inst.test = inst:DoTaskInTime(10, test)

    -- PVPモードかどうか
    -- print(TheNet:GetPVPEnabled())

    -- 何かしらのキー入力した場合のイベント
    inst.keyHandler = TheInput:AddKeyHandler(function(key, down) onKeyEvent(inst) end)
    -- 左クリックを押した場合のイベント
    inst.primaryHandler = TheInput:AddControlHandler(CONTROL_PRIMARY, function() onPrimaryKeyEvent(inst) end)
    -- 右クリックを押した場合のイベント
    inst.secondaryHandler = TheInput:AddControlHandler(CONTROL_SECONDARY, function() onSecondaryKeyEvent(inst) end)
    -- マウスを動かした場合のイベント
    -- inst.moveHandler = TheInput:AddMouseButtonHandler(function() initPassive(inst) end )
    -- inst.keyHandler:Remove()
    -- inst.keyHandler = nil

    -- 攻撃を受けた時のイベント
    inst:ListenForEvent("attacked", onAttacked)

    -- 死んだ時のイベント
    inst:ListenForEvent("death", onDeath)

    -- 生き返った時のイベント
    inst:ListenForEvent("respawnfromghost", restoreStat)


end

return MakePlayerCharacter("teemo", prefabs, assets, common_postinit, master_postinit, start_inv)
