local assets=
{
	Asset("ANIM", "anim/noxious_trap.zip"),
	
	Asset("IMAGE", "images/inventoryimages/noxious_trap.tex"),
	Asset("ATLAS", "images/inventoryimages/noxious_trap.xml"),
}

local prefabs ={"explode_noxious_trap"}

local function onExplode(inst, target)
	-- 爆発エフェクト
	-- local pos = Vector3(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_explo")
	local explode = SpawnPrefab("explode_noxious_trap")
	-- local pos = inst:GetPosition()
	explode.Transform:SetPosition(inst.Transform:GetWorldPosition())
	-- ダメージ
	inst.components.explosive_noxious_trap:OnBurnt()
end

local function onReset(inst)
	-- 罠設置時に明るくする
	local light = inst.entity:AddLight()
    light:SetFalloff(0.9)
    light:SetIntensity(0.9)
    light:SetColour(155/255, 225/255, 250/255)
    light:SetRadius(1.5)
--    light:Enable(true)

	-- 半透明にする
	inst.AnimState:SetMultColour(.4,.4,.4,.4)

	-- 設置音
    --inst.SoundEmitter:PlaySound("dontstarve/creatures/krampus/bag_drop")
    inst.SoundEmitter:PlaySound("dontstarve/creatures/mandrake/pop")
    
    -- 設置アニメーション
	-- inst.AnimState:PlayAnimation("reset")
	-- inst.AnimState:PushAnimation("idle", false)
	
	-- 設置したらインベントリに入れられないように
	inst:RemoveComponent("inventoryitem")
end

local function setInactive(inst)
	-- inst.AnimState:PlayAnimation("inactive")

	-- 明るさを戻す
	local light = inst.entity:AddLight()
    light:SetFalloff(0)
    light:SetIntensity(0)
--    light:SetColour(155/255, 225/255, 250/255)
    light:SetRadius(0)
--    light:Enable(true)
    
    -- 半透明を戻す
    inst.AnimState:SetMultColour(1.0,1.0,1.0,1.0)
end

local function setSprung(inst)
    -- inst.AnimState:PlayAnimation(3)
    -- inst.AnimState:PlayAnimation("trap_idle")
end

local function onDropped(inst)
	-- inst.components.mine:Deactivate()
	setInactive(inst)
end

-- -- 揺らす
-- local function mineRattle(inst)
--     -- inst.AnimState:PlayAnimation("hit")
--     inst.AnimState:PushAnimation(math.random(4))
--     -- inst.AnimState:PushAnimation("idle")
--     -- inst.SoundEmitter:PlaySound("dontstarve/bee/beemine_rattle")
--     if inst.rattletask then
--         inst.rattletask:Cancel()
--     end
--     inst.rattletask = inst:DoTaskInTime(4 + math.random(), mineRattle)
-- end

-- local function startRattling(inst)
--     inst.rattletask = inst:DoTaskInTime(1, mineRattle)
-- end


local function mineTest(inst)
    -- local mine = inst.components.mine
  --   local notags = {"notraptrigger", "flying"}
  --   if mine and mine.alignment then
		-- table.insert(notags, mine.alignment)
  --   end
  --   if mine and mine.radius then
  --       local target = FindEntity(inst, mine.radius, mine.mine_test_fn, nil, notags, mine.mine_test_tags)
  --       if target then
	 --    	mine:Explode(target)
  --       end
  --   end
	-- local mine_test_tags = {"monster", "character", "animal"}

	-- 10分経過したら終了
	-- print(GetTime())
	if GetTime() - inst.deployStartTime >= 600 then
	    stopSearchTask(inst)
	    inst:Remove()
	    return
	end

	-- 爆発の対象は飛んでいるやつも虫も全て対象にする
    local x, y, z = inst.Transform:GetWorldPosition()
    local ents = TheSim:FindEntities(x, y, z, 2.0)
    for k, v in pairs(ents) do
    	if v:HasTag("monster") or v:HasTag("character")
    		or v:HasTag("animal") or v:HasTag("shadowcreature")
    		or v:HasTag("largecreature") or v:HasTag("smallcreature")
    		or v:HasTag("insect") then

    		-- プレイヤーは爆発対象外
	    	if not v:HasTag("player") then
	    		-- stopSearchTask(inst)
	    		onExplode(inst, v)
	    		-- mine:Explode(v)
	    		break
	    	end
    	end
    end
end

function stopSearchTask(inst)
    if inst.searchtask then
        inst.searchtask:Cancel()
        inst.searchtask = nil
    end
end

-- mineの間隔が糞なので作成
local function reset(inst)
	-- local mine = inst.components.mine
	-- -- mine:Reset()
	-- -- mine:StopTesting()

 --    mine:StopTesting()
 --    mine.target = nil
 --    mine.issprung = false
 --    mine.inactive = false
 --    if mine.onreset then
 --        mine.onreset(mine.inst)
 --    end
 	inst.deployStartTime = GetTime()
 	onReset(inst)
    stopSearchTask(inst)
    -- 0.3秒毎にmineTest実行（設置後2秒間は発動しない）
	inst.searchtask = inst:DoPeriodicTask(.3, mineTest, 2.0)
end

local function ondeploy(inst, pt, deployer)
	reset(inst)
	-- inst.components.mine:Reset()
	inst.Physics:Teleport(pt:Get())
	-- startRattling(inst)
end

local function onload(inst, data)
	if not data or not data.mine then
		reset(inst)
		-- inst.components.mine:Reset()
	end
end

local function fn(Sim)
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

	MakeInventoryPhysics(inst)
	
	-- 画像の構成
	inst.AnimState:SetBank("heat_rock")
	-- 実際の画像
	inst.AnimState:SetBuild("noxious_trap")
	-- 画像構成の何番目の画像を表示するか
	inst.AnimState:PlayAnimation(2)
    -- inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )

    -- inst:AddTag("trap")
    -- inst:AddTag("mine")

    -- ホストではない場合はここまで？
    if not TheWorld.ismastersim then
        return inst
    end
	
	inst.entity:SetPristine()

	inst:AddComponent("inspectable")

	-- インベントリアイテム
	inst:AddComponent("inventoryitem")
	-- インベントリ見た目
	inst.components.inventoryitem.atlasname = "images/inventoryimages/noxious_trap.xml"
	-- 跳ねない
    -- inst.components.inventoryitem.nobounce = true
    -- 置いた時のイベント
    inst.components.inventoryitem:SetOnDroppedFn(onDropped)

    -- 地雷
    -- inst:AddComponent("mine")
    -- 発動の範囲（半径） 
    -- inst.components.mine:SetRadius(2) -- TUNING.TRAP_TEETH_RADIUS
    -- 発動イベント
    -- inst.components.mine:SetOnExplodeFn(onExplode)
    -- teemoタグ以外は発動の対象(playerだとプレイヤーが対象外、nobodyは全員対象)
    -- inst.components.mine:SetAlignment("n")
    -- リセットイベント
    -- inst.components.mine:SetOnResetFn(onReset)
	-- インベントリ設定時イベント
    -- inst.components.mine:SetOnDeactivateFn(setInactive)
	-- -- 
 --    inst.components.mine:SetOnSprungFn(setSprung)
	
	-- トラップ設置
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = ondeploy
    inst.components.deployable:SetDeploySpacing(DEPLOYSPACING.LESS)
    
    -- 爆発ダメージ
	inst:AddComponent("explosive_noxious_trap")
	-- inst.components.explosive_noxious_trap.explosivedamage = (TUNING.GUNPOWDER_DAMAGE * 1.5)
	
    -- inst.components.mine:Deactivate()
    setInactive(inst)
    inst.OnLoad = onload
	
	return inst
end

return Prefab( "common/inventory/noxious_trap", fn, assets, prefabs) 
