﻿local assets = {  
    Asset("ANIM", "anim/noxious_dart.zip"),
	Asset("ANIM", "anim/swap_noxious_dart.zip"),

	Asset("IMAGE", "images/inventoryimages/noxious_dart.tex"),
	Asset("ATLAS", "images/inventoryimages/noxious_dart.xml"),
}

local function onequip(inst, owner)

--    owner.components.talker:Say("iiiiiiiiiiiiiiiiiiiiiiiiiiiiii")

    -- 手に持っている時の見た目？
    owner.AnimState:OverrideSymbol("swap_object", "swap_noxious_dart", "swap_ham_bat")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

    -- テーモ以外が装備した場合のペナルティ（SAN値減少）
    if owner.prefab ~= "teemo" then
        inst.components.dapperness.dapperness = TUNING.CRAZINESS_MED * 10
    end

end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function onattack(inst, attacker, target, skipsanity)

    -- ＳＡＮ値減少
    if attacker and attacker.components.sanity and not skipsanity then
        attacker.components.sanity:DoDelta(-1)
    end
    
    if target.components.combat then
        -- 反撃対象になる
        -- target.components.combat:SuggestTarget(attacker)
        -- 2.5秒間攻撃できなくなる
        target.components.combat:BlankOutAttacks(2.5)
        -- target.components.combat.canattack = false
    end
    -- ヒットエフェクト表示
    if target.sg and target.sg.sg.states.hit then
        target.sg:GoToState("hit")
    end
end

local function fn(Sim)
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    -- RemovePhysicsColliders(inst)

    -- 画像の構成
    inst.AnimState:SetBank("ham_bat")
    -- 実際の画像
    inst.AnimState:SetBuild("noxious_dart")
    -- 画像構成の何番目の画像を表示するか
    inst.AnimState:PlayAnimation("idle")

    -- 攻撃の見た目
    inst:AddTag("blowdart")
    -- 攻撃の音に使われてる？
    inst:AddTag("sharp")

    -- ホストではない場合はここまで？
    if not TheWorld.ismastersim then
        return inst
    end
	
    inst.entity:SetPristine()
	
    -- 武器
    inst:AddComponent("weapon")
    -- ダメージ
    inst.components.weapon:SetDamage(1000)
    -- 範囲（攻撃射程、ヒット射程）
    inst.components.weapon:SetRange(8, 10)
    -- 攻撃効果
    inst.components.weapon:SetOnAttack(onattack)
    -- 吹き矢の矢を飛ばす見た目追加
    inst.components.weapon:SetProjectile("blowdart_walrus")


	inst:AddComponent("inspectable")

    -- インベントリ
    inst:AddComponent("inventoryitem")
    -- インベントリの見た目
	inst.components.inventoryitem.atlasname = "images/inventoryimages/noxious_dart.xml"
	
    -- 幽霊の攻撃（ハウント）時の処理？
    -- MakeHauntableLaunchAndPerish(inst)

    -- 装備
    inst:AddComponent("equippable")
    -- 装備イベント
    inst.components.equippable:SetOnEquip(onequip)
    -- 装備外しイベント
    inst.components.equippable:SetOnUnequip(onunequip)

    -- テーモ以外が装備した場合にペナルティつけるため
    inst:AddComponent("dapperness")

    -- 装備者取得
    -- local owner = inst.components.inventoryitem.owner

    return inst
end


return Prefab( "common/inventory/noxious_dart", fn, assets)