GetPlayer = GLOBAL.GetPlayer
local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

PrefabFiles = {
	"teemo",
	--"noxious_dart",
	"noxious_trap",
	"explode_noxious_trap",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/teemo.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/teemo.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/teemo.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/teemo.xml" ),

    Asset( "IMAGE", "bigportraits/teemo.tex" ),
    Asset( "ATLAS", "bigportraits/teemo.xml" ),
	
	Asset( "IMAGE", "images/map_icons/teemo.tex" ),
	Asset( "ATLAS", "images/map_icons/teemo.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_teemo.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_teemo.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_teemo.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_teemo.xml" ),
    
	--Asset( "IMAGE", "images/inventoryimages/noxious_dart.tex" ),
    --Asset( "ATLAS", "images/inventoryimages/noxious_dart.xml" ),
    
	Asset( "IMAGE", "images/inventoryimages/noxious_trap.tex" ),
    Asset( "ATLAS", "images/inventoryimages/noxious_trap.xml" ),

    Asset("SOUNDPACKAGE", "sound/teemo.fev"),
    Asset("SOUND", "sound/teemo.fsb"),
}

RemapSoundEvent( "dontstarve/characters/teemo/death_voice", "teemo/characters/teemo/death_voice" )
RemapSoundEvent( "dontstarve/characters/teemo/hurt", "teemo/characters/teemo/hurt" )
RemapSoundEvent( "dontstarve/characters/teemo/talk_LP", "teemo/characters/teemo/talk_LP" )

-- The character select screen lines
STRINGS.CHARACTER_TITLES.teemo = "Captain Teemo"
STRINGS.CHARACTER_NAMES.teemo = "Captain Teemo"
STRINGS.CHARACTER_DESCRIPTIONS.teemo = "*Camouflage\n*Move Quick\n*Noxious Trap"
STRINGS.CHARACTER_QUOTES.teemo = "\"on duty !! \""

-- Custom speech strings
STRINGS.CHARACTERS.TEEMO = require "speech_teemo"

-- The character's name as appears in-game 
STRINGS.NAMES.TEEMO = "Teemo"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TEEMO = 
{
	GENERIC = "It's Teemo!",
	ATTACKER = "That Teemo looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "Teemo, friend of ghosts.",
	GHOST = "Teemo could use a heart.",
}

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "teemo")


local OldIsRecipeValid = GLOBAL.IsRecipeValid
local function IsRecipeValid(recipe)
	return OldIsRecipeValid(recipe) and
		((GLOBAL.ThePlayer and GLOBAL.ThePlayer:HasTag(recipe.name.."_builder")) or not recipe.tagneeded)
end
GLOBAL.IsRecipeValid = IsRecipeValid


-- キノコレシピ
local noxious_trap = GLOBAL.Recipe("noxious_trap", {GLOBAL.Ingredient("red_cap", 1)}, GLOBAL.RECIPETABS.WAR, GLOBAL.TECH.NONE)
-- レシピアイコン
noxious_trap.atlas = "images/inventoryimages/noxious_trap.xml"
-- レシピアイコン位置を一番上に
noxious_trap.sortkey = -noxious_trap.sortkey
-- 作るにはタグが必要
noxious_trap.tagneeded = true
-- レシピの名前
STRINGS.NAMES.NOXIOUS_TRAP = "Noxious Trap"
-- レシピの説明
STRINGS.RECIPE_DESC.NOXIOUS_TRAP = "Mushroom Trap"

-- アイテムの名前
--STRINGS.NAMES.NOXIOUS_DART = "Noxious Dart"

AddMinimapAtlas("images/map_icons/teemo.xml")
AddModCharacter("teemo")

--AddPrefabPostInit('noxious_dart')
AddPrefabPostInit('noxious_trap')
--require("teemooverseer")